/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.CarpetServer;
import carpet.script.CarpetScriptHost;
import carpet.script.CarpetScriptServer;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.MapValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.settings.ParsedRule;
import carpet.settings.Validator;
import carpet.utils.Messenger;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2164;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_5218;

public class AppStoreManager {
    private static StoreNode APP_STORE_ROOT = StoreNode.folder(null, "");
    private static String scarpetRepoLink = "https://api.github.com/repos/gnembon/scarpet/contents/programs/";

    public static List<String> suggestionsFromPath(String currentPath) throws IOException {
        String[] path = currentPath.split("/");
        StoreNode appKiosk = APP_STORE_ROOT;
        for (String pathElement : path) {
            if (appKiosk.cannotContinueFor(pathElement)) break;
            appKiosk = appKiosk.children.get(pathElement);
        }
        List<String> filteredSuggestions = appKiosk.createPathSuggestions().stream().filter(s -> s.startsWith(currentPath)).collect(Collectors.toList());
        if (filteredSuggestions.size() == 1 && !appKiosk.isLeaf()) {
            return AppStoreManager.suggestionsFromPath(filteredSuggestions.get(0));
        }
        return filteredSuggestions;
    }

    public static int downloadScript(class_2168 source, String path) {
        AppInfo nodeInfo = AppStoreManager.getFileNode(path);
        return AppStoreManager.downloadScript(source, path, nodeInfo, false);
    }

    private static int downloadScript(class_2168 source, String path, AppInfo nodeInfo, boolean useTrash) {
        String code;
        try {
            code = AppStoreManager.getStringFromStream(nodeInfo.url());
        }
        catch (IOException e) {
            throw new class_2164((class_2561)Messenger.c("rb Failed to obtain app file content: " + e.getMessage()));
        }
        if (!AppStoreManager.saveScriptToFile(source, path, nodeInfo.name(), code, false, useTrash)) {
            return 0;
        }
        boolean success = CarpetServer.scriptServer.addScriptHost(source, nodeInfo.name().replaceFirst("\\.sc$", ""), null, true, false, false, nodeInfo.source());
        return success ? 1 : 0;
    }

    public static AppInfo getFileNode(String appPath) {
        return AppStoreManager.getFileNodeFrom(APP_STORE_ROOT, appPath);
    }

    public static AppInfo getFileNodeFrom(StoreNode start, String appPath) {
        String[] path = appPath.split("/");
        StoreNode appKiosk = start;
        try {
            for (String pathElement : Arrays.copyOfRange(path, 0, path.length - 1)) {
                appKiosk = appKiosk.drillDown(pathElement);
            }
            String appName = path[path.length - 1];
            appKiosk.getValue(appName);
            return new AppInfo(appName, appKiosk.getValue(appName), appKiosk);
        }
        catch (IOException e) {
            throw new class_2164((class_2561)Messenger.c("rb '" + appPath + "' is not a valid path to a scarpet app: " + e.getMessage()));
        }
    }

    public static boolean saveScriptToFile(class_2168 source, String path, String appFileName, String code, boolean globalSavePath, boolean useTrash) {
        Path scriptLocation = globalSavePath && !source.method_9211().method_3816() ? FabricLoader.getInstance().getConfigDir().resolve("carpet/scripts/appstore").toAbsolutePath().resolve(path) : source.method_9211().method_27050(class_5218.field_24188).resolve("scripts").toAbsolutePath().resolve(appFileName);
        try {
            Files.createDirectories(scriptLocation.getParent(), new FileAttribute[0]);
            if (Files.exists(scriptLocation, new LinkOption[0])) {
                if (useTrash) {
                    Files.createDirectories(scriptLocation.getParent().resolve("trash"), new FileAttribute[0]);
                    Path trashPath = scriptLocation.getParent().resolve("trash").resolve(path);
                    int i = 0;
                    while (Files.exists(trashPath, new LinkOption[0])) {
                        String[] nameAndExtension = appFileName.split("\\.");
                        String newFileName = String.format(nameAndExtension[0] + "%02d." + nameAndExtension[1], i);
                        trashPath = trashPath.getParent().resolve(newFileName);
                        ++i;
                    }
                    Files.move(scriptLocation, trashPath, new CopyOption[0]);
                }
                Messenger.m(source, String.format("gi Note: replaced existing app '%s'" + (useTrash ? " (old moved to /trash folder)" : ""), appFileName));
            }
            BufferedWriter writer = Files.newBufferedWriter(scriptLocation, new OpenOption[0]);
            writer.write(code);
            writer.close();
        }
        catch (IOException e) {
            Messenger.m(source, "r Error while downloading app: " + e.toString());
            CarpetScriptServer.LOG.warn("Error while downloading app", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromStream(String url) throws IOException {
        InputStream inputStream = new URL(url).openStream();
        if (inputStream == null) {
            throw new IOException("No app to be found on the appstore");
        }
        StringWriter stringWriter = new StringWriter();
        char[] charBuffer = new char[2048];
        try {
            int counter;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            while ((counter = reader.read(charBuffer)) != -1) {
                ((Writer)stringWriter).write(charBuffer, 0, counter);
            }
        }
        finally {
            inputStream.close();
        }
        return ((Object)stringWriter).toString();
    }

    public static void writeUrlToFile(String url, Path destination) throws IOException {
        try (InputStream in = new URL(url).openStream();){
            Files.copy(in, destination, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static String getFullContentUrl(String original, StoreNode storeSource) {
        if (original.matches("^https?://.*$")) {
            return original;
        }
        if (original.charAt(0) == '/') {
            return AppStoreManager.getFileNode(original.substring(1)).url();
        }
        return AppStoreManager.getFileNodeFrom(storeSource, original).url();
    }

    public static void addResource(CarpetScriptHost carpetScriptHost, StoreNode storeSource, Value resource) {
        boolean shared;
        if (!(resource instanceof MapValue)) {
            throw new InternalExpressionException("This is not a valid resource map: " + resource.getString());
        }
        Map<String, Value> resourceMap = ((MapValue)resource).getMap().entrySet().stream().collect(Collectors.toMap(e -> ((Value)e.getKey()).getString(), Map.Entry::getValue));
        if (!resourceMap.containsKey("source")) {
            throw new InternalExpressionException("Missing 'source' field in resource descriptor: " + resource.getString());
        }
        String source = resourceMap.get("source").getString();
        String contentUrl = AppStoreManager.getFullContentUrl(source, storeSource);
        String target = resourceMap.computeIfAbsent("target", k -> new StringValue(contentUrl.substring(contentUrl.lastIndexOf(47) + 1))).getString();
        if (!carpetScriptHost.applyActionForResource(target, shared = resourceMap.getOrDefault("shared", Value.FALSE).getBoolean(), p -> {
            try {
                AppStoreManager.writeUrlToFile(contentUrl, p);
            }
            catch (IOException e) {
                throw new InternalExpressionException("Unable to write resource " + target + ": " + e.toString());
            }
        })) {
            throw new InternalExpressionException("Unable to write resource " + target);
        }
        CarpetScriptServer.LOG.info("Downloaded resource " + target + " from " + contentUrl);
    }

    private static StoreNode getNewStoreNode(StoreNode originalSource, String sourceString, String contentUrl) {
        StoreNode next = originalSource;
        if (sourceString == contentUrl) {
            return null;
        }
        if (sourceString.charAt(0) == '/') {
            next = APP_STORE_ROOT;
            sourceString = sourceString.substring(1);
        }
        String[] dirs = sourceString.split("/");
        try {
            for (int i = 0; i < dirs.length - 1; ++i) {
                next = next.drillDown(dirs[i]);
            }
        }
        catch (IOException e) {
            return null;
        }
        return next;
    }

    public static void addLibrary(CarpetScriptHost carpetScriptHost, StoreNode storeSource, Value library) {
        if (!(library instanceof MapValue)) {
            throw new InternalExpressionException("This is not a valid library map: " + library.getString());
        }
        Map<String, String> libraryMap = ((MapValue)library).getMap().entrySet().stream().collect(Collectors.toMap(e -> ((Value)e.getKey()).getString(), e -> ((Value)e.getValue()).getString()));
        String source = libraryMap.get("source");
        String contentUrl = AppStoreManager.getFullContentUrl(source, storeSource);
        String target = libraryMap.computeIfAbsent("target", k -> contentUrl.substring(contentUrl.lastIndexOf(47) + 1));
        if (!contentUrl.endsWith(".sc") && !contentUrl.endsWith(".scl")) {
            throw new InternalExpressionException("App resource type must download a scarpet app or library.");
        }
        if (target.indexOf(47) != -1) {
            throw new InternalExpressionException("App resource tried to leave script reserved space");
        }
        try {
            AppStoreManager.downloadScript(carpetScriptHost.responsibleSource, target, new AppInfo(target, contentUrl, AppStoreManager.getNewStoreNode(storeSource, source, contentUrl)), true);
        }
        catch (class_2164 e2) {
            throw new InternalExpressionException("Error when installing app dependencies: " + e2.toString());
        }
        CarpetScriptServer.LOG.info("Downloaded app " + target + " from " + contentUrl);
    }

    public static class StoreNode {
        public String name;
        public StoreNode parent;
        public Map<String, StoreNode> children;
        public boolean sealed;
        public String value;
        private CountDownLatch childrenProgress;

        public static StoreNode folder(StoreNode parent, String name) {
            StoreNode node = new StoreNode(parent, name);
            node.children = new HashMap<String, StoreNode>();
            node.value = null;
            node.sealed = false;
            return node;
        }

        public static StoreNode scriptFile(StoreNode parent, String name, String value) {
            StoreNode node = new StoreNode(parent, name);
            node.children = null;
            node.value = value;
            node.sealed = true;
            return node;
        }

        public boolean isLeaf() {
            return this.value != null;
        }

        public String pathElement() {
            return this.name + (this.isLeaf() ? "" : "/");
        }

        public String getPath() {
            return this.createPrePath().toString();
        }

        private StringBuilder createPrePath() {
            return this == APP_STORE_ROOT ? new StringBuilder() : this.parent.createPrePath().append(this.pathElement());
        }

        private StoreNode(StoreNode parent, String name) {
            this.parent = parent;
            this.name = name;
            this.sealed = false;
        }

        public void fillChildren() throws IOException {
            String response;
            if (this.sealed) {
                return;
            }
            if (scarpetRepoLink == null) {
                throw new IOException("Accessing scarpet app repo is disabled");
            }
            try {
                if (this.childrenProgress != null) {
                    this.childrenProgress.await();
                    if (this.sealed) {
                        return;
                    }
                    throw new IOException("Problems fetching suggestions. Check more details in previous exceptions.");
                }
            }
            catch (InterruptedException e) {
                throw new IOException("Suggestion provider thread was interrupted, unexpected!", e);
            }
            this.childrenProgress = new CountDownLatch(1);
            String queryPath = scarpetRepoLink + this.getPath();
            try {
                response = AppStoreManager.getStringFromStream(queryPath);
            }
            catch (IOException e) {
                this.childrenProgress.countDown();
                this.childrenProgress = null;
                throw new IOException("Problems fetching " + queryPath, e);
            }
            JsonArray files = new JsonParser().parse(response).getAsJsonArray();
            for (JsonElement je : files) {
                JsonObject jo = je.getAsJsonObject();
                String name = jo.get("name").getAsString();
                if (jo.get("type").getAsString().equals("dir")) {
                    this.children.put(name, StoreNode.folder(this, name));
                    continue;
                }
                String value = jo.get("download_url").getAsString();
                this.children.put(name, StoreNode.scriptFile(this, name, value));
            }
            this.sealed = true;
            this.childrenProgress.countDown();
        }

        public boolean cannotContinueFor(String pathElement) throws IOException {
            if (this.isLeaf()) {
                return true;
            }
            this.fillChildren();
            return !this.children.containsKey(pathElement);
        }

        public List<String> createPathSuggestions() throws IOException {
            if (this.isLeaf()) {
                if (this.name.endsWith(".sc")) {
                    return Collections.singletonList(this.getPath());
                }
                return Collections.emptyList();
            }
            this.fillChildren();
            String prefix = this.getPath();
            return this.children.values().stream().filter(n -> !n.isLeaf() || n.name.endsWith(".sc")).map(s -> prefix + s.pathElement().replaceAll("/$", "")).collect(Collectors.toList());
        }

        public StoreNode drillDown(String pathElement) throws IOException {
            if (this.isLeaf()) {
                throw new IOException(pathElement + " is not a folder");
            }
            this.fillChildren();
            if (!this.children.containsKey(pathElement)) {
                throw new IOException("Folder " + pathElement + " is not present");
            }
            return this.children.get(pathElement);
        }

        public String getValue(String file) throws IOException {
            StoreNode leaf = this.drillDown(file);
            if (!leaf.isLeaf()) {
                throw new IOException(file + " is not a file");
            }
            return leaf.value;
        }
    }

    private record AppInfo(String name, String url, StoreNode source) {
    }

    public static class ScarpetAppStoreValidator
    extends Validator<String> {
        @Override
        public String validate(class_2168 source, ParsedRule<String> currentRule, String newValue, String string) {
            APP_STORE_ROOT = StoreNode.folder(null, "");
            if (newValue.equalsIgnoreCase("none")) {
                scarpetRepoLink = null;
                return newValue;
            }
            if (newValue.endsWith("/")) {
                newValue = newValue.replaceAll("/$", "");
            }
            scarpetRepoLink = "https://api.github.com/repos/" + newValue + "/";
            return newValue;
        }

        @Override
        public String description() {
            return "Appstore link should point to a valid github repository";
        }
    }
}

