/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.CarpetServer;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public class MobAI {
    private static Map<class_1299<?>, Set<TrackingType>> aiTrackers = new HashMap();

    public static void resetTrackers() {
        aiTrackers.clear();
    }

    public static boolean isTracking(class_1297 e, TrackingType type) {
        if (e.method_5770().method_8608()) {
            return false;
        }
        Set<TrackingType> currentTrackers = aiTrackers.get(e.method_5864());
        if (currentTrackers == null) {
            return false;
        }
        return currentTrackers.contains((Object)type);
    }

    public static void clearTracking(class_1299<? extends class_1297> etype) {
        aiTrackers.remove(etype);
        for (class_3218 world : CarpetServer.minecraft_server.method_3738()) {
            for (class_1297 e : world.method_18198(etype, class_1297::method_16914)) {
                e.method_5880(false);
                e.method_5665(null);
            }
        }
    }

    public static void startTracking(class_1299<?> e, TrackingType type) {
        aiTrackers.putIfAbsent(e, Sets.newHashSet());
        aiTrackers.get(e).add(type);
    }

    public static List<String> availbleTypes() {
        HashSet types = new HashSet();
        for (TrackingType type : TrackingType.values()) {
            types.addAll(type.types);
        }
        return types.stream().map(t -> class_2378.field_11145.method_10221(t).method_12832()).collect(Collectors.toList());
    }

    public static List<String> availableFor(class_1299<?> entityType) {
        HashSet<TrackingType> availableOptions = new HashSet<TrackingType>();
        for (TrackingType type : TrackingType.values()) {
            for (class_1299<?> etype : type.types) {
                if (etype != entityType) continue;
                availableOptions.add(type);
            }
        }
        return availableOptions.stream().map(t -> t.name).collect(Collectors.toList());
    }

    public static void genericJump(class_1297 e) {
        if (!(e.method_24828() || e.method_5816() || e.method_5771())) {
            return;
        }
        float m = e.field_6002.method_8320(e.method_24515()).method_26204().method_23350();
        float g = e.field_6002.method_8320(new class_2338(e.method_23317(), e.method_5829().field_1322 - 0.5000001, e.method_23321())).method_26204().method_23350();
        float jumpVelocityMultiplier = (double)m == 1.0 ? g : m;
        float jumpStrength = 0.42f * jumpVelocityMultiplier;
        class_243 vec3d = e.method_18798();
        e.method_18800(vec3d.field_1352, (double)jumpStrength, vec3d.field_1350);
        if (e.method_5624()) {
            float u = e.method_36454() * ((float)Math.PI / 180);
            e.method_18799(e.method_18798().method_1031((double)(-class_3532.method_15374((float)g) * 0.2f), 0.0, (double)(class_3532.method_15362((float)u) * 0.2f)));
        }
        e.field_6007 = true;
    }

    public static enum TrackingType {
        IRON_GOLEM_SPAWNING("iron_golem_spawning", Sets.newHashSet((Object[])new class_1299[]{class_1299.field_6077})),
        VILLAGER_BREEDING("breeding", Sets.newHashSet((Object[])new class_1299[]{class_1299.field_6077}));

        public final Set<class_1299<?>> types;
        public final String name;

        private TrackingType(String name, Set<class_1299<?>> applicableTypes) {
            this.name = name;
            this.types = applicableTypes;
        }

        public static TrackingType byName(String aspect) {
            for (TrackingType type : TrackingType.values()) {
                if (!type.name.equalsIgnoreCase(aspect)) continue;
                return type;
            }
            return null;
        }
    }
}

