/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.shader_overrides;

import com.mojang.blaze3d.systems.RenderSystem;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.GlMutableBuffer;
import me.jellysquid.mods.sodium.client.gl.shader.uniform.GlUniformBlock;
import me.jellysquid.mods.sodium.client.gl.shader.uniform.GlUniformFloat3v;
import me.jellysquid.mods.sodium.client.gl.shader.uniform.GlUniformMatrix4f;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisShaderFogComponent;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.ShaderBindingContextExt;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.texunits.TextureUnit;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class IrisChunkShaderInterface {
    @Nullable
    private final GlUniformMatrix4f uniformModelViewMatrix;
    @Nullable
    private final GlUniformMatrix4f uniformProjectionMatrix;
    @Nullable
    private final GlUniformFloat3v uniformRegionOffset;
    @Nullable
    private final GlUniformMatrix4f uniformNormalMatrix;
    @Nullable
    private final GlUniformBlock uniformBlockDrawParameters;
    private final BlendModeOverride blendModeOverride;
    private final IrisShaderFogComponent fogShaderComponent;
    private final ProgramUniforms irisProgramUniforms;
    private final ProgramSamplers irisProgramSamplers;
    private final ProgramImages irisProgramImages;

    public IrisChunkShaderInterface(int n, ShaderBindingContextExt shaderBindingContextExt, SodiumTerrainPipeline sodiumTerrainPipeline, boolean bl, BlendModeOverride blendModeOverride) {
        this.uniformModelViewMatrix = shaderBindingContextExt.bindUniformIfPresent("u_ModelViewMatrix", GlUniformMatrix4f::new);
        this.uniformProjectionMatrix = shaderBindingContextExt.bindUniformIfPresent("u_ProjectionMatrix", GlUniformMatrix4f::new);
        this.uniformRegionOffset = shaderBindingContextExt.bindUniformIfPresent("u_RegionOffset", GlUniformFloat3v::new);
        this.uniformNormalMatrix = shaderBindingContextExt.bindUniformIfPresent("u_NormalMatrix", GlUniformMatrix4f::new);
        this.uniformBlockDrawParameters = shaderBindingContextExt.bindUniformBlockIfPresent("ubo_DrawParameters", 0);
        this.blendModeOverride = blendModeOverride;
        this.fogShaderComponent = new IrisShaderFogComponent(shaderBindingContextExt);
        this.irisProgramUniforms = sodiumTerrainPipeline.initUniforms(n);
        this.irisProgramSamplers = bl ? sodiumTerrainPipeline.initShadowSamplers(n) : sodiumTerrainPipeline.initTerrainSamplers(n);
        this.irisProgramImages = bl ? sodiumTerrainPipeline.initShadowImages(n) : sodiumTerrainPipeline.initTerrainImages(n);
    }

    public void setup() {
        RenderSystem.activeTexture((int)TextureUnit.TERRAIN.getUnitId());
        RenderSystem.bindTexture((int)RenderSystem.getShaderTexture((int)0));
        RenderSystem.activeTexture((int)TextureUnit.LIGHTMAP.getUnitId());
        RenderSystem.bindTexture((int)RenderSystem.getShaderTexture((int)2));
        if (this.blendModeOverride != null) {
            this.blendModeOverride.apply();
        }
        this.fogShaderComponent.setup();
        this.irisProgramUniforms.update();
        this.irisProgramSamplers.update();
        this.irisProgramImages.update();
    }

    public void restore() {
        if (this.blendModeOverride != null) {
            BlendModeOverride.restore();
        }
    }

    public void setProjectionMatrix(Matrix4f matrix4f) {
        if (this.uniformProjectionMatrix != null) {
            this.uniformProjectionMatrix.set(matrix4f);
        }
    }

    public void setModelViewMatrix(Matrix4f matrix4f) {
        if (this.uniformModelViewMatrix != null) {
            this.uniformModelViewMatrix.set(matrix4f);
        }
        if (this.uniformNormalMatrix != null) {
            Matrix4f matrix4f2 = new Matrix4f((Matrix4fc)matrix4f);
            matrix4f2.invert();
            matrix4f2.transpose();
            this.uniformNormalMatrix.set(matrix4f2);
        }
    }

    public void setDrawUniforms(GlMutableBuffer glMutableBuffer) {
        if (this.uniformBlockDrawParameters != null) {
            this.uniformBlockDrawParameters.bindBuffer((GlBuffer)glMutableBuffer);
        }
    }

    public void setRegionOffset(float f, float f2, float f3) {
        if (this.uniformRegionOffset != null) {
            this.uniformRegionOffset.set(f, f2, f3);
        }
    }
}

