/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp.writer;

import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.model.vertex.VanillaVertexTypes;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterNio;
import me.jellysquid.mods.sodium.client.model.vertex.formats.quad.QuadVertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.type.BufferVertexType;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp.QuadViewEntity;
import net.coderbot.iris.vertices.IrisVertexFormats;

public class EntityVertexBufferWriterNio
extends VertexBufferWriterNio
implements QuadVertexSink {
    private final QuadViewEntity.QuadViewEntityNio quad = new QuadViewEntity.QuadViewEntityNio();
    private static final int STRIDE = IrisVertexFormats.ENTITY.method_1362();
    private float midU = 0.0f;
    private float midV = 0.0f;
    private int vertexCount;

    public EntityVertexBufferWriterNio(VertexBufferView vertexBufferView) {
        super(vertexBufferView, (BufferVertexType)VanillaVertexTypes.QUADS);
    }

    public void writeQuad(float f, float f2, float f3, int n, float f4, float f5, int n2, int n3, int n4) {
        int n5 = this.writeOffset;
        ByteBuffer byteBuffer = this.byteBuffer;
        ++this.vertexCount;
        this.midU += f4;
        this.midV += f5;
        byteBuffer.putFloat(n5, f);
        byteBuffer.putFloat(n5 + 4, f2);
        byteBuffer.putFloat(n5 + 8, f3);
        byteBuffer.putInt(n5 + 12, n);
        byteBuffer.putFloat(n5 + 16, f4);
        byteBuffer.putFloat(n5 + 20, f5);
        byteBuffer.putInt(n5 + 24, n3);
        byteBuffer.putInt(n5 + 28, n2);
        byteBuffer.putInt(n5 + 32, n4);
        byteBuffer.putShort(n5 + 36, (short)-1);
        byteBuffer.putShort(n5 + 38, (short)-1);
        this.advance();
        if (this.vertexCount == 4) {
            this.endQuad(this.vertexCount, Norm3b.unpackX((int)n4), Norm3b.unpackY((int)n4), Norm3b.unpackZ((int)n4));
        }
    }

    public void endQuad(int n, float f, float f2, float f3) {
        int n2;
        this.vertexCount = 0;
        ByteBuffer byteBuffer = this.byteBuffer;
        int n3 = this.writeOffset;
        this.quad.setup(byteBuffer, n3, STRIDE);
        int n4 = this.quad.computeTangent(f, f2, f3);
        for (n2 = 0; n2 < n; ++n2) {
            byteBuffer.putInt(n3 - 4 - STRIDE * n2, n4);
        }
        this.midU = (float)((double)this.midU * 0.25);
        this.midV = (float)((double)this.midV * 0.25);
        for (n2 = 0; n2 < n; ++n2) {
            byteBuffer.putFloat(n3 - 12 - STRIDE * n2, this.midU);
            byteBuffer.putFloat(n3 - 8 - STRIDE * n2, this.midV);
        }
        this.midU = 0.0f;
        this.midV = 0.0f;
        this.vertexCount = 0;
    }
}

