/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp;

import java.nio.ByteBuffer;
import net.coderbot.iris.compat.sodium.impl.vertex_format.QuadView;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.XHFPModelVertexType;
import org.lwjgl.system.MemoryUtil;

public abstract class QuadViewTerrain
extends QuadView {
    public long writePointer;
    int stride;

    @Override
    public float x(int n) {
        return XHFPModelVertexType.decodePosition(this.getShort(this.writePointer - (long)(this.stride * (3 - n))));
    }

    @Override
    public float y(int n) {
        return XHFPModelVertexType.decodePosition(this.getShort(this.writePointer + 2L - (long)(this.stride * (3 - n))));
    }

    @Override
    public float z(int n) {
        return XHFPModelVertexType.decodePosition(this.getShort(this.writePointer + 4L - (long)(this.stride * (3 - n))));
    }

    @Override
    public float u(int n) {
        return XHFPModelVertexType.decodeBlockTexture(this.getShort(this.writePointer + 12L - (long)(this.stride * (3 - n))));
    }

    @Override
    public float v(int n) {
        return XHFPModelVertexType.decodeBlockTexture(this.getShort(this.writePointer + 14L - (long)(this.stride * (3 - n))));
    }

    abstract short getShort(long var1);

    public static class QuadViewTerrainNio
    extends QuadViewTerrain {
        ByteBuffer buffer;

        public void setup(ByteBuffer byteBuffer, int n, int n2) {
            this.buffer = byteBuffer;
            this.writePointer = n;
            this.stride = n2;
        }

        @Override
        short getShort(long l) {
            return this.buffer.getShort((int)l);
        }
    }

    public static class QuadViewTerrainUnsafe
    extends QuadViewTerrain {
        public void setup(long l, int n) {
            this.writePointer = l;
            this.stride = n;
        }

        @Override
        short getShort(long l) {
            return MemoryUtil.memGetShort((long)l);
        }
    }
}

