/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp;

import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterNio;
import me.jellysquid.mods.sodium.client.model.vertex.type.BufferVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import net.coderbot.iris.block_rendering.MaterialIdHolder;
import net.coderbot.iris.compat.sodium.impl.block_id.MaterialIdAwareVertexWriter;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisModelVertexFormats;
import net.coderbot.iris.compat.sodium.impl.vertex_format.NormalHelper;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.QuadViewTerrain;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.XHFPModelVertexType;
import net.coderbot.iris.vendored.joml.Vector3f;

public class XHFPModelVertexBufferWriterNio
extends VertexBufferWriterNio
implements ModelVertexSink,
MaterialIdAwareVertexWriter {
    private MaterialIdHolder idHolder;
    private static final int STRIDE = 36;
    int vertexCount = 0;
    float uSum;
    float vSum;
    private final QuadViewTerrain.QuadViewTerrainNio currentQuad = new QuadViewTerrain.QuadViewTerrainNio();
    private final Vector3f normal = new Vector3f();

    public XHFPModelVertexBufferWriterNio(VertexBufferView vertexBufferView) {
        super(vertexBufferView, (BufferVertexType)IrisModelVertexFormats.MODEL_VERTEX_XHFP);
    }

    @Override
    public void copyQuadAndFlipNormal() {
        this.ensureCapacity(4);
        ByteBuffer byteBuffer = this.byteBuffer.duplicate();
        ByteBuffer byteBuffer2 = this.byteBuffer.duplicate();
        byteBuffer.position(this.byteBuffer.position() + this.writeOffset - 144);
        byteBuffer.limit(byteBuffer.position() + 144);
        byteBuffer2.position(this.byteBuffer.position() + this.writeOffset);
        byteBuffer2.limit(byteBuffer2.position() + 144);
        byteBuffer2.put(byteBuffer);
        int n = this.byteBuffer.getInt(this.writeOffset + 28);
        int n2 = NormalHelper.invertPackedNormal(n);
        this.byteBuffer.putInt(this.writeOffset + 28, n2);
        this.byteBuffer.putInt(this.writeOffset + 28 + 36, n2);
        this.byteBuffer.putInt(this.writeOffset + 28 + 72, n2);
        this.byteBuffer.putInt(this.writeOffset + 28 + 108, n2);
        for (int i = 0; i < 4; ++i) {
            this.advance();
        }
        this.flush();
    }

    public void writeVertex(float f, float f2, float f3, int n, float f4, float f5, int n2, int n3) {
        this.uSum += f4;
        this.vSum += f5;
        short s = this.idHolder.id;
        short s2 = this.idHolder.renderType;
        this.writeQuadInternal(f, f2, f3, n, f4, f5, n2, s, s2, n3);
    }

    private void writeQuadInternal(float f, float f2, float f3, int n, float f4, float f5, int n2, short s, short s2, int n3) {
        int n4 = this.writeOffset;
        ++this.vertexCount;
        ByteBuffer byteBuffer = this.byteBuffer;
        byteBuffer.putShort(n4 + 0, XHFPModelVertexType.encodePosition(f));
        byteBuffer.putShort(n4 + 2, XHFPModelVertexType.encodePosition(f2));
        byteBuffer.putShort(n4 + 4, XHFPModelVertexType.encodePosition(f3));
        byteBuffer.putShort(n4 + 6, (short)n3);
        byteBuffer.putInt(n4 + 8, n);
        byteBuffer.putShort(n4 + 12, XHFPModelVertexType.encodeBlockTexture(f4));
        byteBuffer.putShort(n4 + 14, XHFPModelVertexType.encodeBlockTexture(f5));
        byteBuffer.putInt(n4 + 16, XHFPModelVertexType.encodeLightMapTexCoord(n2));
        byteBuffer.putShort(n4 + 32, s);
        byteBuffer.putShort(n4 + 34, s2);
        if (this.vertexCount == 4) {
            int n5 = (int)(65535.0f * Math.min(this.uSum * 0.25f, 1.0f)) & 0xFFFF;
            int n6 = (int)(65535.0f * Math.min(this.vSum * 0.25f, 1.0f)) & 0xFFFF;
            int n7 = n6 << 16 | n5;
            byteBuffer.putInt(n4 + 20, n7);
            byteBuffer.putInt(n4 + 20 - 36, n7);
            byteBuffer.putInt(n4 + 20 - 72, n7);
            byteBuffer.putInt(n4 + 20 - 108, n7);
            this.vertexCount = 0;
            this.uSum = 0.0f;
            this.vSum = 0.0f;
            this.currentQuad.setup(byteBuffer, this.writeOffset, 36);
            NormalHelper.computeFaceNormal(this.normal, this.currentQuad);
            int n8 = NormalHelper.packNormal(this.normal, 0.0f);
            byteBuffer.putInt(n4 + 28, n8);
            byteBuffer.putInt(n4 + 28 - 36, n8);
            byteBuffer.putInt(n4 + 28 - 72, n8);
            byteBuffer.putInt(n4 + 28 - 108, n8);
            int n9 = this.currentQuad.computeTangent(this.normal.x(), this.normal.y(), this.normal.z());
            byteBuffer.putInt(n4 + 24, n9);
            byteBuffer.putInt(n4 + 24 - 36, n9);
            byteBuffer.putInt(n4 + 24 - 72, n9);
            byteBuffer.putInt(n4 + 24 - 108, n9);
        }
        this.advance();
    }

    @Override
    public void iris$setIdHolder(MaterialIdHolder materialIdHolder) {
        this.idHolder = materialIdHolder;
    }
}

