/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import java.util.function.Supplier;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.uniform.Uniform;
import net.coderbot.iris.gl.uniform.ValueUpdateNotifier;
import net.coderbot.iris.vendored.joml.Vector4f;

public class Vector4Uniform
extends Uniform {
    private final Vector4f cachedValue = new Vector4f();
    private final Supplier<Vector4f> value;

    Vector4Uniform(int n, Supplier<Vector4f> supplier) {
        this(n, supplier, null);
    }

    Vector4Uniform(int n, Supplier<Vector4f> supplier, ValueUpdateNotifier valueUpdateNotifier) {
        super(n, valueUpdateNotifier);
        this.value = supplier;
    }

    @Override
    public void update() {
        this.updateValue();
        if (this.notifier != null) {
            this.notifier.setListener(this::updateValue);
        }
    }

    private void updateValue() {
        Vector4f vector4f = this.value.get();
        if (!vector4f.equals(this.cachedValue)) {
            this.cachedValue.set(vector4f.x(), vector4f.y(), vector4f.z(), vector4f.w());
            IrisRenderSystem.uniform4f(this.location, this.cachedValue.x(), this.cachedValue.y(), this.cachedValue.z(), this.cachedValue.w());
        }
    }
}

