/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.layer;

import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.state.StateUpdateNotifiers;
import net.coderbot.iris.layer.GbufferProgram;
import net.coderbot.iris.pipeline.HandRenderer;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.minecraft.class_1921;

public class GbufferPrograms {
    private static boolean entities;
    private static boolean blockEntities;
    private static Runnable phaseChangeListener;

    private static GbufferProgram refine(GbufferProgram gbufferProgram, boolean bl) {
        if (gbufferProgram == GbufferProgram.ENTITIES || gbufferProgram == GbufferProgram.TERRAIN || gbufferProgram == GbufferProgram.TRANSLUCENT_TERRAIN) {
            if (HandRenderer.INSTANCE.isActive()) {
                return HandRenderer.INSTANCE.isRenderingSolid() ? GbufferProgram.HAND : GbufferProgram.HAND_TRANSLUCENT;
            }
            if (entities) {
                return GbufferProgram.ENTITIES;
            }
            if (blockEntities) {
                return GbufferProgram.BLOCK_ENTITIES;
            }
        }
        if (gbufferProgram == GbufferProgram.DAMAGED_BLOCKS) {
            GbufferPrograms.setPhase(bl ? WorldRenderingPhase.DESTROY : WorldRenderingPhase.NONE);
        } else if (gbufferProgram == GbufferProgram.LINES) {
            GbufferPrograms.setPhase(bl ? WorldRenderingPhase.OUTLINE : WorldRenderingPhase.NONE);
        }
        return gbufferProgram;
    }

    public static WorldRenderingPhase refineTerrainPhase(class_1921 class_19212) {
        if (class_19212 == class_1921.method_23577()) {
            return WorldRenderingPhase.TERRAIN_SOLID;
        }
        if (class_19212 == class_1921.method_23581()) {
            return WorldRenderingPhase.TERRAIN_CUTOUT;
        }
        if (class_19212 == class_1921.method_23579()) {
            return WorldRenderingPhase.TERRAIN_CUTOUT_MIPPED;
        }
        if (class_19212 == class_1921.method_23583()) {
            return WorldRenderingPhase.TERRAIN_TRANSLUCENT;
        }
        if (class_19212 == class_1921.method_29997()) {
            return WorldRenderingPhase.TRIPWIRE;
        }
        throw new IllegalStateException("Illegal render type!");
    }

    public static void beginEntities() {
        if (entities || blockEntities) {
            throw new IllegalStateException("GbufferPrograms in weird state, tried to call beginEntities when entities = " + entities + ", blockEntities = " + blockEntities);
        }
        GbufferPrograms.setPhase(WorldRenderingPhase.ENTITIES);
        entities = true;
    }

    public static boolean isRenderingEntities() {
        return entities;
    }

    public static void endEntities() {
        if (!entities) {
            throw new IllegalStateException("GbufferPrograms in weird state, tried to call endEntities when entities = false");
        }
        GbufferPrograms.setPhase(WorldRenderingPhase.NONE);
        entities = false;
    }

    public static void beginBlockEntities() {
        if (entities || blockEntities) {
            throw new IllegalStateException("GbufferPrograms in weird state, tried to call beginBlockEntities when entities = " + entities + ", blockEntities = " + blockEntities);
        }
        GbufferPrograms.setPhase(WorldRenderingPhase.BLOCK_ENTITIES);
        blockEntities = true;
    }

    public static boolean isRenderingBlockEntities() {
        return blockEntities;
    }

    public static void endBlockEntities() {
        if (!blockEntities) {
            throw new IllegalStateException("GbufferPrograms in weird state, tried to call endBlockEntities when blockEntities = false");
        }
        GbufferPrograms.setPhase(WorldRenderingPhase.NONE);
        blockEntities = false;
    }

    public static void push(GbufferProgram gbufferProgram) {
        gbufferProgram = GbufferPrograms.refine(gbufferProgram, true);
        WorldRenderingPipeline worldRenderingPipeline = Iris.getPipelineManager().getPipelineNullable();
        if (worldRenderingPipeline != null) {
            worldRenderingPipeline.pushProgram(gbufferProgram);
        }
    }

    public static void pop(GbufferProgram gbufferProgram) {
        gbufferProgram = GbufferPrograms.refine(gbufferProgram, false);
        WorldRenderingPipeline worldRenderingPipeline = Iris.getPipelineManager().getPipelineNullable();
        if (worldRenderingPipeline != null) {
            worldRenderingPipeline.popProgram(gbufferProgram);
        }
    }

    public static WorldRenderingPhase getCurrentPhase() {
        WorldRenderingPipeline worldRenderingPipeline = Iris.getPipelineManager().getPipelineNullable();
        if (worldRenderingPipeline != null) {
            return worldRenderingPipeline.getPhase();
        }
        return WorldRenderingPhase.NONE;
    }

    public static void setPhase(WorldRenderingPhase worldRenderingPhase) {
        WorldRenderingPipeline worldRenderingPipeline = Iris.getPipelineManager().getPipelineNullable();
        if (worldRenderingPipeline != null) {
            worldRenderingPipeline.setPhase(worldRenderingPhase);
        }
    }

    public static void runPhaseChangeNotifier() {
        if (phaseChangeListener != null) {
            phaseChangeListener.run();
        }
    }

    public static void init() {
    }

    static {
        StateUpdateNotifiers.phaseChangeNotifier = runnable -> {
            phaseChangeListener = runnable;
        };
    }
}

