/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin.vertices;

import java.nio.ByteBuffer;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vertices.BlockSensitiveBufferBuilder;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.coderbot.iris.vertices.NormalHelper;
import net.coderbot.iris.vertices.QuadView;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_4584;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_287.class})
public abstract class MixinBufferBuilder
implements class_4584,
BlockSensitiveBufferBuilder {
    @Unique
    boolean extending;
    @Unique
    private int vertexCount;
    @Unique
    private final QuadView quad = new QuadView();
    @Unique
    private final Vector3f normal = new Vector3f();
    @Unique
    private int normalOffset;
    @Unique
    private short currentBlock;
    @Unique
    private short currentRenderType;
    @Shadow
    private boolean field_21594;
    @Shadow
    private boolean field_21595;
    @Shadow
    private ByteBuffer field_1555;
    @Shadow
    private class_293 field_1565;
    @Shadow
    private int field_20884;
    @Shadow
    @Nullable
    private class_296 field_1558;

    @Shadow
    public abstract void method_22898(int var1, short var2);

    @Inject(method={"begin"}, at={@At(value="HEAD")})
    private void iris$onBegin(class_293.class_5596 class_55962, class_293 class_2932, CallbackInfo callbackInfo) {
        this.extending = IrisApi.getInstance().isShaderPackInUse() && (class_2932 == class_290.field_1590 || class_2932 == IrisVertexFormats.TERRAIN || class_2932 == class_290.field_1580 || class_2932 == IrisVertexFormats.ENTITY);
        this.vertexCount = 0;
        if (this.extending) {
            this.normalOffset = class_2932.method_1357().indexOf((Object)class_290.field_1579);
        }
    }

    @Inject(method={"begin"}, at={@At(value="RETURN")})
    private void iris$afterBegin(class_293.class_5596 class_55962, class_293 class_2932, CallbackInfo callbackInfo) {
        if (this.extending) {
            this.field_1565 = class_2932 == class_290.field_1580 || class_2932 == IrisVertexFormats.ENTITY ? IrisVertexFormats.ENTITY : IrisVertexFormats.TERRAIN;
            this.field_1558 = (class_296)this.field_1565.method_1357().get(0);
        }
    }

    @Inject(method={"discard()V"}, at={@At(value="HEAD")})
    private void iris$onDiscard(CallbackInfo callbackInfo) {
        this.extending = false;
        this.vertexCount = 0;
    }

    @Inject(method={"switchFormat"}, at={@At(value="RETURN")})
    private void iris$preventHardcodedVertexWriting(class_293 class_2932, CallbackInfo callbackInfo) {
        if (!this.extending) {
            return;
        }
        this.field_21594 = false;
        this.field_21595 = false;
    }

    @Inject(method={"endVertex"}, at={@At(value="HEAD")})
    private void iris$beforeNext(CallbackInfo callbackInfo) {
        int n;
        if (!this.extending) {
            return;
        }
        this.method_22898(0, this.currentBlock);
        this.method_22898(2, this.currentRenderType);
        this.method_1325();
        this.method_22897(0, 0.0f);
        this.method_22897(4, 0.0f);
        this.method_1325();
        this.putInt(0, 0);
        this.method_1325();
        ++this.vertexCount;
        if (this.vertexCount < 4) {
            return;
        }
        this.vertexCount = 0;
        int n2 = 16;
        int n3 = this.field_1565.method_1362();
        this.quad.setup(this.field_1555, this.field_20884, n3);
        NormalHelper.computeFaceNormal(this.normal, this.quad);
        int n4 = NormalHelper.packNormal(this.normal, 0.0f);
        this.field_1555.putInt(this.field_20884 - 4 - n2, n4);
        this.field_1555.putInt(this.field_20884 - 4 - n2 - n3, n4);
        this.field_1555.putInt(this.field_20884 - 4 - n2 - n3 * 2, n4);
        this.field_1555.putInt(this.field_20884 - 4 - n2 - n3 * 3, n4);
        this.computeTangents();
        float f = 0.0f;
        float f2 = 0.0f;
        for (n = 0; n < 4; ++n) {
            f += this.quad.u(n);
            f2 += this.quad.v(n);
        }
        f = (float)((double)f * 0.25);
        f2 = (float)((double)f2 * 0.25);
        for (n = 0; n < 4; ++n) {
            this.field_1555.putFloat(this.field_20884 - 12 - n3 * n, f);
            this.field_1555.putFloat(this.field_20884 - 8 - n3 * n, f2);
        }
    }

    @Override
    public void beginBlock(short s, short s2) {
        this.currentBlock = s;
        this.currentRenderType = s2;
    }

    @Override
    public void endBlock() {
        this.currentBlock = (short)-1;
        this.currentRenderType = (short)-1;
    }

    private void computeTangents() {
        float f;
        float f2;
        float f3 = this.quad.x(0);
        float f4 = this.quad.y(0);
        float f5 = this.quad.z(0);
        float f6 = this.quad.x(1);
        float f7 = this.quad.y(1);
        float f8 = this.quad.z(1);
        float f9 = this.quad.x(2);
        float f10 = this.quad.y(2);
        float f11 = this.quad.z(2);
        float f12 = f6 - f3;
        float f13 = f7 - f4;
        float f14 = f8 - f5;
        float f15 = f9 - f3;
        float f16 = f10 - f4;
        float f17 = f11 - f5;
        float f18 = this.quad.u(0);
        float f19 = this.quad.v(0);
        float f20 = this.quad.u(1);
        float f21 = this.quad.v(1);
        float f22 = this.quad.u(2);
        float f23 = f20 - f18;
        float f24 = this.quad.v(2);
        float f25 = f24 - f19;
        float f26 = f23 * f25 - (f2 = f22 - f18) * (f = f21 - f19);
        float f27 = (double)f26 == 0.0 ? 1.0f : 1.0f / f26;
        float f28 = f27 * (f25 * f12 - f * f15);
        float f29 = f27 * (f25 * f13 - f * f16);
        float f30 = f27 * (f25 * f14 - f * f17);
        float f31 = MixinBufferBuilder.rsqrt(f28 * f28 + f29 * f29 + f30 * f30);
        f28 *= f31;
        f29 *= f31;
        float f32 = f27 * (-f2 * f12 + f23 * f15);
        float f33 = f27 * (-f2 * f13 + f23 * f16);
        float f34 = f27 * (-f2 * f14 + f23 * f17);
        float f35 = MixinBufferBuilder.rsqrt(f32 * f32 + f33 * f33 + f34 * f34);
        float f36 = f29 * this.normal.z - (f30 *= f31) * this.normal.y;
        float f37 = -(f28 * this.normal.z - f30 * this.normal.x);
        float f38 = f28 * this.normal.x - f29 * this.normal.y;
        float f39 = (f32 *= f35) * f36 + (f33 *= f35) * f37 + (f34 *= f35) * f38;
        float f40 = f39 < 0.0f ? -1.0f : 1.0f;
        int n = NormalHelper.packNormal(f28, f29, f30, f40);
        int n2 = this.field_1565.method_1362();
        this.field_1555.putInt(this.field_20884 - 4, n);
        this.field_1555.putInt(this.field_20884 - 4 - n2, n);
        this.field_1555.putInt(this.field_20884 - 4 - n2 * 2, n);
        this.field_1555.putInt(this.field_20884 - 4 - n2 * 3, n);
    }

    @Unique
    private static float rsqrt(float f) {
        if (f == 0.0f) {
            return 1.0f;
        }
        return (float)(1.0 / Math.sqrt(f));
    }

    @Unique
    public void putInt(int n, int n2) {
        this.field_1555.putInt(this.field_20884 + n, n2);
    }
}

