/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.Iris;
import net.coderbot.iris.block_rendering.BlockMaterialMapping;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.AlphaTestStorage;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.image.ImageHolder;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.layer.GbufferProgram;
import net.coderbot.iris.layer.GbufferPrograms;
import net.coderbot.iris.mixin.LevelRendererAccessor;
import net.coderbot.iris.pipeline.AttributeShaderTransformer;
import net.coderbot.iris.pipeline.ClearPass;
import net.coderbot.iris.pipeline.ClearPassCreator;
import net.coderbot.iris.pipeline.CustomTextureManager;
import net.coderbot.iris.pipeline.HandRenderer;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.CoreWorldRenderingPipeline;
import net.coderbot.iris.postprocess.BufferFlipper;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.CompositeRenderer;
import net.coderbot.iris.postprocess.FinalPassRenderer;
import net.coderbot.iris.rendertarget.Blaze3dRenderTargetExt;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shaderpack.transform.StringTransformations;
import net.coderbot.iris.shadows.EmptyShadowMapRenderer;
import net.coderbot.iris.shadows.ShadowMapRenderer;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.minecraft.class_1044;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import org.jetbrains.annotations.Nullable;

public class DeferredWorldRenderingPipeline
implements WorldRenderingPipeline {
    private final RenderTargets renderTargets;
    private final List<Pass> allPasses;
    @Nullable
    private final Pass basic;
    @Nullable
    private final Pass textured;
    @Nullable
    private final Pass texturedLit;
    @Nullable
    private final Pass basicOverlay;
    @Nullable
    private final Pass texturedOverlay;
    @Nullable
    private final Pass texturedLitOverlay;
    @Nullable
    private final Pass skyBasic;
    @Nullable
    private final Pass skyTextured;
    @Nullable
    private final Pass clouds;
    @Nullable
    private final Pass terrain;
    @Nullable
    private final Pass translucent;
    @Nullable
    private final Pass damagedBlock;
    @Nullable
    private final Pass weather;
    @Nullable
    private final Pass beaconBeam;
    @Nullable
    private final Pass entities;
    @Nullable
    private final Pass entityNoOverlay;
    @Nullable
    private final Pass blockEntities;
    @Nullable
    private final Pass hand;
    @Nullable
    private final Pass handNoOverlay;
    @Nullable
    private final Pass handTranslucent;
    @Nullable
    private final Pass glowingEntities;
    @Nullable
    private final Pass glint;
    @Nullable
    private final Pass eyes;
    @Nullable
    private final Pass eyesNoOverlay;
    private final ImmutableList<ClearPass> clearPassesFull;
    private final ImmutableList<ClearPass> clearPasses;
    private final GlFramebuffer baseline;
    private Runnable createShadowMapRenderer;
    private final CompositeRenderer prepareRenderer;
    private ShadowMapRenderer shadowMapRenderer;
    private final CompositeRenderer deferredRenderer;
    private final CompositeRenderer compositeRenderer;
    private final FinalPassRenderer finalPassRenderer;
    private final CustomTextureManager customTextureManager;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final ImmutableSet<Integer> flippedAfterPrepare;
    private final ImmutableSet<Integer> flippedAfterTranslucent;
    private final SodiumTerrainPipeline sodiumTerrainPipeline;
    private boolean isBeforeTranslucent;
    private final float sunPathRotation;
    private final boolean shouldRenderClouds;
    private final boolean shouldRenderUnderwaterOverlay;
    private final boolean shouldRenderVignette;
    private final boolean shouldWriteRainAndSnowToDepthBuffer;
    private final boolean shouldRenderParticlesBeforeDeferred;
    private final boolean oldLighting;
    private final OptionalInt forcedShadowRenderDistanceChunks;
    private final List<GbufferProgram> programStack = new ArrayList<GbufferProgram>();
    private final List<String> programStackLog = new ArrayList<String>();
    private WorldRenderingPhase phase;
    private boolean isRenderingWorld = false;
    private boolean isRenderingShadow = false;

    public DeferredWorldRenderingPipeline(ProgramSet programSet) {
        Objects.requireNonNull(programSet);
        this.shouldRenderClouds = programSet.getPackDirectives().areCloudsEnabled();
        this.shouldRenderUnderwaterOverlay = programSet.getPackDirectives().underwaterOverlay();
        this.shouldRenderVignette = programSet.getPackDirectives().vignette();
        this.shouldWriteRainAndSnowToDepthBuffer = programSet.getPackDirectives().rainDepth();
        this.shouldRenderParticlesBeforeDeferred = programSet.getPackDirectives().areParticlesBeforeDeferred();
        this.oldLighting = programSet.getPackDirectives().isOldLighting();
        this.updateNotifier = new FrameUpdateNotifier();
        this.allPasses = new ArrayList<Pass>();
        this.renderTargets = new RenderTargets(class_310.method_1551().method_1522(), programSet.getPackDirectives().getRenderTargetDirectives());
        this.sunPathRotation = programSet.getPackDirectives().getSunPathRotation();
        PackShadowDirectives packShadowDirectives = programSet.getPackDirectives().getShadowDirectives();
        this.forcedShadowRenderDistanceChunks = packShadowDirectives.isDistanceRenderMulExplicit() ? ((double)packShadowDirectives.getDistanceRenderMul() >= 0.0 ? OptionalInt.of(((int)(packShadowDirectives.getDistance() * packShadowDirectives.getDistanceRenderMul()) + 15) / 16) : OptionalInt.of(-1)) : OptionalInt.empty();
        BlockRenderingSettings.INSTANCE.setBlockStateIds(BlockMaterialMapping.createBlockStateIdMap(programSet.getPack().getIdMap().getBlockProperties()));
        BlockRenderingSettings.INSTANCE.setEntityIds(programSet.getPack().getIdMap().getEntityIdMap());
        BlockRenderingSettings.INSTANCE.setAmbientOcclusionLevel(programSet.getPackDirectives().getAmbientOcclusionLevel());
        BlockRenderingSettings.INSTANCE.setDisableDirectionalShading(this.shouldDisableDirectionalShading());
        BlockRenderingSettings.INSTANCE.setUseSeparateAo(programSet.getPackDirectives().shouldUseSeparateAo());
        GlStateManager.glActiveTexture((int)33986);
        this.customTextureManager = new CustomTextureManager(programSet.getPackDirectives(), programSet.getPack().getCustomTextureDataMap(), programSet.getPack().getCustomNoiseTexture());
        GlStateManager.glActiveTexture((int)33984);
        ImmutableSet immutableSet = ImmutableSet.of();
        this.createShadowMapRenderer = () -> {
            this.shadowMapRenderer = new ShadowRenderer((CoreWorldRenderingPipeline)((Object)this), programSet, programSet.getPackDirectives(), this.renderTargets);
            this.createShadowMapRenderer = () -> {};
        };
        BufferFlipper bufferFlipper = new BufferFlipper();
        this.centerDepthSampler = new CenterDepthSampler(this.renderTargets);
        Supplier<ShadowMapRenderer> supplier = () -> {
            this.createShadowMapRenderer.run();
            return this.shadowMapRenderer;
        };
        this.prepareRenderer = new CompositeRenderer(programSet.getPackDirectives(), programSet.getPrepare(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, bufferFlipper, supplier, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.PREPARE, (Object)Object2ObjectMaps.emptyMap())), programSet.getPackDirectives().getExplicitFlips("prepare_pre"));
        this.flippedAfterPrepare = bufferFlipper.snapshot();
        this.deferredRenderer = new CompositeRenderer(programSet.getPackDirectives(), programSet.getDeferred(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, bufferFlipper, supplier, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.DEFERRED, (Object)Object2ObjectMaps.emptyMap())), programSet.getPackDirectives().getExplicitFlips("deferred_pre"));
        this.flippedAfterTranslucent = bufferFlipper.snapshot();
        this.compositeRenderer = new CompositeRenderer(programSet.getPackDirectives(), programSet.getComposite(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, bufferFlipper, supplier, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.COMPOSITE_AND_FINAL, (Object)Object2ObjectMaps.emptyMap())), programSet.getPackDirectives().getExplicitFlips("composite_pre"));
        this.finalPassRenderer = new FinalPassRenderer(programSet, this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, bufferFlipper.snapshot(), this.centerDepthSampler, supplier, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.COMPOSITE_AND_FINAL, (Object)Object2ObjectMaps.emptyMap())), this.compositeRenderer.getFlippedAtLeastOnceFinal());
        Supplier<ImmutableSet> supplier2 = () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        IntFunction<ProgramSamplers> intFunction = n -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(n, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.GBUFFERS_AND_SHADOW, (Object)Object2ObjectMaps.emptyMap())));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, supplier2, this.renderTargets, false);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (class_1044)this.customTextureManager.getNormals(), (class_1044)this.customTextureManager.getSpecular());
            IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                this.createShadowMapRenderer.run();
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowMapRenderer);
            }
            return builder.build();
        };
        IntFunction<ProgramImages> intFunction2 = n -> {
            ProgramImages.Builder builder = ProgramImages.builder(n);
            IrisImages.addRenderTargetImages(builder, supplier2, this.renderTargets);
            if (IrisImages.hasShadowImages(builder)) {
                this.createShadowMapRenderer.run();
                IrisImages.addShadowColorImages((ImageHolder)builder, this.shadowMapRenderer);
            }
            return builder.build();
        };
        IntFunction<ProgramSamplers> intFunction3 = n -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(n, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.GBUFFERS_AND_SHADOW, (Object)Object2ObjectMaps.emptyMap())));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> this.flippedAfterPrepare, this.renderTargets, false);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (class_1044)this.customTextureManager.getNormals(), (class_1044)this.customTextureManager.getSpecular());
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor) && this.shadowMapRenderer != null) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowMapRenderer);
            }
            return builder.build();
        };
        IntFunction<ProgramImages> intFunction4 = n -> {
            ProgramImages.Builder builder = ProgramImages.builder(n);
            IrisImages.addRenderTargetImages(builder, () -> this.flippedAfterPrepare, this.renderTargets);
            if (IrisImages.hasShadowImages(builder) && this.shadowMapRenderer != null) {
                IrisImages.addShadowColorImages((ImageHolder)builder, this.shadowMapRenderer);
            }
            return builder.build();
        };
        this.basic = programSet.getGbuffersBasic().map(this::createPass).orElse(null);
        this.textured = programSet.getGbuffersTextured().map(this::createPass).orElse(this.basic);
        this.texturedLit = programSet.getGbuffersTexturedLit().map(this::createPass).orElse(this.textured);
        this.basicOverlay = programSet.getGbuffersBasic().map(this::createEntityPass).orElse(null);
        this.texturedOverlay = programSet.getGbuffersTextured().map(this::createEntityPass).orElse(this.basicOverlay);
        this.texturedLitOverlay = programSet.getGbuffersTexturedLit().map(this::createEntityPass).orElse(this.texturedOverlay);
        this.skyBasic = programSet.getGbuffersSkyBasic().map(this::createPass).orElse(this.basic);
        this.skyTextured = programSet.getGbuffersSkyTextured().map(this::createPass).orElse(this.textured);
        this.clouds = programSet.getGbuffersClouds().map(this::createPass).orElse(this.textured);
        this.terrain = programSet.getGbuffersTerrain().map(this::createPass).orElse(this.texturedLit);
        this.translucent = programSet.getGbuffersWater().map(this::createPass).orElse(this.terrain);
        this.damagedBlock = programSet.getGbuffersDamagedBlock().map(this::createPass).orElse(this.terrain);
        this.weather = programSet.getGbuffersWeather().map(this::createPass).orElse(this.texturedLit);
        this.beaconBeam = programSet.getGbuffersBeaconBeam().map(this::createPass).orElse(this.textured);
        this.entities = programSet.getGbuffersEntities().map(this::createEntityPass).orElse(this.texturedLitOverlay);
        this.entityNoOverlay = programSet.getGbuffersEntities().map(this::createPass).orElse(this.texturedLit);
        this.blockEntities = programSet.getGbuffersBlock().map(this::createPass).orElse(this.terrain);
        this.hand = programSet.getGbuffersHand().map(this::createEntityPass).orElse(this.texturedLitOverlay);
        this.handNoOverlay = programSet.getGbuffersHand().map(this::createPass).orElse(this.texturedLit);
        this.handTranslucent = programSet.getGbuffersHandWater().map(this::createEntityPass).orElse(this.hand);
        this.glowingEntities = programSet.getGbuffersEntitiesGlowing().map(this::createEntityPass).orElse(this.entities);
        this.glint = programSet.getGbuffersGlint().map(this::createPass).orElse(this.textured);
        this.eyes = programSet.getGbuffersEntityEyes().map(this::createEntityPass).orElse(this.texturedOverlay);
        this.eyesNoOverlay = programSet.getGbuffersEntityEyes().map(this::createPass).orElse(this.textured);
        this.clearPassesFull = ClearPassCreator.createClearPasses(this.renderTargets, true, programSet.getPackDirectives().getRenderTargetDirectives());
        this.clearPasses = ClearPassCreator.createClearPasses(this.renderTargets, false, programSet.getPackDirectives().getRenderTargetDirectives());
        this.baseline = this.renderTargets.createFramebufferWritingToMain(new int[]{0});
        if (this.shadowMapRenderer == null) {
            this.shadowMapRenderer = new EmptyShadowMapRenderer(programSet.getPackDirectives().getShadowDirectives().getResolution());
        }
        this.phase = WorldRenderingPhase.NONE;
        this.sodiumTerrainPipeline = new SodiumTerrainPipeline(this, programSet, intFunction, this.shadowMapRenderer instanceof EmptyShadowMapRenderer || this.shadowMapRenderer == null ? null : intFunction3, intFunction2, intFunction4, this.renderTargets, this.flippedAfterPrepare, this.flippedAfterTranslucent, this.shadowMapRenderer instanceof ShadowRenderer ? ((ShadowRenderer)this.shadowMapRenderer).getFramebuffer() : null);
    }

    private void checkWorld() {
        if (class_310.method_1551().field_1687 == null) {
            this.isRenderingWorld = false;
            this.programStackLog.clear();
            this.programStack.clear();
        }
    }

    @Override
    public void pushProgram(GbufferProgram gbufferProgram) {
        this.checkWorld();
        if (!this.isRenderingWorld || this.isRenderingShadow) {
            return;
        }
        this.programStack.add(gbufferProgram);
        this.useProgram(gbufferProgram);
        this.programStackLog.add("push:" + gbufferProgram);
    }

    @Override
    public void popProgram(GbufferProgram gbufferProgram) {
        Object object;
        this.checkWorld();
        if (!this.isRenderingWorld || this.isRenderingShadow) {
            return;
        }
        if (this.programStack.isEmpty()) {
            Iris.logger.fatal("Tried to pop from an empty program stack!");
            Iris.logger.fatal("Program stack log: " + this.programStackLog);
            throw new IllegalStateException("Tried to pop from an empty program stack!");
        }
        GbufferProgram gbufferProgram2 = this.programStack.remove(this.programStack.size() - 1);
        if (gbufferProgram2 != gbufferProgram) {
            Iris.logger.fatal("Program stack in invalid state, popped " + gbufferProgram2 + " but expected to pop " + gbufferProgram);
            Iris.logger.fatal("Program stack content after pop: " + this.programStack);
            throw new IllegalStateException("Program stack in invalid state, popped " + gbufferProgram2 + " but expected to pop " + gbufferProgram);
        }
        if (gbufferProgram2 != GbufferProgram.NONE && (object = this.getPass(gbufferProgram2)) != null) {
            object.stopUsing();
        }
        this.programStackLog.add("pop:" + gbufferProgram2);
        if (this.programStack.isEmpty()) {
            this.teardownProgram();
            return;
        }
        object = this.programStack.get(this.programStack.size() - 1);
        this.useProgram((GbufferProgram)((Object)object));
    }

    private Pass getPass(GbufferProgram gbufferProgram) {
        switch (gbufferProgram) {
            case TERRAIN: {
                return this.terrain;
            }
            case TRANSLUCENT_TERRAIN: {
                return this.translucent;
            }
            case DAMAGED_BLOCKS: {
                return this.damagedBlock;
            }
            case BASIC: {
                return this.basic;
            }
            case LINES: {
                return this.basic;
            }
            case BEACON_BEAM: {
                return this.beaconBeam;
            }
            case ENTITIES: {
                return this.entities;
            }
            case ENTITY_NO_OVERLAY: {
                return this.entityNoOverlay;
            }
            case BLOCK_ENTITIES: {
                return this.blockEntities;
            }
            case ENTITIES_GLOWING: {
                return this.glowingEntities;
            }
            case EYES: {
                return this.eyes;
            }
            case EYES_NO_OVERLAY: {
                return this.eyesNoOverlay;
            }
            case ARMOR_GLINT: {
                return this.glint;
            }
            case CLOUDS: {
                return this.clouds;
            }
            case SKY_BASIC: {
                return this.skyBasic;
            }
            case SKY_TEXTURED: {
                return this.skyTextured;
            }
            case TEXTURED_LIT: {
                return this.texturedLit;
            }
            case TEXTURED: {
                return this.textured;
            }
            case WEATHER: {
                return this.weather;
            }
            case HAND: {
                return this.hand;
            }
            case HAND_NO_OVERLAY: {
                return this.handNoOverlay;
            }
            case HAND_TRANSLUCENT: {
                return this.handTranslucent;
            }
        }
        throw new UnsupportedOperationException("TODO: Unsupported gbuffer program: " + gbufferProgram);
    }

    private void useProgram(GbufferProgram gbufferProgram) {
        if (gbufferProgram == GbufferProgram.NONE) {
            Program.unbind();
            return;
        }
        Pass pass = this.getPass(gbufferProgram);
        this.beginPass(pass);
        if (gbufferProgram == GbufferProgram.TERRAIN) {
            if (this.terrain != null) {
                DeferredWorldRenderingPipeline.setupAttributeDefaults(this.terrain);
            }
        } else if (gbufferProgram == GbufferProgram.TRANSLUCENT_TERRAIN && this.translucent != null) {
            DeferredWorldRenderingPipeline.setupAttributeDefaults(this.translucent);
        }
    }

    private void teardownProgram() {
        Program.unbind();
        this.baseline.bind();
    }

    @Override
    public boolean shouldDisableVanillaEntityShadows() {
        return this.shadowMapRenderer instanceof ShadowRenderer;
    }

    @Override
    public boolean shouldDisableDirectionalShading() {
        return !this.oldLighting;
    }

    @Override
    public boolean shouldRenderClouds() {
        return this.shouldRenderClouds;
    }

    @Override
    public boolean shouldRenderUnderwaterOverlay() {
        return this.shouldRenderUnderwaterOverlay;
    }

    @Override
    public boolean shouldRenderVignette() {
        return this.shouldRenderVignette;
    }

    @Override
    public boolean shouldWriteRainAndSnowToDepthBuffer() {
        return this.shouldWriteRainAndSnowToDepthBuffer;
    }

    @Override
    public boolean shouldRenderParticlesBeforeDeferred() {
        return this.shouldRenderParticlesBeforeDeferred;
    }

    @Override
    public float getSunPathRotation() {
        return this.sunPathRotation;
    }

    private void beginPass(Pass pass) {
        if (pass != null) {
            pass.use();
        } else {
            Program.unbind();
            this.baseline.bind();
        }
    }

    private Pass createPass(ProgramSource programSource) {
        ProgramBuilder programBuilder;
        try {
            programBuilder = ProgramBuilder.begin(programSource.getName(), programSource.getVertexSource().orElseThrow(NullPointerException::new), programSource.getGeometrySource().orElse(null), programSource.getFragmentSource().orElseThrow(NullPointerException::new), IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Shader compilation failed!", runtimeException);
        }
        return this.createPassInner(programBuilder, programSource.getParent().getPack().getIdMap(), programSource.getDirectives(), programSource.getParent().getPackDirectives());
    }

    private Pass createEntityPass(ProgramSource programSource) {
        ProgramBuilder programBuilder;
        String string = programSource.getGeometrySource().orElse(null);
        String string2 = AttributeShaderTransformer.patch(new StringTransformations(programSource.getVertexSource().orElseThrow(NullPointerException::new)), ShaderType.VERTEX, string != null).toString();
        String string3 = AttributeShaderTransformer.patch(new StringTransformations(programSource.getVertexSource().orElseThrow(NullPointerException::new)), ShaderType.FRAGMENT, string != null).toString();
        try {
            programBuilder = ProgramBuilder.begin(programSource.getName(), string2, string, string3, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Shader compilation failed!", runtimeException);
        }
        return this.createPassInner(programBuilder, programSource.getParent().getPack().getIdMap(), programSource.getDirectives(), programSource.getParent().getPackDirectives());
    }

    private Pass createPassInner(ProgramBuilder programBuilder, IdMap idMap, ProgramDirectives programDirectives, PackDirectives packDirectives) {
        CommonUniforms.addCommonUniforms(programBuilder, idMap, packDirectives, this.updateNotifier, null);
        Supplier<ImmutableSet<Integer>> supplier = () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        TextureStage textureStage = TextureStage.GBUFFERS_AND_SHADOW;
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(programBuilder, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)textureStage, (Object)Object2ObjectMaps.emptyMap())));
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, supplier, this.renderTargets, false);
        IrisImages.addRenderTargetImages(programBuilder, supplier, this.renderTargets);
        IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (class_1044)this.customTextureManager.getNormals(), (class_1044)this.customTextureManager.getSpecular());
        IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
        if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
            this.createShadowMapRenderer.run();
            IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowMapRenderer);
            IrisImages.addShadowColorImages((ImageHolder)programBuilder, this.shadowMapRenderer);
        }
        GlFramebuffer glFramebuffer = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, programDirectives.getDrawBuffers());
        GlFramebuffer glFramebuffer2 = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, programDirectives.getDrawBuffers());
        programBuilder.bindAttributeLocation(11, "mc_Entity");
        programBuilder.bindAttributeLocation(12, "mc_midTexCoord");
        programBuilder.bindAttributeLocation(13, "at_tangent");
        AlphaTest alphaTest = programDirectives.getAlphaTestOverride().orElse(null);
        Pass pass = new Pass(programBuilder.build(), glFramebuffer, glFramebuffer2, alphaTest, programDirectives.getBlendModeOverride());
        this.allPasses.add(pass);
        return pass;
    }

    @Override
    public void destroy() {
        DeferredWorldRenderingPipeline.destroyPasses(this.allPasses);
        this.compositeRenderer.destroy();
        this.deferredRenderer.destroy();
        this.finalPassRenderer.destroy();
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
        GlStateManager._glBindFramebuffer((int)36009, (int)0);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
        class_310.method_1551().method_1522().method_1235(false);
        this.renderTargets.destroy();
        this.shadowMapRenderer.destroy();
        this.customTextureManager.destroy();
    }

    private static void destroyPasses(List<Pass> list) {
        HashSet<Pass> hashSet = new HashSet<Pass>();
        for (Pass pass : list) {
            if (pass == null || hashSet.contains(pass)) continue;
            pass.destroy();
            hashSet.add(pass);
        }
    }

    private static void setupAttributeDefaults(Pass pass) {
        DeferredWorldRenderingPipeline.setupAttribute(pass, "mc_Entity", 11, -1.0f, -1.0f, -1.0f, -1.0f);
        DeferredWorldRenderingPipeline.setupAttribute(pass, "mc_midTexCoord", 12, 0.0f, 0.0f, 0.0f, 0.0f);
        DeferredWorldRenderingPipeline.setupAttribute(pass, "at_tangent", 13, 1.0f, 0.0f, 0.0f, 1.0f);
    }

    private static void setupAttribute(Pass pass, String string, int n, float f, float f2, float f3, float f4) {
        int n2 = GlStateManager._glGetAttribLocation((int)pass.getProgram().getProgramId(), (CharSequence)string);
        if (n2 != -1) {
            if (n2 != n) {
                throw new IllegalStateException();
            }
            IrisRenderSystem.vertexAttrib4f(n2, f, f2, f3, f4);
        }
    }

    private void prepareRenderTargets() {
        ImmutableList<ClearPass> immutableList;
        RenderSystem.activeTexture((int)33984);
        class_276 class_2762 = class_310.method_1551().method_1522();
        Blaze3dRenderTargetExt blaze3dRenderTargetExt = (Blaze3dRenderTargetExt)class_2762;
        this.renderTargets.resizeIfNeeded(blaze3dRenderTargetExt.iris$isDepthBufferDirty(), class_2762.method_30278(), class_2762.field_1482, class_2762.field_1481);
        blaze3dRenderTargetExt.iris$clearDepthBufferDirtyFlag();
        if (this.renderTargets.isFullClearRequired()) {
            this.renderTargets.onFullClear();
            immutableList = this.clearPassesFull;
        } else {
            immutableList = this.clearPasses;
        }
        Vector3d vector3d = CapturedRenderingState.INSTANCE.getFogColor();
        Vector4f vector4f = new Vector4f((float)vector3d.x, (float)vector3d.y, (float)vector3d.z, 1.0f);
        for (ClearPass clearPass : immutableList) {
            clearPass.execute(vector4f);
        }
    }

    @Override
    public void beginHand() {
        this.baseline.bind();
        GlStateManager._bindTexture((int)this.renderTargets.getDepthTextureNoHand().getTextureId());
        IrisRenderSystem.copyTexImage2D(3553, 0, 6402, 0, 0, this.renderTargets.getCurrentWidth(), this.renderTargets.getCurrentHeight(), 0);
        GlStateManager._bindTexture((int)0);
    }

    @Override
    public void beginTranslucents() {
        this.isBeforeTranslucent = false;
        this.baseline.bind();
        GlStateManager._bindTexture((int)this.renderTargets.getDepthTextureNoTranslucents().getTextureId());
        IrisRenderSystem.copyTexImage2D(3553, 0, 6402, 0, 0, this.renderTargets.getCurrentWidth(), this.renderTargets.getCurrentHeight(), 0);
        GlStateManager._bindTexture((int)0);
        this.centerDepthSampler.updateSample();
        this.deferredRenderer.renderAll();
        Program.unbind();
        RenderSystem.enableBlend();
        class_310.method_1551().field_1773.method_22974().method_3316();
        class_310.method_1551().field_1773.method_22975().method_23209();
        if (!this.programStack.isEmpty()) {
            GbufferProgram gbufferProgram = this.programStack.get(this.programStack.size() - 1);
            this.useProgram(gbufferProgram);
        } else {
            this.useProgram(GbufferProgram.NONE);
            this.baseline.bind();
        }
    }

    @Override
    public void renderShadows(LevelRendererAccessor levelRendererAccessor, class_4184 class_41842) {
        this.shadowMapRenderer.renderShadows(levelRendererAccessor, class_41842);
        this.prepareRenderer.renderAll();
    }

    @Override
    public void addDebugText(List<String> list) {
        if (this.shadowMapRenderer != null) {
            list.add("");
            this.shadowMapRenderer.addDebugText(list);
        }
    }

    @Override
    public OptionalInt getForcedShadowRenderDistanceChunksForDisplay() {
        return this.forcedShadowRenderDistanceChunks;
    }

    @Override
    public void beginLevelRendering() {
        this.isRenderingWorld = true;
        this.isBeforeTranslucent = true;
        this.phase = WorldRenderingPhase.NONE;
        HandRenderer.INSTANCE.getBufferSource().resetDrawCalls();
        this.checkWorld();
        if (!this.isRenderingWorld) {
            Iris.logger.warn("beginWorldRender was called but we are not currently rendering a world?");
            return;
        }
        if (!this.programStack.isEmpty()) {
            throw new IllegalStateException("Program stack before the start of rendering, something has gone very wrong!");
        }
        this.updateNotifier.onNewFrame();
        this.prepareRenderTargets();
        this.pushProgram(GbufferProgram.BASIC);
    }

    @Override
    public void finalizeLevelRendering() {
        this.checkWorld();
        if (!this.isRenderingWorld) {
            Iris.logger.warn("finalizeWorldRendering was called but we are not currently rendering a world?");
            return;
        }
        this.popProgram(GbufferProgram.BASIC);
        if (!this.programStack.isEmpty()) {
            Iris.logger.fatal("Program stack not empty at end of rendering, something has gone very wrong!");
            Iris.logger.fatal("Program stack log: " + this.programStackLog);
            Iris.logger.fatal("Program stack content: " + this.programStack);
            throw new IllegalStateException("Program stack not empty at end of rendering, something has gone very wrong!");
        }
        this.isRenderingWorld = false;
        this.phase = WorldRenderingPhase.NONE;
        this.programStackLog.clear();
        this.compositeRenderer.renderAll();
        this.finalPassRenderer.renderFinalPass();
    }

    @Override
    public SodiumTerrainPipeline getSodiumTerrainPipeline() {
        return this.sodiumTerrainPipeline;
    }

    @Override
    public FrameUpdateNotifier getFrameUpdateNotifier() {
        return this.updateNotifier;
    }

    @Override
    public WorldRenderingPhase getPhase() {
        return this.phase;
    }

    @Override
    public void setPhase(WorldRenderingPhase worldRenderingPhase) {
        this.phase = worldRenderingPhase;
        GbufferPrograms.runPhaseChangeNotifier();
    }

    @Override
    public void beginShadowRender() {
        this.isRenderingShadow = true;
    }

    @Override
    public void endShadowRender() {
        this.isRenderingShadow = false;
    }

    private final class Pass {
        private final Program program;
        private final GlFramebuffer framebufferBeforeTranslucents;
        private final GlFramebuffer framebufferAfterTranslucents;
        private final AlphaTest alphaTestOverride;
        private final BlendModeOverride blendModeOverride;

        private Pass(Program program, GlFramebuffer glFramebuffer, GlFramebuffer glFramebuffer2, AlphaTest alphaTest, BlendModeOverride blendModeOverride) {
            this.program = program;
            this.framebufferBeforeTranslucents = glFramebuffer;
            this.framebufferAfterTranslucents = glFramebuffer2;
            this.alphaTestOverride = alphaTest;
            this.blendModeOverride = blendModeOverride;
        }

        public void use() {
            if (DeferredWorldRenderingPipeline.this.isBeforeTranslucent) {
                this.framebufferBeforeTranslucents.bind();
            } else {
                this.framebufferAfterTranslucents.bind();
            }
            this.program.use();
            if (this.alphaTestOverride != null) {
                AlphaTestStorage.overrideAlphaTest(this.alphaTestOverride);
            } else {
                AlphaTestStorage.restoreAlphaTest();
            }
            if (this.blendModeOverride != null) {
                this.blendModeOverride.apply();
            } else {
                BlendModeOverride.restore();
            }
        }

        public void stopUsing() {
            if (this.alphaTestOverride != null) {
                AlphaTestStorage.restoreAlphaTest();
            }
            if (this.blendModeOverride != null) {
                BlendModeOverride.restore();
            }
        }

        public Program getProgram() {
            return this.program;
        }

        public void destroy() {
            this.program.destroy();
        }
    }
}

