/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.newshader;

import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.AttributeShaderTransformer;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.shaderpack.transform.BuiltinUniformReplacementTransformer;
import net.coderbot.iris.shaderpack.transform.StringTransformations;
import net.coderbot.iris.shaderpack.transform.Transformations;

public class TriforcePatcher {
    public static void patchCommon(StringTransformations stringTransformations, ShaderType shaderType) {
        if (stringTransformations.contains("moj_import")) {
            throw new IllegalStateException("Iris shader programs may not use moj_import directives.");
        }
        if (stringTransformations.contains("iris_")) {
            throw new IllegalStateException("Detected a potential reference to unstable and internal Iris shader interfaces (iris_). This isn't currently supported.");
        }
        TriforcePatcher.fixVersion(stringTransformations);
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "uniform float iris_FogDensity;\nuniform float iris_FogStart;\nuniform float iris_FogEnd;\nuniform vec4 iris_FogColor;\n\nstruct iris_FogParameters {\n    vec4 color;\n    float density;\n    float start;\n    float end;\n    float scale;\n};\n\niris_FogParameters iris_Fog = iris_FogParameters(iris_FogColor, iris_FogDensity, iris_FogStart, iris_FogEnd, 1.0 / (iris_FogEnd - iris_FogStart));\n\n#define gl_Fog iris_Fog");
        stringTransformations.define("gl_FogFragCoord", "iris_FogFragCoord");
        if (shaderType == ShaderType.VERTEX) {
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "out float iris_FogFragCoord;");
        } else if (shaderType == ShaderType.FRAGMENT) {
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in float iris_FogFragCoord;");
        }
        if (shaderType == ShaderType.VERTEX) {
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 iris_FrontColor;");
            stringTransformations.define("gl_FrontColor", "iris_FrontColor");
        }
        if (shaderType == ShaderType.FRAGMENT) {
            if (stringTransformations.contains("gl_FragColor")) {
                Iris.logger.warn("[Triforce Patcher] gl_FragColor is not supported yet, please use gl_FragData! Assuming that the shaderpack author intended to use gl_FragData[0]...");
                stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_FragColor iris_FragData[0]");
            }
            stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_FragData iris_FragData");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "out vec4 iris_FragData[8];");
        }
        if (shaderType == ShaderType.VERTEX) {
            stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define attribute in");
            stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define varying out");
        } else if (shaderType == ShaderType.FRAGMENT) {
            stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define varying in");
        }
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 texture2D(sampler2D sampler, vec2 coord) { return texture(sampler, coord); }");
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 texture3D(sampler3D sampler, vec3 coord) { return texture(sampler, coord); }");
        if (shaderType == ShaderType.FRAGMENT) {
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 texture2D(sampler2D sampler, vec2 coord, float bias) { return texture(sampler, coord, bias); }");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 texture3D(sampler3D sampler, vec3 coord, float bias) { return texture(sampler, coord, bias); }");
        }
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 texture2DLod(sampler2D sampler, vec2 coord, float lod) { return textureLod(sampler, coord, lod); }");
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 texture3DLod(sampler3D sampler, vec3 coord, float lod) { return textureLod(sampler, coord, lod); }");
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 shadow2D(sampler2DShadow sampler, vec3 coord) { return vec4(texture(sampler, coord)); }");
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 shadow2DLod(sampler2DShadow sampler, vec3 coord, float lod) { return vec4(textureLod(sampler, coord, lod)); }");
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 texture2DGrad(sampler2D sampler, vec2 coord, vec2 dPdx, vec2 dPdy) { return textureGrad(sampler, coord, dPdx, dPdy); }");
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 texture2DGradARB(sampler2D sampler, vec2 coord, vec2 dPdx, vec2 dPdy) { return textureGrad(sampler, coord, dPdx, dPdy); }");
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 texture3DGrad(sampler3D sampler, vec3 coord, vec3 dPdx, vec3 dPdy) { return textureGrad(sampler, coord, dPdx, dPdy); }");
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 texelFetch2D(sampler2D sampler, ivec2 coord, int lod) { return texelFetch(sampler, coord, lod); }");
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 texelFetch3D(sampler3D sampler, ivec3 coord, int lod) { return texelFetch(sampler, coord, lod); }");
    }

    public static String patchVanilla(String string, ShaderType shaderType, AlphaTest alphaTest, boolean bl, ShaderAttributeInputs shaderAttributeInputs, boolean bl2) {
        StringTransformations stringTransformations = new StringTransformations(string);
        TriforcePatcher.patchCommon(stringTransformations, shaderType);
        if (shaderAttributeInputs.hasOverlay()) {
            AttributeShaderTransformer.patch(stringTransformations, shaderType, bl2);
        }
        TriforcePatcher.addAlphaTest(stringTransformations, shaderType, alphaTest);
        stringTransformations.define("gl_ProjectionMatrix", "iris_ProjMat");
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "uniform mat4 iris_ProjMat;");
        if (shaderType == ShaderType.VERTEX) {
            if (shaderAttributeInputs.hasTex()) {
                stringTransformations.define("gl_MultiTexCoord0", "vec4(iris_UV0, 0.0, 1.0)");
                stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in vec2 iris_UV0;");
            } else {
                stringTransformations.define("gl_MultiTexCoord0", "vec4(0.5, 0.5, 0.0, 1.0)");
            }
            if (shaderAttributeInputs.hasLight()) {
                stringTransformations.define("gl_MultiTexCoord1", "vec4(iris_UV2, 0.0, 1.0)");
                stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in ivec2 iris_UV2;");
            } else {
                stringTransformations.define("gl_MultiTexCoord1", "vec4(240.0, 240.0, 0.0, 1.0)");
            }
            for (int i = 2; i < 8; ++i) {
                stringTransformations.define("gl_MultiTexCoord" + i, " vec4(0.0, 0.0, 0.0, 1.0)");
            }
        }
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "uniform vec4 iris_ColorModulator;");
        if (shaderAttributeInputs.hasColor()) {
            stringTransformations.define("gl_Color", "(iris_Color * iris_ColorModulator)");
            if (shaderType == ShaderType.VERTEX) {
                stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in vec4 iris_Color;");
            }
        } else {
            stringTransformations.define("gl_Color", "iris_ColorModulator");
        }
        if (shaderType == ShaderType.VERTEX) {
            if (shaderAttributeInputs.hasNormal()) {
                if (!shaderAttributeInputs.isNewLines()) {
                    stringTransformations.define("gl_Normal", "iris_Normal");
                } else {
                    stringTransformations.define("gl_Normal", "vec3(0.0, 0.0, 1.0)");
                }
                stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in vec3 iris_Normal;");
            } else {
                stringTransformations.define("gl_Normal", "vec3(0.0, 0.0, 1.0)");
            }
        }
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "uniform mat4 iris_LightmapTextureMatrix;");
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "uniform mat4 iris_TextureMat;");
        stringTransformations.replaceExact("gl_TextureMatrix[0]", "iris_TextureMat");
        stringTransformations.replaceExact("gl_TextureMatrix[1]", "iris_LightmapTextureMatrix");
        stringTransformations.define("gl_NormalMatrix", "mat3(transpose(inverse(gl_ModelViewMatrix)))");
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "uniform mat4 iris_ModelViewMat;");
        if (bl) {
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "uniform vec3 iris_ChunkOffset;");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "mat4 _iris_internal_translate(vec3 offset) {\n    // NB: Column-major order\n    return mat4(1.0, 0.0, 0.0, 0.0,\n                0.0, 1.0, 0.0, 0.0,\n                0.0, 0.0, 1.0, 0.0,\n                offset.x, offset.y, offset.z, 1.0);\n}");
            stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_ModelViewMatrix (iris_ModelViewMat * _iris_internal_translate(iris_ChunkOffset))");
        } else if (shaderAttributeInputs.isNewLines()) {
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "const float iris_VIEW_SHRINK = 1.0 - (1.0 / 256.0);\nconst mat4 iris_VIEW_SCALE = mat4(\n    iris_VIEW_SHRINK, 0.0, 0.0, 0.0,\n    0.0, iris_VIEW_SHRINK, 0.0, 0.0,\n    0.0, 0.0, iris_VIEW_SHRINK, 0.0,\n    0.0, 0.0, 0.0, 1.0\n);");
            stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_ModelViewMatrix (iris_VIEW_SCALE * iris_ModelViewMat)");
        } else {
            stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_ModelViewMatrix iris_ModelViewMat");
        }
        stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_ModelViewProjectionMatrix (gl_ProjectionMatrix * gl_ModelViewMatrix)");
        if (shaderType == ShaderType.VERTEX) {
            if (shaderAttributeInputs.isNewLines()) {
                stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec3 iris_vertex_offset = vec3(0.0);");
                stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_Vertex vec4(iris_Position + iris_vertex_offset, 1.0)");
                if (stringTransformations.contains("irisMain")) {
                    throw new IllegalStateException("Shader already contains \"irisMain\"???");
                }
                stringTransformations.replaceExact("main", "irisMain");
                stringTransformations.injectLine(Transformations.InjectionPoint.END, "uniform vec2 iris_ScreenSize;\nuniform float iris_LineWidth;\n\n// Widen the line into a rectangle of appropriate width\n// Isolated from Minecraft's rendertype_lines.vsh\n// Both arguments are positions in NDC space (the same space as gl_Position)\nvoid iris_widen_lines(vec4 linePosStart, vec4 linePosEnd) {\n    vec3 ndc1 = linePosStart.xyz / linePosStart.w;\n    vec3 ndc2 = linePosEnd.xyz / linePosEnd.w;\n\n    vec2 lineScreenDirection = normalize((ndc2.xy - ndc1.xy) * iris_ScreenSize);\n    vec2 lineOffset = vec2(-lineScreenDirection.y, lineScreenDirection.x) * iris_LineWidth / iris_ScreenSize;\n\n    if (lineOffset.x < 0.0) {\n        lineOffset *= -1.0;\n    }\n\n    if (gl_VertexID % 2 == 0) {\n        gl_Position = vec4((ndc1 + vec3(lineOffset, 0.0)) * linePosStart.w, linePosStart.w);\n    } else {\n        gl_Position = vec4((ndc1 - vec3(lineOffset, 0.0)) * linePosStart.w, linePosStart.w);\n    }\n}\n\nvoid main() {\n    iris_vertex_offset = iris_Normal;\n    irisMain();\n    vec4 linePosEnd = gl_Position;\n    gl_Position = vec4(0.0);\n\n    iris_vertex_offset = vec3(0.0);\n    irisMain();\n    vec4 linePosStart = gl_Position;\n\n    iris_widen_lines(linePosStart, linePosEnd);\n}");
            } else {
                stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_Vertex vec4(iris_Position, 1.0)");
            }
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in vec3 iris_Position;");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 ftransform() { return gl_ModelViewProjectionMatrix * gl_Vertex; }");
        }
        return stringTransformations.toString();
    }

    public static String patchSodium(String string, ShaderType shaderType, AlphaTest alphaTest, ShaderAttributeInputs shaderAttributeInputs, float f, float f2, float f3) {
        StringTransformations stringTransformations = new StringTransformations(string);
        TriforcePatcher.patchCommon(stringTransformations, shaderType);
        TriforcePatcher.addAlphaTest(stringTransformations, shaderType, alphaTest);
        stringTransformations.replaceExact("gl_TextureMatrix[0]", "mat4(1.0)");
        stringTransformations.define("gl_ProjectionMatrix", "u_ProjectionMatrix");
        if (shaderType == ShaderType.VERTEX) {
            if (shaderAttributeInputs.hasTex()) {
                stringTransformations.define("gl_MultiTexCoord0", "vec4(_vert_tex_diffuse_coord, 0.0, 1.0)");
            } else {
                stringTransformations.define("gl_MultiTexCoord0", "vec4(0.0, 0.0, 0.0, 1.0)");
            }
            if (shaderAttributeInputs.hasLight()) {
                new BuiltinUniformReplacementTransformer("_vert_tex_light_coord").apply(stringTransformations);
            } else {
                stringTransformations.define("gl_MultiTexCoord1", "vec4(0.0, 0.0, 0.0, 1.0)");
            }
            for (int i = 2; i < 8; ++i) {
                stringTransformations.define("gl_MultiTexCoord" + i, " vec4(0.0, 0.0, 0.0, 1.0)");
            }
        }
        if (shaderAttributeInputs.hasColor()) {
            stringTransformations.define("gl_Color", "_vert_color");
            if (shaderType == ShaderType.VERTEX) {
                // empty if block
            }
        } else {
            stringTransformations.define("gl_Color", "vec4(1.0)");
        }
        if (shaderType == ShaderType.VERTEX) {
            if (shaderAttributeInputs.hasNormal()) {
                stringTransformations.define("gl_Normal", "a_Normal");
                stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in vec3 a_Normal;");
            } else {
                stringTransformations.define("gl_Normal", "vec3(0.0, 0.0, 1.0)");
            }
        }
        stringTransformations.define("gl_NormalMatrix", "mat3(u_NormalMatrix)");
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "uniform mat4 u_NormalMatrix;");
        stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_ModelViewMatrix u_ModelViewMatrix");
        stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_ModelViewProjectionMatrix (u_ProjectionMatrix * u_ModelViewMatrix)");
        if (shaderType == ShaderType.VERTEX) {
            stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define USE_VERTEX_COMPRESSION");
            stringTransformations.define("VERT_POS_SCALE", String.valueOf(f));
            stringTransformations.define("VERT_POS_OFFSET", String.valueOf(f2));
            stringTransformations.define("VERT_TEX_SCALE", String.valueOf(f3));
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "uniform vec3 u_RegionOffset;");
            stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, SodiumTerrainPipeline.parseSodiumImport("#import <sodium:include/chunk_vertex.glsl>"));
            stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, SodiumTerrainPipeline.parseSodiumImport("#import <sodium:include/chunk_parameters.glsl>"));
            stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, SodiumTerrainPipeline.parseSodiumImport("#import <sodium:include/chunk_matrices.glsl>"));
            stringTransformations.define("gl_Vertex", "getVertexPosition()");
            if (stringTransformations.contains("irisMain")) {
                throw new IllegalStateException("Shader already contains \"irisMain\"???");
            }
            stringTransformations.replaceExact("main", "irisMain");
            stringTransformations.injectLine(Transformations.InjectionPoint.END, "void main() {\n   _vert_init();\n\n\tirisMain();\n}");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 getVertexPosition() { return vec4(u_RegionOffset + _draw_translation + _vert_position, 1.0); }");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 ftransform() { return gl_ModelViewProjectionMatrix * gl_Vertex; }");
        } else {
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "uniform mat4 u_ModelViewMatrix;");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "uniform mat4 u_ProjectionMatrix;");
        }
        stringTransformations.define("ftransform", "iris_ftransform");
        return stringTransformations.toString();
    }

    public static String patchComposite(String string, ShaderType shaderType) {
        int n;
        StringTransformations stringTransformations = new StringTransformations(string);
        TriforcePatcher.patchCommon(stringTransformations, shaderType);
        for (n = 0; n < 8; ++n) {
            stringTransformations.replaceExact("gl_TextureMatrix[" + n + "]", "mat4(1.0)");
            stringTransformations.replaceExact("gl_TextureMatrix [" + n + "]", "mat4(1.0)");
        }
        stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_ProjectionMatrix mat4(vec4(2.0, 0.0, 0.0, 0.0), vec4(0.0, 2.0, 0.0, 0.0), vec4(0.0), vec4(-1.0, -1.0, 0.0, 1.0))");
        if (shaderType == ShaderType.VERTEX) {
            stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_MultiTexCoord0 vec4(UV0, 0.0, 1.0)");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in vec2 UV0;");
            for (n = 1; n < 8; ++n) {
                stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_MultiTexCoord" + n + " vec4(0.0, 0.0, 0.0, 1.0)");
            }
        }
        stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_Color vec4(1.0, 1.0, 1.0, 1.0)");
        if (shaderType == ShaderType.VERTEX) {
            stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_Normal vec3(0.0, 0.0, 1.0)");
        }
        stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_NormalMatrix mat3(1.0)");
        stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_ModelViewMatrix mat4(1.0)");
        stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_ModelViewProjectionMatrix (gl_ProjectionMatrix * gl_ModelViewMatrix)");
        if (shaderType == ShaderType.VERTEX) {
            stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_Vertex vec4(Position, 1.0)");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in vec3 Position;");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 ftransform() { return gl_ModelViewProjectionMatrix * gl_Vertex; }");
        }
        return stringTransformations.toString();
    }

    private static void addAlphaTest(StringTransformations stringTransformations, ShaderType shaderType, AlphaTest alphaTest) {
        if (shaderType == ShaderType.FRAGMENT) {
            if (stringTransformations.contains("irisMain")) {
                throw new IllegalStateException("Shader already contains \"irisMain\"???");
            }
            stringTransformations.replaceExact("main", "irisMain");
            stringTransformations.injectLine(Transformations.InjectionPoint.END, "void main() {\n    irisMain();\n\n" + alphaTest.toExpression("    ") + "}");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void fixVersion(Transformations transformations) {
        String string = transformations.getPrefix();
        int n = string.indexOf("#version");
        Object object = string.substring(0, n);
        Object object2 = string.substring(n + "#version".length()).trim();
        if (((String)object2).endsWith(" core")) {
            throw new IllegalStateException("Transforming a shader that is already built against the core profile???");
        }
        if (!((String)object2).startsWith("1")) {
            if (!((String)object2).endsWith("compatibility")) throw new IllegalStateException("Expected \"compatibility\" after the GLSL version: #version " + (String)object2);
            object2 = ((String)object2).substring(0, ((String)object2).length() - "compatibility".length()).trim() + " core";
        } else {
            object2 = "150 core";
        }
        object = ((String)object).trim();
        if (!((String)object).isEmpty()) {
            object = (String)object + "\n";
        }
        transformations.setPrefix((String)object + "#version " + (String)object2 + "\n");
    }
}

