/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.postprocess;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.image.ImageHolder;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.sampler.SamplerLimits;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.TriforcePatcher;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.FullScreenQuadRenderer;
import net.coderbot.iris.rendertarget.Blaze3dRenderTargetExt;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shadows.ShadowMapRenderer;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_276;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class FinalPassRenderer {
    private final RenderTargets renderTargets;
    @Nullable
    private final Pass finalPass;
    private final ImmutableList<SwapPass> swapPasses;
    private final GlFramebuffer baseline;
    private final GlFramebuffer colorHolder;
    private int lastColorTextureId;
    private final IntSupplier noiseTexture;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final Object2ObjectMap<String, IntSupplier> customTextureIds;

    public FinalPassRenderer(ProgramSet programSet, RenderTargets renderTargets, IntSupplier intSupplier, FrameUpdateNotifier frameUpdateNotifier, ImmutableSet<Integer> immutableSet, CenterDepthSampler centerDepthSampler, Supplier<ShadowMapRenderer> supplier, Object2ObjectMap<String, IntSupplier> object2ObjectMap, ImmutableSet<Integer> immutableSet2) {
        this.updateNotifier = frameUpdateNotifier;
        this.centerDepthSampler = centerDepthSampler;
        this.customTextureIds = object2ObjectMap;
        PackRenderTargetDirectives packRenderTargetDirectives = programSet.getPackDirectives().getRenderTargetDirectives();
        Map<Integer, PackRenderTargetDirectives.RenderTargetSettings> map = packRenderTargetDirectives.getRenderTargetSettings();
        this.noiseTexture = intSupplier;
        this.renderTargets = renderTargets;
        this.finalPass = programSet.getCompositeFinal().map(programSource -> {
            Pass pass = new Pass();
            ProgramDirectives programDirectives = programSource.getDirectives();
            pass.program = this.createProgram((ProgramSource)programSource, immutableSet, immutableSet2, supplier);
            pass.stageReadsFromAlt = immutableSet;
            pass.mipmappedBuffers = programDirectives.getMipmappedBuffers();
            return pass;
        }).orElse(null);
        IntList intList = programSet.getPackDirectives().getRenderTargetDirectives().getBuffersToBeCleared();
        this.baseline = renderTargets.createGbufferFramebuffer(immutableSet, new int[]{0});
        this.colorHolder = new GlFramebuffer();
        this.lastColorTextureId = class_310.method_1551().method_1522().method_30277();
        this.colorHolder.addColorAttachment(0, this.lastColorTextureId);
        ImmutableList.Builder builder = ImmutableList.builder();
        immutableSet.forEach(n -> {
            int n2 = n;
            if (intList.contains(n2)) {
                return;
            }
            SwapPass swapPass = new SwapPass();
            swapPass.from = renderTargets.createFramebufferWritingToAlt(new int[]{n2});
            swapPass.targetTexture = renderTargets.get(n2).getMainTexture();
            builder.add((Object)swapPass);
        });
        this.swapPasses = builder.build();
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
    }

    public void renderFinalPass() {
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)false);
        class_276 class_2762 = class_310.method_1551().method_1522();
        int n = class_2762.field_1482;
        int n2 = class_2762.field_1481;
        if (((Blaze3dRenderTargetExt)class_2762).iris$isColorBufferDirty() || class_2762.method_30277() != this.lastColorTextureId) {
            ((Blaze3dRenderTargetExt)class_2762).iris$clearColorBufferDirtyFlag();
            this.lastColorTextureId = class_2762.method_30277();
            this.colorHolder.addColorAttachment(0, this.lastColorTextureId);
        }
        if (this.finalPass != null) {
            this.colorHolder.bind();
            FullScreenQuadRenderer.INSTANCE.begin();
            if (!this.finalPass.mipmappedBuffers.isEmpty()) {
                RenderSystem.activeTexture((int)33984);
                UnmodifiableIterator unmodifiableIterator = this.finalPass.mipmappedBuffers.iterator();
                while (unmodifiableIterator.hasNext()) {
                    int n3 = (Integer)unmodifiableIterator.next();
                    FinalPassRenderer.setupMipmapping(this.renderTargets.get(n3), this.finalPass.stageReadsFromAlt.contains((Object)n3));
                }
            }
            this.finalPass.program.use();
            FullScreenQuadRenderer.INSTANCE.renderQuad();
            FullScreenQuadRenderer.INSTANCE.end();
        } else {
            this.baseline.bindAsReadBuffer();
            RenderSystem.bindTexture((int)class_2762.method_30277());
            GlStateManager._glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)n, (int)n2);
        }
        RenderSystem.activeTexture((int)33984);
        for (int i = 0; i < this.renderTargets.getRenderTargetCount(); ++i) {
            FinalPassRenderer.resetRenderTarget(this.renderTargets.get(i));
        }
        for (SwapPass swapPass : this.swapPasses) {
            swapPass.from.bind();
            RenderSystem.bindTexture((int)swapPass.targetTexture);
            GlStateManager._glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)n, (int)n2);
            RenderSystem.bindTexture((int)0);
            GlStateManager._glBindFramebuffer((int)36008, (int)0);
        }
        class_2762.method_1235(true);
        GlStateManager._glUseProgram((int)0);
        for (int i = 0; i < SamplerLimits.get().getMaxTextureUnits(); ++i) {
            RenderSystem.activeTexture((int)(33984 + i));
            RenderSystem.bindTexture((int)0);
        }
        RenderSystem.activeTexture((int)33984);
    }

    private static void setupMipmapping(RenderTarget renderTarget, boolean bl) {
        RenderSystem.bindTexture((int)(bl ? renderTarget.getAltTexture() : renderTarget.getMainTexture()));
        IrisRenderSystem.generateMipmaps(3553);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9987);
    }

    private static void resetRenderTarget(RenderTarget renderTarget) {
        RenderSystem.bindTexture((int)renderTarget.getMainTexture());
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.bindTexture((int)renderTarget.getAltTexture());
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.bindTexture((int)0);
    }

    private Program createProgram(ProgramSource programSource, ImmutableSet<Integer> immutableSet, ImmutableSet<Integer> immutableSet2, Supplier<ShadowMapRenderer> supplier) {
        ProgramBuilder programBuilder;
        String string = TriforcePatcher.patchComposite(programSource.getVertexSource().orElseThrow(RuntimeException::new), ShaderType.VERTEX);
        String string2 = null;
        if (programSource.getGeometrySource().isPresent()) {
            string2 = TriforcePatcher.patchComposite(programSource.getGeometrySource().orElseThrow(RuntimeException::new), ShaderType.GEOMETRY);
        }
        String string3 = TriforcePatcher.patchComposite(programSource.getFragmentSource().orElseThrow(RuntimeException::new), ShaderType.FRAGMENT);
        Objects.requireNonNull(immutableSet);
        try {
            programBuilder = ProgramBuilder.begin(programSource.getName(), string, string2, string3, IrisSamplers.COMPOSITE_RESERVED_TEXTURE_UNITS);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Shader compilation failed!", runtimeException);
        }
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(programBuilder, this.customTextureIds, immutableSet2);
        CommonUniforms.addCommonUniforms(programBuilder, programSource.getParent().getPack().getIdMap(), programSource.getParent().getPackDirectives(), this.updateNotifier, FogMode.OFF);
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> immutableSet, this.renderTargets, true);
        IrisImages.addRenderTargetImages(programBuilder, () -> immutableSet, this.renderTargets);
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.noiseTexture);
        IrisSamplers.addCompositeSamplers(customTextureSamplerInterceptor, this.renderTargets);
        if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
            IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, supplier.get());
            IrisImages.addShadowColorImages((ImageHolder)programBuilder, supplier.get());
        }
        programBuilder.uniform1f(UniformUpdateFrequency.PER_FRAME, "centerDepthSmooth", this.centerDepthSampler::getCenterDepthSmoothSample);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            Path path = FabricLoader.getInstance().getGameDir().resolve("patched_shaders");
            try {
                Files.write(path.resolve(programSource.getName() + ".vsh"), string.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                if (programSource.getGeometrySource().isPresent()) {
                    Files.write(path.resolve(programSource.getName() + ".gsh"), string2.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                Files.write(path.resolve(programSource.getName() + ".fsh"), string3.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException iOException) {
                Iris.logger.warn("Failed to write debug patched shader source", iOException);
            }
        }
        return programBuilder.build();
    }

    public void destroy() {
        if (this.finalPass != null) {
            this.finalPass.destroy();
        }
    }

    private static final class Pass {
        Program program;
        ImmutableSet<Integer> stageReadsFromAlt;
        ImmutableSet<Integer> mipmappedBuffers;

        private Pass() {
        }

        private void destroy() {
            this.program.destroy();
        }
    }

    private static final class SwapPass {
        GlFramebuffer from;
        int targetTexture;

        private SwapPass() {
        }
    }
}

