/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.samplers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shadows.ShadowMapRenderer;
import net.coderbot.iris.texunits.TextureUnit;
import net.minecraft.class_1044;

public class IrisSamplers {
    public static final ImmutableSet<Integer> WORLD_RESERVED_TEXTURE_UNITS = ImmutableSet.of((Object)TextureUnit.TERRAIN.getSamplerId(), (Object)TextureUnit.LIGHTMAP.getSamplerId(), (Object)TextureUnit.OVERLAY.getSamplerId());
    public static final ImmutableSet<Integer> COMPOSITE_RESERVED_TEXTURE_UNITS = ImmutableSet.of((Object)TextureUnit.LIGHTMAP.getSamplerId(), (Object)TextureUnit.OVERLAY.getSamplerId());

    private IrisSamplers() {
    }

    public static void addRenderTargetSamplers(SamplerHolder samplerHolder, Supplier<ImmutableSet<Integer>> supplier, RenderTargets renderTargets, boolean bl) {
        int n;
        for (int i = n = bl ? 0 : 4; i < renderTargets.getRenderTargetCount(); ++i) {
            int n2 = i;
            IntSupplier intSupplier = () -> {
                ImmutableSet immutableSet = (ImmutableSet)supplier.get();
                RenderTarget renderTarget = renderTargets.get(n2);
                if (immutableSet.contains((Object)n2)) {
                    return renderTarget.getAltTexture();
                }
                return renderTarget.getMainTexture();
            };
            String string = "colortex" + i;
            if (i < PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.size()) {
                String string2 = (String)PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.get(i);
                if (i == 0 && bl) {
                    samplerHolder.addDefaultSampler(intSupplier, string, string2);
                    continue;
                }
                samplerHolder.addDynamicSampler(intSupplier, string, string2);
                continue;
            }
            samplerHolder.addDynamicSampler(intSupplier, string);
        }
    }

    public static void addNoiseSampler(SamplerHolder samplerHolder, IntSupplier intSupplier) {
        samplerHolder.addDynamicSampler(intSupplier, "noisetex");
    }

    public static boolean hasShadowSamplers(SamplerHolder samplerHolder) {
        ImmutableList immutableList = ImmutableList.of((Object)"shadowtex0", (Object)"shadowtex1", (Object)"shadow", (Object)"watershadow", (Object)"shadowcolor", (Object)"shadowcolor0", (Object)"shadowcolor1", (Object)"shadowcolorimg0", (Object)"shadowcolorimg1");
        for (String string : immutableList) {
            if (!samplerHolder.hasSampler(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean addShadowSamplers(SamplerHolder samplerHolder, ShadowMapRenderer shadowMapRenderer) {
        boolean bl;
        boolean bl2 = samplerHolder.hasSampler("watershadow");
        if (bl2) {
            bl = true;
            samplerHolder.addDynamicSampler(shadowMapRenderer::getDepthTextureId, "shadowtex0", "watershadow");
            samplerHolder.addDynamicSampler(shadowMapRenderer::getDepthTextureNoTranslucentsId, "shadowtex1", "shadow");
        } else {
            bl = samplerHolder.addDynamicSampler(shadowMapRenderer::getDepthTextureId, "shadowtex0", "shadow");
            bl |= samplerHolder.addDynamicSampler(shadowMapRenderer::getDepthTextureNoTranslucentsId, "shadowtex1");
        }
        samplerHolder.addDynamicSampler(shadowMapRenderer::getColorTexture0Id, "shadowcolor", "shadowcolor0");
        samplerHolder.addDynamicSampler(shadowMapRenderer::getColorTexture1Id, "shadowcolor1");
        return bl;
    }

    public static void addLevelSamplers(SamplerHolder samplerHolder, class_1044 class_10442, class_1044 class_10443) {
        samplerHolder.addExternalSampler(TextureUnit.TERRAIN.getSamplerId(), "tex", "texture", "gtexture");
        samplerHolder.addExternalSampler(TextureUnit.LIGHTMAP.getSamplerId(), "lightmap");
        samplerHolder.addExternalSampler(TextureUnit.OVERLAY.getSamplerId(), "iris_overlay");
        samplerHolder.addDynamicSampler(() -> ((class_1044)class_10442).method_4624(), "normals");
        samplerHolder.addDynamicSampler(() -> ((class_1044)class_10443).method_4624(), "specular");
    }

    public static void addWorldDepthSamplers(SamplerHolder samplerHolder, RenderTargets renderTargets) {
        samplerHolder.addDynamicSampler(renderTargets::getDepthTexture, "depthtex0");
        samplerHolder.addDynamicSampler(renderTargets.getDepthTextureNoTranslucents()::getTextureId, "depthtex1");
    }

    public static void addCompositeSamplers(SamplerHolder samplerHolder, RenderTargets renderTargets) {
        samplerHolder.addDynamicSampler(renderTargets::getDepthTexture, "gdepthtex", "depthtex0");
        samplerHolder.addDynamicSampler(renderTargets.getDepthTextureNoTranslucents()::getTextureId, "depthtex1");
        samplerHolder.addDynamicSampler(renderTargets.getDepthTextureNoHand()::getTextureId, "depthtex2");
    }
}

