/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.shader.GlShader;
import net.coderbot.iris.gl.shader.ShaderConstants;
import net.coderbot.iris.shaderpack.DimensionId;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.LanguageMap;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ShaderProperties;
import net.coderbot.iris.shaderpack.include.AbsolutePackPath;
import net.coderbot.iris.shaderpack.include.IncludeGraph;
import net.coderbot.iris.shaderpack.include.IncludeProcessor;
import net.coderbot.iris.shaderpack.include.ShaderPackSourceNames;
import net.coderbot.iris.shaderpack.option.ProfileSet;
import net.coderbot.iris.shaderpack.option.ShaderPackOptions;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuContainer;
import net.coderbot.iris.shaderpack.option.values.MutableOptionValues;
import net.coderbot.iris.shaderpack.preprocessor.JcppProcessor;
import net.coderbot.iris.shaderpack.texture.CustomTextureData;
import net.coderbot.iris.shaderpack.texture.TextureFilteringData;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shaderpack.transform.line.LineTransform;
import net.coderbot.iris.shaderpack.transform.line.VersionDirectiveNormalizer;
import org.jetbrains.annotations.Nullable;

public class ShaderPack {
    private static final Gson GSON = new Gson();
    private final ProgramSet base;
    @Nullable
    private final ProgramSet overworld;
    private final ProgramSet nether;
    private final ProgramSet end;
    private final IdMap idMap;
    private final LanguageMap languageMap;
    private final Object2ObjectMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> customTextureDataMap = new Object2ObjectOpenHashMap();
    private final CustomTextureData customNoiseTexture;
    private final ShaderPackOptions shaderPackOptions;
    private final OptionMenuContainer menuContainer;
    private final ProfileSet.ProfileResult profile;
    private final String profileInfo;

    public ShaderPack(Path path) throws IOException {
        this(path, Collections.emptyMap());
    }

    public ShaderPack(Path path, Map<String, String> map) throws IOException {
        Objects.requireNonNull(path);
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList<String> immutableList = ShaderPackSourceNames.POTENTIAL_STARTS;
        ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)builder, path, AbsolutePackPath.fromAbsolutePath("/"), immutableList);
        boolean bl = ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)builder, path, AbsolutePackPath.fromAbsolutePath("/world0"), immutableList);
        boolean bl2 = ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)builder, path, AbsolutePackPath.fromAbsolutePath("/world-1"), immutableList);
        boolean bl3 = ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)builder, path, AbsolutePackPath.fromAbsolutePath("/world1"), immutableList);
        IncludeGraph includeGraph = new IncludeGraph(path, (ImmutableList<AbsolutePackPath>)builder.build());
        if (!includeGraph.getFailures().isEmpty()) {
            includeGraph.getFailures().forEach((absolutePackPath, rusticError) -> Iris.logger.error("{}", rusticError.toString()));
            throw new IOException("Failed to resolve some #include directives, see previous messages for details");
        }
        this.languageMap = new LanguageMap(path.resolve("lang"));
        this.shaderPackOptions = new ShaderPackOptions(includeGraph, map);
        includeGraph = this.shaderPackOptions.getIncludes();
        ShaderProperties shaderProperties = ShaderPack.loadProperties(path, "shaders.properties").map(string -> new ShaderProperties((String)string, this.shaderPackOptions)).orElseGet(ShaderProperties::empty);
        ProfileSet profileSet = ProfileSet.fromTree(shaderProperties.getProfiles(), this.shaderPackOptions.getOptionSet());
        this.profile = profileSet.scan(this.shaderPackOptions.getOptionSet(), this.shaderPackOptions.getOptionValues());
        ArrayList arrayList = new ArrayList();
        this.profile.current.ifPresent(profile -> arrayList.addAll(profile.disabledPrograms));
        this.menuContainer = new OptionMenuContainer(shaderProperties, this.shaderPackOptions, profileSet);
        Object object = this.getCurrentProfileName();
        Object object2 = new MutableOptionValues(this.shaderPackOptions.getOptionSet(), this.profile.current.map(profile -> profile.optionValues).orElse(new HashMap()));
        int n = this.shaderPackOptions.getOptionValues().getOptionsChanged() - object2.getOptionsChanged();
        this.profileInfo = "Profile: " + (String)object + " (+" + n + " option" + (n == 1 ? "" : "s") + " changed by user)";
        Iris.logger.info(this.profileInfo);
        object = new IncludeProcessor(includeGraph);
        object2 = arg_0 -> ShaderPack.lambda$new$4(arrayList, (IncludeProcessor)object, arg_0);
        this.base = new ProgramSet(AbsolutePackPath.fromAbsolutePath("/"), (Function<AbsolutePackPath, String>)object2, shaderProperties, this);
        this.overworld = ShaderPack.loadOverrides(bl, AbsolutePackPath.fromAbsolutePath("/world0"), (Function<AbsolutePackPath, String>)object2, shaderProperties, this);
        this.nether = ShaderPack.loadOverrides(bl2, AbsolutePackPath.fromAbsolutePath("/world-1"), (Function<AbsolutePackPath, String>)object2, shaderProperties, this);
        this.end = ShaderPack.loadOverrides(bl3, AbsolutePackPath.fromAbsolutePath("/world1"), (Function<AbsolutePackPath, String>)object2, shaderProperties, this);
        this.idMap = new IdMap(path, this.shaderPackOptions);
        this.customNoiseTexture = shaderProperties.getNoiseTexturePath().map(string -> {
            try {
                return this.readTexture(path, (String)string);
            }
            catch (IOException iOException) {
                Iris.logger.error("Unable to read the custom noise texture at " + string, iOException);
                return null;
            }
        }).orElse(null);
        shaderProperties.getCustomTextures().forEach((textureStage, object2ObjectMap) -> {
            Object2ObjectOpenHashMap object2ObjectOpenHashMap = new Object2ObjectOpenHashMap();
            object2ObjectMap.forEach((arg_0, arg_1) -> this.lambda$new$6((Object2ObjectMap)object2ObjectOpenHashMap, path, arg_0, arg_1));
            this.customTextureDataMap.put((Object)textureStage, (Object)object2ObjectOpenHashMap);
        });
    }

    private String getCurrentProfileName() {
        return this.profile.current.map(profile -> profile.name).orElse("Custom");
    }

    public String getProfileInfo() {
        return this.profileInfo;
    }

    @Nullable
    private static ProgramSet loadOverrides(boolean bl, AbsolutePackPath absolutePackPath, Function<AbsolutePackPath, String> function, ShaderProperties shaderProperties, ShaderPack shaderPack) {
        if (bl) {
            return new ProgramSet(absolutePackPath, function, shaderProperties, shaderPack);
        }
        return null;
    }

    private static Optional<String> loadProperties(Path path, String string) {
        String string2 = ShaderPack.readProperties(path, string);
        if (string2 == null) {
            return Optional.empty();
        }
        return Optional.of(string2);
    }

    public CustomTextureData readTexture(Path path, String string) throws IOException {
        CustomTextureData customTextureData;
        if (string.contains(":")) {
            String[] stringArray = string.split(":");
            if (stringArray.length > 2) {
                Iris.logger.warn("Resource location " + string + " contained more than two parts?");
            }
            customTextureData = new CustomTextureData.ResourceData(stringArray[0], stringArray[1]);
        } else {
            Object object;
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            boolean bl = false;
            boolean bl2 = false;
            String string2 = string + ".mcmeta";
            Path path2 = path.resolve(string2);
            if (Files.exists(path2, new LinkOption[0]) && (object = this.loadMcMeta(path2)).get("texture") != null) {
                if (object.get("texture").getAsJsonObject().get("blur") != null) {
                    bl = object.get("texture").getAsJsonObject().get("blur").getAsBoolean();
                }
                if (object.get("texture").getAsJsonObject().get("clamp") != null) {
                    bl2 = object.get("texture").getAsJsonObject().get("clamp").getAsBoolean();
                }
            }
            object = Files.readAllBytes(path.resolve(string));
            customTextureData = new CustomTextureData.PngData(new TextureFilteringData(bl, bl2), (byte[])object);
        }
        return customTextureData;
    }

    private JsonObject loadMcMeta(Path path) throws IOException, JsonParseException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), StandardCharsets.UTF_8));
        JsonReader jsonReader = new JsonReader((Reader)bufferedReader);
        return (JsonObject)GSON.getAdapter(JsonObject.class).read(jsonReader);
    }

    private static String readProperties(Path path, String string) {
        try {
            return new String(Files.readAllBytes(path.resolve(string)), StandardCharsets.ISO_8859_1);
        }
        catch (NoSuchFileException noSuchFileException) {
            Iris.logger.debug("An " + string + " file was not found in the current shaderpack");
            return null;
        }
        catch (IOException iOException) {
            Iris.logger.error("An IOException occurred reading " + string + " from the current shaderpack", iOException);
            return null;
        }
    }

    public ProgramSet getProgramSet(DimensionId dimensionId) {
        ProgramSet programSet = switch (dimensionId) {
            case DimensionId.OVERWORLD -> this.overworld;
            case DimensionId.NETHER -> this.nether;
            case DimensionId.END -> this.end;
            default -> throw new IllegalArgumentException("Unknown dimension " + dimensionId);
        };
        if (programSet != null) {
            return programSet;
        }
        return this.base;
    }

    public IdMap getIdMap() {
        return this.idMap;
    }

    public Object2ObjectMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> getCustomTextureDataMap() {
        return this.customTextureDataMap;
    }

    public Optional<CustomTextureData> getCustomNoiseTexture() {
        return Optional.ofNullable(this.customNoiseTexture);
    }

    public LanguageMap getLanguageMap() {
        return this.languageMap;
    }

    public ShaderPackOptions getShaderPackOptions() {
        return this.shaderPackOptions;
    }

    public OptionMenuContainer getMenuContainer() {
        return this.menuContainer;
    }

    private /* synthetic */ void lambda$new$6(Object2ObjectMap object2ObjectMap, Path path, String string, String string2) {
        try {
            object2ObjectMap.put((Object)string, (Object)this.readTexture(path, string2));
        }
        catch (IOException iOException) {
            Iris.logger.error("Unable to read the custom texture at " + string2, iOException);
        }
    }

    private static /* synthetic */ String lambda$new$4(List list, IncludeProcessor includeProcessor, AbsolutePackPath absolutePackPath) {
        String string4;
        String string2;
        String string3 = string2.substring((string2 = absolutePackPath.getPathString()).indexOf("/") == 0 ? 1 : 0, string2.lastIndexOf("."));
        if (list.contains(string3)) {
            return null;
        }
        ImmutableList<String> immutableList = includeProcessor.getIncludedFile(absolutePackPath);
        if (immutableList == null) {
            return null;
        }
        immutableList = LineTransform.apply(immutableList, VersionDirectiveNormalizer.INSTANCE);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string4 : immutableList) {
            stringBuilder.append(string4);
            stringBuilder.append('\n');
        }
        Object object = ProgramBuilder.MACRO_CONSTANTS;
        string4 = GlShader.processShader(stringBuilder.toString(), (ShaderConstants)object);
        string4 = JcppProcessor.glslPreprocessSource(string4);
        return string4;
    }
}

