/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.util;

import dev.architectury.fluid.FluidStack;
import java.util.Iterator;
import java.util.stream.Stream;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.EntryTypeBridge;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3611;

public final class EntryStacks {
    private EntryStacks() {
    }

    public static EntryStack<FluidStack> of(class_3611 fluid) {
        return EntryStacks.of(fluid, FluidStack.bucketAmount());
    }

    public static EntryStack<FluidStack> of(class_3611 fluid, long amount) {
        return EntryStack.of(VanillaEntryTypes.FLUID, FluidStack.create((class_3611)fluid, (long)amount));
    }

    public static EntryStack<FluidStack> of(FluidStack stack) {
        return EntryStack.of(VanillaEntryTypes.FLUID, stack);
    }

    public static EntryStack<class_1799> of(class_1799 stack) {
        return EntryStack.of(VanillaEntryTypes.ITEM, stack);
    }

    public static EntryStack<class_1799> of(class_1935 item) {
        return EntryStacks.of(new class_1799(item));
    }

    public static EntryStack<class_1799> of(class_1935 item, int amount) {
        return EntryStacks.of(new class_1799(item, amount));
    }

    public static <A, B> boolean equals(EntryStack<A> left, EntryStack<B> right, ComparisonContext context) {
        EntryStack next;
        Iterator iterator;
        Object holder;
        EntryType<B> rightType;
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return left == null;
        }
        if (left == right) {
            return true;
        }
        EntryType<A> leftType = left.getType();
        if (leftType == (rightType = right.getType())) {
            return left.getDefinition().equals(left.getValue(), right.castValue(), context);
        }
        EntryTypeRegistry instance = EntryTypeRegistry.getInstance();
        for (EntryTypeBridge<A, B> entryTypeBridge : instance.getBridgesFor(leftType, rightType)) {
            holder = entryTypeBridge.bridge(left);
            if (!holder.isTrue()) continue;
            iterator = ((Stream)holder.object()).iterator();
            while (iterator.hasNext()) {
                next = (EntryStack)iterator.next();
                if (!next.getDefinition().equals(next.getValue(), right.getValue(), context)) continue;
                return true;
            }
        }
        for (EntryTypeBridge<Object, Object> entryTypeBridge : instance.getBridgesFor(rightType, leftType)) {
            holder = entryTypeBridge.bridge(right);
            if (!holder.isTrue()) continue;
            iterator = ((Stream)holder.object()).iterator();
            while (iterator.hasNext()) {
                next = (EntryStack)iterator.next();
                if (!next.getDefinition().equals(next.getValue(), left.getValue(), context)) continue;
                return true;
            }
        }
        return false;
    }

    public static <A, B> boolean equalsExact(EntryStack<A> left, EntryStack<B> right) {
        return EntryStacks.equals(left, right, ComparisonContext.EXACT);
    }

    public static <A, B> boolean equalsFuzzy(EntryStack<A> left, EntryStack<B> right) {
        return EntryStacks.equals(left, right, ComparisonContext.FUZZY);
    }

    public static <T> long hash(EntryStack<T> stack, ComparisonContext context) {
        return stack.getDefinition().hash(stack, stack.getValue(), context);
    }

    public static <T> long hashExact(EntryStack<T> stack) {
        return EntryStacks.hash(stack, ComparisonContext.EXACT);
    }

    public static <T> long hashFuzzy(EntryStack<T> stack) {
        return EntryStacks.hash(stack, ComparisonContext.FUZZY);
    }
}

