/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.dragging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.FloatingRectangle;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import net.minecraft.class_265;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class CurrentDraggingStack
extends Widget
implements LateRenderable,
DraggingContext<class_437> {
    private DraggableStackProvider<class_437> provider;
    private DraggableStackVisitor<class_437> visitor;
    @Nullable
    private DraggableEntry entry;
    private final List<RenderBackEntry> backToOriginals = new ArrayList<RenderBackEntry>();
    private final Set<ShapeBounds> bounds = new HashSet<ShapeBounds>();

    public void set(DraggableStackProvider<class_437> provider, DraggableStackVisitor<class_437> visitor) {
        this.provider = provider;
        this.visitor = visitor;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        Integer hash = null;
        if (this.entry != null) {
            if (!this.entry.dragging) {
                double requiredDistance;
                double yDistance;
                Point startPoint = this.entry.start;
                double xDistance = Math.abs(startPoint.x - mouseX);
                if (xDistance * xDistance + (yDistance = (double)Math.abs(startPoint.y - mouseY)) * yDistance > (requiredDistance = 8.0) * requiredDistance) {
                    this.entry.dragging = true;
                    this.entry.stack.drag();
                }
            }
            if (!RoughlyEnoughItemsCoreClient.isLeftMousePressed) {
                this.drop();
            } else if (this.entry.dragging) {
                matrices.method_22903();
                matrices.method_22904(0.0, 0.0, 600.0);
                this.entry.stack.render(matrices, new Rectangle(mouseX - 8, mouseY - 8, 16, 16), mouseX, mouseY, delta);
                matrices.method_22909();
                class_265 shape = this.entry.getBoundsProvider().bounds();
                ShapeBounds shapeBounds = new ShapeBounds(shape);
                shapeBounds.alpha.setTo(60, 300L);
                this.bounds.add(shapeBounds);
                hash = shapeBounds.hash;
            }
        }
        for (ShapeBounds bound : this.bounds) {
            if (hash != null && hash == bound.hash || (Double)bound.alpha.target() == 0.0) continue;
            bound.alpha.setTo(0, 300L);
        }
        Iterator<Object> iterator = this.bounds.iterator();
        while (iterator.hasNext()) {
            ShapeBounds bounds = iterator.next();
            bounds.update(delta);
            if ((Double)bounds.alpha.target() == 0.0 && (Double)bounds.alpha.value() <= 2.0) {
                iterator.remove();
                continue;
            }
            bounds.shape.method_1089((x1, y1, z1, x2, y2, z2) -> {
                matrices.method_22903();
                matrices.method_22904(0.0, 0.0, 500.0);
                this.method_25296(matrices, (int)x1, (int)y1, (int)x2, (int)y2, 0xFDFF6B | bounds.alpha.intValue() << 24, 0xFDFF6B | bounds.alpha.intValue() << 24);
                matrices.method_22909();
            });
        }
        iterator = this.backToOriginals.iterator();
        while (iterator.hasNext()) {
            RenderBackEntry renderBackEntry = (RenderBackEntry)iterator.next();
            renderBackEntry.update(delta);
            FloatingRectangle value = (FloatingRectangle)renderBackEntry.bounds.value();
            FloatingRectangle target = (FloatingRectangle)renderBackEntry.bounds.target();
            if (value.width < 2.0 || value.height < 2.0 || Math.abs(value.x - target.x) <= 2.0 && Math.abs(value.y - target.y) <= 2.0 && Math.abs(value.width - target.width) <= 1.0 && Math.abs(value.height - target.height) <= 1.0) {
                iterator.remove();
                continue;
            }
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, 600.0);
            renderBackEntry.stack.render(matrices, value.getBounds(), mouseX, mouseY, delta);
            matrices.method_22909();
        }
    }

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.drop();
        DraggableStack hoveredStack = this.provider.getHoveredStack(this, mouseX, mouseY);
        if (hoveredStack != null) {
            this.entry = new DraggableEntry(hoveredStack, new Point(mouseX, mouseY));
        }
        return false;
    }

    public boolean method_25406(double d, double e, int i) {
        return false;
    }

    public boolean method_25403(double mouseX1, double mouseY1, int button, double mouseX2, double mouseY2) {
        return this.entry != null && this.entry.dragging;
    }

    private boolean drop() {
        if (this.entry != null && this.entry.dragging) {
            DraggedAcceptorResult result = this.visitor.acceptDraggedStack(this, this.entry.stack);
            this.entry.stack.release(result);
            this.entry = null;
            return true;
        }
        this.entry = null;
        return false;
    }

    @Override
    public class_437 getScreen() {
        return class_310.method_1551().field_1755;
    }

    @Override
    @Nullable
    public DraggableStack getCurrentStack() {
        return this.entry != null && this.entry.dragging ? this.entry.stack : null;
    }

    @Override
    @Nullable
    public Point getCurrentPosition() {
        return this.isDraggingStack() ? PointHelper.ofMouse() : null;
    }

    @Override
    public void renderBackToPosition(DraggableStack stack, Point initialPosition, Supplier<Point> position) {
        this.backToOriginals.add(new RenderBackEntry(stack, new Rectangle(initialPosition.x - 8, initialPosition.y - 8, 16, 16), () -> {
            Point point = (Point)position.get();
            return new Rectangle(point.x, point.y, 16, 16);
        }));
    }

    @Override
    public void renderBackToPosition(DraggableStack stack, Rectangle initialPosition, Supplier<Rectangle> bounds) {
        this.backToOriginals.add(new RenderBackEntry(stack, initialPosition, bounds));
    }

    private class DraggableEntry {
        private final DraggableStack stack;
        private final Point start;
        private boolean dragging = false;
        private DraggableStackVisitor.BoundsProvider boundsProvider;

        private DraggableEntry(DraggableStack stack, Point start) {
            this.stack = stack;
            this.start = start;
        }

        public DraggableStackVisitor.BoundsProvider getBoundsProvider() {
            if (this.boundsProvider == null) {
                this.boundsProvider = DraggableStackVisitor.BoundsProvider.concat(CurrentDraggingStack.this.visitor.getDraggableAcceptingBounds(CurrentDraggingStack.this, this.stack).toList());
            }
            return this.boundsProvider;
        }
    }

    private static class ShapeBounds {
        private class_265 shape;
        private NumberAnimator<Double> alpha;
        private int hash;

        public ShapeBounds(class_265 shape) {
            this.shape = shape;
            this.alpha = ValueAnimator.ofDouble((double)0.0);
            this.hash = shape.method_1090().hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ShapeBounds)) {
                return false;
            }
            ShapeBounds shapeBounds = (ShapeBounds)o;
            return this.hash == shapeBounds.hash;
        }

        public int hashCode() {
            return this.hash;
        }

        public void update(double delta) {
            this.alpha.update(delta);
        }
    }

    private static class RenderBackEntry {
        private final DraggableStack stack;
        private final Supplier<Rectangle> position;
        private ValueAnimator<FloatingRectangle> bounds = ValueAnimator.ofFloatingRectangle();
        private int lastDestination = -1;

        public RenderBackEntry(DraggableStack stack, Rectangle initialPosition, Supplier<Rectangle> position) {
            this.stack = stack;
            this.bounds.setAs((Object)new FloatingRectangle(initialPosition));
            this.position = position;
        }

        public Rectangle getPosition() {
            return this.position.get();
        }

        public void update(double delta) {
            this.bounds.update(delta);
            this.bounds.setTo((Object)new FloatingRectangle(this.getPosition()), 200L);
        }
    }
}

