/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import java.util.function.Function;
import java.util.stream.Stream;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.entry.comparison.EntryComparator;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.common.plugins.REIServerPlugin;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.simple.RecipeBookGridMenuInfo;
import me.shedaniel.rei.api.common.transfer.info.simple.SimpleMenuInfoProvider;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultCampfireDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultCompostingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultFuelDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultInformationDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultOxidationScrapingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultOxidizingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultPathingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultSmithingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultStoneCuttingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultStrippingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultTillingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultWaxScrapingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultWaxingDisplay;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconBaseDisplay;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconDisplay;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconPaymentDisplay;
import me.shedaniel.rei.plugin.common.displays.brewing.DefaultBrewingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultBlastingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultCookingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultSmeltingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultSmokingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import me.shedaniel.rei.plugin.common.fabric.DefaultPluginImpl;
import net.minecraft.class_1714;
import net.minecraft.class_1723;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3611;
import net.minecraft.class_3705;
import net.minecraft.class_3706;
import net.minecraft.class_3858;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class DefaultPlugin
implements BuiltinPlugin,
REIServerPlugin {
    @Override
    public void registerItemComparators(ItemComparatorRegistry registry) {
        EntryComparator<class_2520> nbtHasher = EntryComparator.nbt(new String[0]);
        Function<class_1799, class_2499> enchantmentTag = stack -> {
            class_2487 tag = stack.method_7969();
            if (tag == null) {
                return null;
            }
            if (!tag.method_10573("Enchantments", 9)) {
                if (tag.method_10573("StoredEnchantments", 9)) {
                    return tag.method_10554("StoredEnchantments", 10);
                }
                return null;
            }
            return tag.method_10554("Enchantments", 10);
        };
        registry.register((context, stack) -> nbtHasher.hash(context, (class_2520)enchantmentTag.apply((class_1799)stack)), class_1802.field_8598);
        registry.registerNbt(class_1802.field_8574);
        registry.registerNbt(class_1802.field_8436);
        registry.registerNbt(class_1802.field_8150);
        registry.registerNbt(class_1802.field_8087);
    }

    @Override
    public void registerFluidSupport(FluidSupportProvider support) {
        support.register(entry -> {
            class_1755 bucketItem;
            class_3611 fluid;
            class_1799 stack = (class_1799)entry.getValue();
            class_1792 item = stack.method_7909();
            if (item instanceof class_1755 && (fluid = DefaultPlugin.getFluidFromBucket(bucketItem = (class_1755)item)) != null) {
                return CompoundEventResult.interruptTrue(Stream.of(EntryStacks.of(fluid, FluidStackHooks.bucketAmount())));
            }
            return CompoundEventResult.pass();
        });
        if (Platform.isForge()) {
            DefaultPlugin.registerForgeFluidSupport((FluidSupportProvider)support);
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static class_3611 getFluidFromBucket(class_1755 item) {
        return DefaultPluginImpl.getFluidFromBucket(item);
    }

    @Override
    public void registerDisplaySerializer(DisplaySerializerRegistry registry) {
        registry.register(CRAFTING, DefaultCraftingDisplay.serializer());
        registry.register(SMELTING, DefaultCookingDisplay.serializer(DefaultSmeltingDisplay::new));
        registry.register(SMOKING, DefaultCookingDisplay.serializer(DefaultSmokingDisplay::new));
        registry.register(BLASTING, DefaultCookingDisplay.serializer(DefaultBlastingDisplay::new));
        registry.register(CAMPFIRE, DefaultCampfireDisplay.serializer());
        registry.register(STONE_CUTTING, DefaultStoneCuttingDisplay.serializer());
        registry.register(STRIPPING, DefaultStrippingDisplay.serializer());
        registry.register(BREWING, DefaultBrewingDisplay.serializer());
        registry.register(COMPOSTING, DefaultCompostingDisplay.serializer());
        registry.register(FUEL, DefaultFuelDisplay.serializer());
        registry.register(SMITHING, DefaultSmithingDisplay.serializer());
        registry.register(BEACON_BASE, DefaultBeaconDisplay.serializer(DefaultBeaconBaseDisplay::new));
        registry.register(BEACON_PAYMENT, DefaultBeaconDisplay.serializer(DefaultBeaconPaymentDisplay::new));
        registry.register(TILLING, DefaultTillingDisplay.serializer());
        registry.register(PATHING, DefaultPathingDisplay.serializer());
        registry.register(WAXING, DefaultWaxingDisplay.serializer());
        registry.register(WAX_SCRAPING, DefaultWaxScrapingDisplay.serializer());
        registry.register(OXIDIZING, DefaultOxidizingDisplay.serializer());
        registry.register(OXIDATION_SCRAPING, DefaultOxidationScrapingDisplay.serializer());
        registry.register(INFO, DefaultInformationDisplay.serializer());
    }

    @Override
    public void registerMenuInfo(MenuInfoRegistry registry) {
        registry.register(BuiltinPlugin.CRAFTING, class_1714.class, SimpleMenuInfoProvider.of(RecipeBookGridMenuInfo::new));
        registry.register(BuiltinPlugin.CRAFTING, class_1723.class, SimpleMenuInfoProvider.of(RecipeBookGridMenuInfo::new));
        registry.register(BuiltinPlugin.SMELTING, class_3858.class, SimpleMenuInfoProvider.of(RecipeBookGridMenuInfo::new));
        registry.register(BuiltinPlugin.SMOKING, class_3706.class, SimpleMenuInfoProvider.of(RecipeBookGridMenuInfo::new));
        registry.register(BuiltinPlugin.BLASTING, class_3705.class, SimpleMenuInfoProvider.of(RecipeBookGridMenuInfo::new));
    }

    @Override
    public double getPriority() {
        return -100.0;
    }
}

