/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.zombiehorsespawn.config;

import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class ConfigHandler {
    public static PropertyMirror<Double> chanceSurfaceZombieHasHorse = PropertyMirror.create((ConfigType)ConfigTypes.DOUBLE);
    public static PropertyMirror<Boolean> shouldBurnZombieHorsesInDaylight = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> onlySpawnZombieHorsesOnSurface = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    private static final ConfigTree CONFIG = ConfigTree.builder().beginValue("chanceSurfaceZombieHasHorse", (ConfigType)ConfigTypes.DOUBLE, (Object)0.05).withComment("The chance a zombie that has spawned on the surface is riding a horse.").finishValue(arg_0 -> chanceSurfaceZombieHasHorse.mirror(arg_0)).beginValue("shouldBurnZombieHorsesInDaylight", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("If enabled, burns zombie horses when daylight shines upon them.").finishValue(arg_0 -> shouldBurnZombieHorsesInDaylight.mirror(arg_0)).beginValue("onlySpawnZombieHorsesOnSurface", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("If enabled, a zombie horse with rider will only spawn on the surface.").finishValue(arg_0 -> onlySpawnZombieHorsesOnSurface.mirror(arg_0)).build();

    private static void writeDefaultConfig(Path path, JanksonValueSerializer serializer) {
        try (BufferedOutputStream s = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));){
            FiberSerialization.serialize((ConfigTree)CONFIG, (OutputStream)s, (ValueSerializer)serializer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setup() {
        JanksonValueSerializer serializer = new JanksonValueSerializer(false);
        Path p = Paths.get("config", "zombiehorsespawn-fabric.json");
        ConfigHandler.writeDefaultConfig(p, serializer);
        try (BufferedInputStream s = new BufferedInputStream(Files.newInputStream(p, StandardOpenOption.READ, StandardOpenOption.CREATE));){
            FiberSerialization.deserialize((ConfigTree)CONFIG, (InputStream)s, (ValueSerializer)serializer);
        }
        catch (ValueDeserializationException | IOException e) {
            System.out.println("Error loading config");
        }
    }
}

