/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.config.option;

import com.terraformersmc.modmenu.config.option.ConfigOptionStorage;
import com.terraformersmc.modmenu.config.option.OptionConvertable;
import com.terraformersmc.modmenu.util.TranslationUtil;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_316;
import net.minecraft.class_4064;
import net.minecraft.class_5244;

public class EnumConfigOption<E extends Enum<E>>
implements OptionConvertable {
    private final String key;
    private final String translationKey;
    private final Class<E> enumClass;
    private final E defaultValue;

    public EnumConfigOption(String key, E defaultValue) {
        ConfigOptionStorage.setEnum(key, defaultValue);
        this.key = key;
        this.translationKey = TranslationUtil.translationKeyOf("option", key);
        this.enumClass = ((Enum)defaultValue).getDeclaringClass();
        this.defaultValue = defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public E getValue() {
        return ConfigOptionStorage.getEnum(this.key, this.enumClass);
    }

    public void setValue(E value) {
        ConfigOptionStorage.setEnum(this.key, value);
    }

    public void cycleValue() {
        ConfigOptionStorage.cycleEnum(this.key, this.enumClass);
    }

    public void cycleValue(int amount) {
        ConfigOptionStorage.cycleEnum(this.key, this.enumClass, amount);
    }

    public E getDefaultValue() {
        return this.defaultValue;
    }

    private static <E extends Enum<E>> class_2561 getValueText(EnumConfigOption<E> option, E value) {
        return new class_2588(option.translationKey + "." + value.name().toLowerCase(Locale.ROOT));
    }

    public class_2561 getButtonText() {
        return class_5244.method_32700((class_2561)new class_2588(this.translationKey), (class_2561)EnumConfigOption.getValueText(this, this.getValue()));
    }

    @Override
    public class_316 asOption() {
        return class_4064.method_32526((String)this.translationKey, (Object[])((Enum[])this.enumClass.getEnumConstants()), value -> EnumConfigOption.getValueText(this, value), ignored -> ConfigOptionStorage.getEnum(this.key, this.enumClass), (ignored, option, value) -> ConfigOptionStorage.setEnum(this.key, value));
    }
}

