/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.component;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.util.ChoseOriginCriterion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class PlayerOriginComponent
implements OriginComponent {
    private class_1657 player;
    private HashMap<OriginLayer, Origin> origins = new HashMap();
    private boolean hadOriginBefore = false;

    public PlayerOriginComponent(class_1657 player) {
        this.player = player;
    }

    @Override
    public boolean hasAllOrigins() {
        return OriginLayers.getLayers().stream().allMatch(layer -> !layer.isEnabled() || layer.getOrigins(this.player).size() == 0 || this.origins.containsKey(layer) && this.origins.get(layer) != null && this.origins.get(layer) != Origin.EMPTY);
    }

    @Override
    public HashMap<OriginLayer, Origin> getOrigins() {
        return this.origins;
    }

    @Override
    public boolean hasOrigin(OriginLayer layer) {
        return this.origins != null && this.origins.containsKey(layer) && this.origins.get(layer) != null && this.origins.get(layer) != Origin.EMPTY;
    }

    @Override
    public Origin getOrigin(OriginLayer layer) {
        if (!this.origins.containsKey(layer)) {
            return null;
        }
        return this.origins.get(layer);
    }

    @Override
    public boolean hadOriginBefore() {
        return this.hadOriginBefore;
    }

    @Override
    public void setOrigin(OriginLayer layer, Origin origin) {
        class_1657 class_16572;
        Origin oldOrigin = this.getOrigin(layer);
        if (oldOrigin == origin) {
            return;
        }
        this.origins.put(layer, origin);
        PowerHolderComponent powerComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.player);
        this.grantPowersFromOrigin(origin, powerComponent);
        if (oldOrigin != null) {
            powerComponent.removeAllPowersFromSource(oldOrigin.getIdentifier());
        }
        if (this.hasAllOrigins()) {
            this.hadOriginBefore = true;
        }
        if ((class_16572 = this.player) instanceof class_3222) {
            class_3222 spe = (class_3222)class_16572;
            ChoseOriginCriterion.INSTANCE.trigger(spe, origin);
        }
    }

    private void grantPowersFromOrigin(Origin origin, PowerHolderComponent powerComponent) {
        class_2960 source = origin.getIdentifier();
        for (PowerType<?> powerType : origin.getPowerTypes()) {
            if (powerComponent.hasPower(powerType, source)) continue;
            powerComponent.addPower(powerType, source);
        }
    }

    private void revokeRemovedPowers(Origin origin, PowerHolderComponent powerComponent) {
        class_2960 source = origin.getIdentifier();
        List powersByOrigin = powerComponent.getPowersFromSource(source);
        powersByOrigin.stream().filter(p -> !origin.hasPowerType((PowerType<?>)p)).forEach(p -> powerComponent.removePower(p, source));
    }

    public void readFromNbt(class_2487 compoundTag) {
        if (this.player == null) {
            Origins.LOGGER.error("Player was null in `fromTag`! This is a bug!");
        }
        this.origins.clear();
        if (compoundTag.method_10545("Origin")) {
            try {
                OriginLayer defaultOriginLayer = OriginLayers.getLayer(new class_2960("origins", "origin"));
                this.origins.put(defaultOriginLayer, OriginRegistry.get(class_2960.method_12829((String)compoundTag.method_10558("Origin"))));
            }
            catch (IllegalArgumentException e) {
                Origins.LOGGER.warn("Player " + this.player.method_5476().method_10851() + " had old origin which could not be migrated: " + compoundTag.method_10558("Origin"));
            }
        } else {
            class_2499 originLayerList = (class_2499)compoundTag.method_10580("OriginLayers");
            if (originLayerList != null) {
                for (int i = 0; i < originLayerList.size(); ++i) {
                    class_2487 layerTag = originLayerList.method_10602(i);
                    class_2960 layerId = class_2960.method_12829((String)layerTag.method_10558("Layer"));
                    OriginLayer layer = null;
                    try {
                        layer = OriginLayers.getLayer(layerId);
                    }
                    catch (IllegalArgumentException e) {
                        Origins.LOGGER.warn("Could not find origin layer with id " + layerId.toString() + ", which existed on the data of player " + this.player.method_5476().method_10851() + ".");
                    }
                    if (layer == null) continue;
                    class_2960 originId = class_2960.method_12829((String)layerTag.method_10558("Origin"));
                    Origin origin = null;
                    try {
                        origin = OriginRegistry.get(originId);
                    }
                    catch (IllegalArgumentException e) {
                        Origins.LOGGER.warn("Could not find origin with id " + originId.toString() + ", which existed on the data of player " + this.player.method_5476().method_10851() + ".");
                        PowerHolderComponent powerComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.player);
                        powerComponent.removeAllPowersFromSource(originId);
                    }
                    if (origin == null) continue;
                    if (!layer.contains(origin) && !origin.isSpecial()) {
                        Origins.LOGGER.warn("Origin with id " + origin.getIdentifier().toString() + " is not in layer " + layer.getIdentifier().toString() + " and is not special, but was found on " + this.player.method_5476().method_10851() + ", setting to EMPTY.");
                        origin = Origin.EMPTY;
                        PowerHolderComponent powerComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.player);
                        powerComponent.removeAllPowersFromSource(originId);
                    }
                    this.origins.put(layer, origin);
                }
            }
        }
        this.hadOriginBefore = compoundTag.method_10577("HadOriginBefore");
        if (!this.player.field_6002.field_9236) {
            PowerHolderComponent powerComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.player);
            for (Origin origin : this.origins.values()) {
                this.grantPowersFromOrigin(origin, powerComponent);
            }
            for (Origin origin : this.origins.values()) {
                this.revokeRemovedPowers(origin, powerComponent);
            }
            if (compoundTag.method_10545("Powers")) {
                class_2499 powerList = (class_2499)compoundTag.method_10580("Powers");
                for (int i = 0; i < powerList.size(); ++i) {
                    class_2487 powerTag = powerList.method_10602(i);
                    class_2960 powerTypeId = class_2960.method_12829((String)powerTag.method_10558("Type"));
                    try {
                        PowerType type = PowerTypeRegistry.get((class_2960)powerTypeId);
                        if (!powerComponent.hasPower(type)) continue;
                        class_2520 data = powerTag.method_10580("Data");
                        try {
                            powerComponent.getPower(type).fromTag(data);
                        }
                        catch (ClassCastException e) {
                            Origins.LOGGER.warn("Data type of \"" + powerTypeId + "\" changed, skipping data for that power on player " + this.player.method_5477().method_10851());
                        }
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        Origins.LOGGER.warn("Power data of unregistered power \"" + powerTypeId + "\" found on player, skipping...");
                    }
                }
            }
        }
    }

    @Override
    public void onPowersRead() {
    }

    public void writeToNbt(class_2487 compoundTag) {
        class_2499 originLayerList = new class_2499();
        for (Map.Entry<OriginLayer, Origin> entry : this.origins.entrySet()) {
            class_2487 layerTag = new class_2487();
            layerTag.method_10582("Layer", entry.getKey().getIdentifier().toString());
            layerTag.method_10582("Origin", entry.getValue().getIdentifier().toString());
            originLayerList.add((Object)layerTag);
        }
        compoundTag.method_10566("OriginLayers", (class_2520)originLayerList);
        compoundTag.method_10556("HadOriginBefore", this.hadOriginBefore);
    }

    @Override
    public void sync() {
        OriginComponent.sync(this.player);
    }
}

