/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_fabric.functions;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_fabric.data.GlobalVariables;
import com.natamus.collective_fabric.functions.RayTraceFunctions;
import com.natamus.collective_fabric.functions.WorldFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3614;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;

public class BlockPosFunctions {
    public static List<class_2338> getBlocksAround(class_2338 pos, boolean down) {
        ArrayList<class_2338> around = new ArrayList<class_2338>();
        around.add(pos.method_10095());
        around.add(pos.method_10078());
        around.add(pos.method_10072());
        around.add(pos.method_10067());
        around.add(pos.method_10084());
        if (down) {
            around.add(pos.method_10074());
        }
        return around;
    }

    public static List<class_2338> getBlocksNextToEachOther(class_1937 world, class_2338 startpos, List<class_2248> possibleblocks) {
        return BlockPosFunctions.getBlocksNextToEachOther(world, startpos, possibleblocks, 50);
    }

    public static List<class_2338> getBlocksNextToEachOther(class_1937 world, class_2338 startpos, List<class_2248> possibleblocks, int maxDistance) {
        ArrayList<class_2338> checkedblocks = new ArrayList<class_2338>();
        ArrayList<class_2338> theblocksaround = new ArrayList<class_2338>();
        if (possibleblocks.contains(world.method_8320(startpos).method_26204())) {
            theblocksaround.add(startpos);
            checkedblocks.add(startpos);
        }
        BlockPosFunctions.recursiveGetNextBlocks(world, startpos, startpos, possibleblocks, theblocksaround, checkedblocks, maxDistance);
        return theblocksaround;
    }

    private static void recursiveGetNextBlocks(class_1937 world, class_2338 startpos, class_2338 pos, List<class_2248> possibleblocks, List<class_2338> theblocksaround, List<class_2338> checkedblocks, int maxDistance) {
        List<class_2338> possibleblocksaround = BlockPosFunctions.getBlocksAround(pos, true);
        for (class_2338 pba : possibleblocksaround) {
            if (checkedblocks.contains(pba)) continue;
            checkedblocks.add(pba);
            if (!possibleblocks.contains(world.method_8320(pba).method_26204()) || theblocksaround.contains(pba)) continue;
            theblocksaround.add(pba);
            if (!BlockPosFunctions.withinDistance(startpos, pba, maxDistance).booleanValue()) continue;
            BlockPosFunctions.recursiveGetNextBlocks(world, startpos, pba, possibleblocks, theblocksaround, checkedblocks, maxDistance);
        }
    }

    public static List<class_2338> getBlocksNextToEachOtherMaterial(class_1937 world, class_2338 startpos, List<class_3614> possiblematerials) {
        return BlockPosFunctions.getBlocksNextToEachOtherMaterial(world, startpos, possiblematerials, 50);
    }

    public static List<class_2338> getBlocksNextToEachOtherMaterial(class_1937 world, class_2338 startpos, List<class_3614> possiblematerials, int maxDistance) {
        ArrayList<class_2338> checkedblocks = new ArrayList<class_2338>();
        ArrayList<class_2338> theblocksaround = new ArrayList<class_2338>();
        if (possiblematerials.contains(world.method_8320(startpos).method_26207())) {
            theblocksaround.add(startpos);
            checkedblocks.add(startpos);
        }
        BlockPosFunctions.recursiveGetNextBlocksMaterial(world, startpos, startpos, possiblematerials, theblocksaround, checkedblocks, maxDistance);
        return theblocksaround;
    }

    private static void recursiveGetNextBlocksMaterial(class_1937 world, class_2338 startpos, class_2338 pos, List<class_3614> possiblematerials, List<class_2338> theblocksaround, List<class_2338> checkedblocks, int maxDistance) {
        List<class_2338> possibleblocksaround = BlockPosFunctions.getBlocksAround(pos, true);
        for (class_2338 pba : possibleblocksaround) {
            if (checkedblocks.contains(pba)) continue;
            checkedblocks.add(pba);
            if (!possiblematerials.contains(world.method_8320(pba).method_26207()) || theblocksaround.contains(pba)) continue;
            theblocksaround.add(pba);
            if (!BlockPosFunctions.withinDistance(startpos, pba, maxDistance).booleanValue()) continue;
            BlockPosFunctions.recursiveGetNextBlocksMaterial(world, startpos, pba, possiblematerials, theblocksaround, checkedblocks, maxDistance);
        }
    }

    public static class_2338 getSurfaceBlockPos(class_3218 serverworld, int x, int z) {
        int height = serverworld.method_31605();
        class_2338 returnpos = new class_2338(x, height - 1, z);
        if (!WorldFunctions.isNether((class_1937)serverworld)) {
            class_2338 pos = new class_2338(x, height, z);
            for (int y = height; y > 0; --y) {
                class_2680 blockstate = serverworld.method_8320(pos);
                class_3614 material = blockstate.method_26207();
                if (blockstate.method_26193((class_1922)serverworld, pos) >= 15 || GlobalVariables.surfacematerials.contains(material)) {
                    returnpos = pos.method_10084().method_10062();
                    break;
                }
                pos = pos.method_10074();
            }
        } else {
            int maxheight = 128;
            class_2338 pos = new class_2338(x, 0, z);
            for (int y = 0; y < maxheight; ++y) {
                class_2680 upstate;
                class_2680 blockstate = serverworld.method_8320(pos);
                if (blockstate.method_26204().equals(class_2246.field_10124) && (upstate = serverworld.method_8320(pos.method_10084())).method_26204().equals(class_2246.field_10124)) {
                    returnpos = pos.method_10062();
                    break;
                }
                pos = pos.method_10084();
            }
        }
        return returnpos;
    }

    public static class_2338 getCenterNearbyVillage(class_3218 serverworld) {
        return BlockPosFunctions.getNearbyVillage(serverworld, new class_2338(0, 0, 0));
    }

    public static class_2338 getNearbyVillage(class_3218 serverworld, class_2338 nearpos) {
        if (!WorldFunctions.isOverworld((class_1937)serverworld)) {
            return null;
        }
        class_2378 registry = serverworld.method_30349().method_30530(class_2378.field_25915);
        ArrayList<class_2960> villagerls = new ArrayList<class_2960>();
        for (class_2960 rl : registry.method_10235()) {
            if (!rl.toString().contains("village_")) continue;
            villagerls.add(rl);
        }
        class_2338 closestvillage = null;
        for (int radius : Arrays.asList(200, 500, 1000)) {
            for (class_2960 rl : villagerls) {
                class_6880 structure;
                class_6885.class_6886 holderset;
                class_2338 villagepos;
                class_5321 villagekey;
                Optional optional_s;
                Optional optional_vk = registry.method_29113((Object)((class_5312)registry.method_10223(rl)));
                if (!optional_vk.isPresent() || !(optional_s = registry.method_40264(villagekey = (class_5321)optional_vk.get())).isPresent() || (villagepos = BlockPosFunctions.getNearbyStructure(serverworld, holderset = class_6885.method_40246((class_6880[])new class_6880[]{structure = (class_6880)optional_s.get()}), nearpos, radius)) == null || closestvillage != null && nearpos.method_19455((class_2382)villagepos) >= nearpos.method_19455((class_2382)closestvillage)) continue;
                closestvillage = villagepos.method_10062();
            }
            if (closestvillage == null) continue;
            break;
        }
        return closestvillage;
    }

    public static class_2338 getCenterNearbyStructure(class_3218 serverworld, class_6885<class_5312<?, ?>> structure) {
        return BlockPosFunctions.getNearbyStructure(serverworld, structure, new class_2338(0, 0, 0));
    }

    public static class_2338 getNearbyStructure(class_3218 serverworld, class_6885<class_5312<?, ?>> structure, class_2338 nearpos) {
        return BlockPosFunctions.getNearbyStructure(serverworld, structure, nearpos, 9999);
    }

    public static class_2338 getNearbyStructure(class_3218 serverworld, class_6885<class_5312<?, ?>> structure, class_2338 nearpos, int radius) {
        Pair pair = serverworld.method_14178().method_12129().method_12103(serverworld, structure, nearpos, radius, false);
        if (pair == null) {
            return null;
        }
        class_2338 villagepos = (class_2338)pair.getFirst();
        if (villagepos == null) {
            return null;
        }
        class_2338 spawnpos = null;
        for (int y = serverworld.method_31605() - 1; y > 0; --y) {
            class_2338 checkpos = new class_2338(villagepos.method_10263(), y, villagepos.method_10260());
            if (serverworld.method_8320(checkpos).method_26204().equals(class_2246.field_10124)) continue;
            spawnpos = checkpos.method_10084().method_10062();
            break;
        }
        return spawnpos;
    }

    public static class_2338 getCenterBiome(class_3218 serverworld, Predicate<class_6880<class_1959>> biome) {
        class_2338 centerpos = new class_2338(0, 0, 0);
        class_2338 biomepos = (class_2338)serverworld.method_24500(biome, centerpos, 999999, 0).getFirst();
        if (biomepos == null) {
            return null;
        }
        class_2338 spawnpos = null;
        for (int y = serverworld.method_31605() - 1; y > 0; --y) {
            class_2338 checkpos = new class_2338(biomepos.method_10263(), y, biomepos.method_10260());
            if (serverworld.method_8320(checkpos).method_26204().equals(class_2246.field_10124)) continue;
            spawnpos = checkpos.method_10084().method_10062();
            break;
        }
        return spawnpos;
    }

    public static class_2338 getBlockPlayerIsLookingAt(class_1937 world, class_1657 player, boolean stopOnLiquid) {
        class_239 raytraceresult = RayTraceFunctions.rayTrace(world, player, stopOnLiquid);
        double posX = raytraceresult.method_17784().field_1352;
        double posY = Math.floor(raytraceresult.method_17784().field_1351);
        double posZ = raytraceresult.method_17784().field_1350;
        return new class_2338(posX, posY, posZ);
    }

    public static Boolean isOnSurface(class_1937 world, class_2338 pos) {
        return world.method_8311(pos);
    }

    public static Boolean isOnSurface(class_1937 world, class_243 vecpos) {
        return BlockPosFunctions.isOnSurface(world, new class_2338(vecpos.field_1352, vecpos.field_1351, vecpos.field_1350));
    }

    public static Boolean withinDistance(class_2338 start, class_2338 end, int distance) {
        return BlockPosFunctions.withinDistance(start, end, (double)distance);
    }

    public static Boolean withinDistance(class_2338 start, class_2338 end, double distance) {
        return start.method_19771((class_2382)end, distance);
    }

    public static class_2338 getBlockPosFromHitResult(class_239 hitresult) {
        class_243 vec = hitresult.method_17784();
        return new class_2338(vec.field_1352, vec.field_1351, vec.field_1350);
    }
}

