/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.EntityBobbitWorm;
import dev.itsmeow.betteranimalsplus.common.entity.ai.EfficientMoveTowardsTargetGoal;
import dev.itsmeow.betteranimalsplus.common.entity.ai.HungerNearestAttackableTargetGoal;
import dev.itsmeow.betteranimalsplus.common.entity.ai.PeacefulNearestAttackableTargetGoal;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntitySharkBase;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobPathing;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IVariantTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.util.OceanBiomeHelper;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1378;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public class EntityShark
extends EntitySharkBase {
    private float lastAttack = 0.0f;
    private float lastGrab = 0.0f;
    private float lastTickHealth = 0.0f;
    public float lastBodyRotation = 0.0f;

    public EntityShark(class_1299<? extends EntityShark> entityType, class_1937 worldIn) {
        super((class_1299<? extends EntitySharkBase>)entityType, worldIn);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new EfficientMoveTowardsTargetGoal((class_1314)this, 1.0, true));
        this.field_6201.method_6277(1, (class_1352)new class_1361((class_1308)this, class_1309.class, 15.0f));
        this.field_6201.method_6277(1, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1378((class_1314)this, 1.0, 1));
        this.field_6185.method_6277(1, new HungerNearestAttackableTargetGoal<class_1309, EntityShark>(this, class_1309.class, 5, false, false, e -> !(e instanceof EntitySharkBase) && !(e instanceof EntityBobbitWorm) && !(e instanceof class_1657)));
        this.field_6185.method_6277(2, new PeacefulNearestAttackableTargetGoal<class_1657>((class_1308)this, class_1657.class, 5, false, false, e -> this.shouldAttackForHealth(e.method_6032())));
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (super.method_5643(source, amount)) {
            class_1657 player;
            if (source.method_5526() instanceof class_1657 && !this.isPeaceful() && !(player = (class_1657)source.method_5526()).method_7337() && !player.method_5767()) {
                this.method_5980((class_1309)player);
            }
            return true;
        }
        return false;
    }

    @Override
    public IVariantTypes<EntityWaterMobPathing> setType(IVariant variant) {
        super.setType(variant);
        this.updateAttributes(this.getVariantNameOrEmpty());
        return this;
    }

    @Override
    public IVariantTypes<EntityWaterMobPathing> setType(String variantKey) {
        super.setType(variantKey);
        this.updateAttributes(this.getVariantNameOrEmpty());
        return this;
    }

    private void updateAttributes(String name) {
        if ("hammerhead".equals(name)) {
            this.method_5996(class_5134.field_23716).method_6192(45.0);
            this.method_5996(class_5134.field_23721).method_6192(9.0);
        } else if ("mako".equals(name)) {
            this.method_5996(class_5134.field_23719).method_6192(3.0);
        } else if ("great_white".equals(name)) {
            this.method_5996(class_5134.field_23716).method_6192(60.0);
            this.method_5996(class_5134.field_23721).method_6192(12.0);
        } else {
            this.method_5996(class_5134.field_23716).method_6192(30.0);
            this.method_5996(class_5134.field_23721).method_6192(6.0);
            this.method_5996(class_5134.field_23719).method_6192(1.5);
        }
        this.method_6033(this.method_6063());
    }

    public boolean shouldAttackForHealth(float health) {
        switch (this.getVariantNameOrEmpty()) {
            case "blue": {
                return health <= 8.0f;
            }
            case "bull": {
                return health <= 13.0f;
            }
            case "tiger": {
                return health <= 10.0f;
            }
            case "whitetip": {
                return health <= 16.0f;
            }
            case "greenland": {
                return health <= 8.0f;
            }
            case "hammerhead": {
                return health <= 8.0f;
            }
            case "goblin": {
                return health <= 8.0f;
            }
            case "mako": {
                return health <= 13.0f;
            }
            case "great_white": {
                return health <= 13.0f;
            }
        }
        return false;
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_5968() != null && !this.method_5968().method_5805()) {
            this.method_5980(null);
        }
        if (!this.field_6002.field_9236 && this.method_5968() != null && this.method_5968().method_5805() && this.method_5805() && !this.isPeaceful()) {
            float grabDelay;
            boolean isBoat = this.method_5968() instanceof class_1657 && this.method_5968().method_5854() != null && this.method_5968().method_5854() instanceof class_1690;
            float f = grabDelay = isBoat ? 20.0f : 60.0f;
            if (this.method_5685().contains(this.method_5968())) {
                float time = 30.0f * ((float)Math.random() + 1.0f);
                if (this.lastAttack + time < (float)this.field_6012) {
                    this.method_6121((class_1297)this.method_5968());
                }
            } else if (this.lastGrab + grabDelay < (float)this.field_6012 && this.method_5858((class_1297)this.method_5968()) < 5.0) {
                if (isBoat) {
                    class_1690 boat = (class_1690)this.method_5968().method_5854();
                    boat.method_5643(class_1282.method_5511((class_1309)this), 3.0f);
                } else if (!this.method_5968().method_5655() && (double)this.method_5968().method_17681() < 2.5 && (double)this.method_5968().method_17682() < 2.5) {
                    if (this.method_5968() instanceof class_1308) {
                        class_1308 el = (class_1308)this.method_5968();
                        el.method_5980(null);
                        el.method_6015(null);
                        el.method_5942().method_6340();
                        el.method_5977(true);
                    }
                    this.method_5968().method_5873((class_1297)this, false);
                } else if (!this.method_5968().method_5655()) {
                    this.method_6121((class_1297)this.method_5968());
                }
                this.lastGrab = this.field_6012;
            }
            if (this.lastTickHealth - 4.0f > this.method_6032()) {
                this.method_5968().method_5848();
                if (this.method_5968() instanceof class_1308) {
                    class_1308 el = (class_1308)this.method_5968();
                    el.method_5977(false);
                }
            }
        }
        this.lastTickHealth = this.method_6032();
    }

    public boolean method_6121(class_1297 entityIn) {
        if (super.method_6121(entityIn)) {
            this.lastAttack = this.field_6012;
            return true;
        }
        return false;
    }

    @Override
    public EntityTypeContainer<EntityShark> getContainer() {
        return ModEntities.SHARK;
    }

    @Override
    public String[] getTypesFor(class_5321<class_1959> biomeKey, class_1959 biome, Set<BiomeTypes.Type> types, class_3730 reason) {
        ArrayList<String> list = new ArrayList<String>();
        OceanBiomeHelper.Wrapper b = new OceanBiomeHelper.Wrapper(biomeKey);
        if (b.isColdOrFrozen()) {
            list.add("greenland");
        } else {
            list.add("bull");
            list.add("blue");
            list.add("whitetip");
            list.add("tiger");
        }
        if (!b.isFrozen()) {
            list.add("great_white");
        }
        if (b.isDeep()) {
            list.add("goblin");
            if (!b.isFrozen()) {
                list.add("mako");
            }
        }
        if (b.isWarm()) {
            list.add("mako");
            list.add("hammerhead");
        }
        return list.toArray(new String[0]);
    }

    @Override
    public IVariant getRandomVariantForBiome(class_1936 world, class_3730 reason) {
        Optional<IVariant> variant;
        int i;
        class_6880 biome = world.method_23753(this.getImplementation().method_24515());
        Optional biomeKey = biome.method_40230();
        biomeKey.orElseThrow(() -> new RuntimeException("Biome provided to selective type generation has no ID found."));
        String[] validTypes = this.getTypesFor((class_5321<class_1959>)((class_5321)biomeKey.get()), (class_1959)biome.comp_349(), BiomeTypes.getTypes((class_5321<class_1959>)((class_5321)biomeKey.get())), reason);
        String varStr = validTypes[this.getImplementation().method_6051().nextInt(validTypes.length)];
        for (i = 0; i < 2; ++i) {
            if (!"great_white".equals(varStr) && !"goblin".equals(varStr)) continue;
            varStr = validTypes[this.getImplementation().method_6051().nextInt(validTypes.length)];
        }
        if (world instanceof class_1937 && ((class_1937)world).method_8530() && validTypes.length > 1 && "goblin".equals(varStr)) {
            for (i = 0; i < validTypes.length && "goblin".equals(varStr); ++i) {
                varStr = validTypes[i];
            }
        }
        if (!(variant = this.getContainer().getVariantForName(varStr)).isPresent() || !varStr.equals(variant.get().getName())) {
            throw new RuntimeException("Received invalid variant \"" + varStr + "\" from selective type on entity " + this.getContainer().getEntityName());
        }
        return variant.get();
    }
}

