/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.network;

import com.google.common.base.Charsets;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.itsmeow.betteranimalsplus.common.entity.EntityCoyote;
import dev.itsmeow.betteranimalsplus.common.entity.util.EntityTypeContainerBAPTameable;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2540;

public class ClientConfigurationPacket {
    public boolean coyotesHostileDaytime;
    public Map<String, String[]> tameItems;

    public ClientConfigurationPacket(boolean coyoteHostile, Map<String, String[]> tameItems) {
        this.coyotesHostileDaytime = coyoteHostile;
        this.tameItems = tameItems;
    }

    public static void encode(ClientConfigurationPacket pkt, class_2540 buf) {
        buf.writeBoolean(ModEntities.COYOTE.getCustomConfiguration().getBoolean("hostile_during_daytime"));
        buf.writeInt(pkt.tameItems.size());
        for (String key : pkt.tameItems.keySet()) {
            buf.writeInt(key.length());
            buf.writeCharSequence((CharSequence)key, Charsets.UTF_8);
            String[] items = pkt.tameItems.get(key);
            if (items != null) {
                buf.writeInt(items.length);
                for (String value : items) {
                    buf.writeInt(value.length());
                    buf.writeCharSequence((CharSequence)value, Charsets.UTF_8);
                }
                continue;
            }
            buf.writeInt(0);
        }
    }

    public static ClientConfigurationPacket decode(class_2540 buf) {
        boolean coyoteHostile = buf.readBoolean();
        HashMap<String, String[]> tames = new HashMap<String, String[]>();
        int mapSize = buf.readInt();
        for (int l = 0; l < mapSize; ++l) {
            int keyL = buf.readInt();
            String key = String.valueOf(buf.readCharSequence(keyL, Charsets.UTF_8));
            int tameItemSize = buf.readInt();
            String[] value = new String[tameItemSize];
            for (int i = 0; i < tameItemSize; ++i) {
                int valueL = buf.readInt();
                value[i] = String.valueOf(buf.readCharSequence(valueL, Charsets.UTF_8));
            }
            tames.put(key, value);
        }
        return new ClientConfigurationPacket(coyoteHostile, tames);
    }

    public static class Handler {
        public static void handle(ClientConfigurationPacket msg, Supplier<NetworkManager.PacketContext> ctx) {
            if (ctx.get().getEnvironment() == Env.CLIENT) {
                ctx.get().queue(() -> {
                    EntityCoyote.client_hostile_override = msg.coyotesHostileDaytime;
                    for (String key : msg.tameItems.keySet()) {
                        String[] items = msg.tameItems.get(key);
                        EntityTypeContainer container = ModEntities.H.getEntityTypeContainer(key);
                        if (!(container instanceof EntityTypeContainerBAPTameable)) continue;
                        EntityTypeContainerBAPTameable cont2 = (EntityTypeContainerBAPTameable)container;
                        cont2.setTameItems(items);
                    }
                });
            }
        }
    }
}

