/*
 * Decompiled with CFR 0.152.
 */
package froztigaming.fantasyorigins.client;

import froztigaming.fantasyorigins.client.render.entity.SpearEntityRenderer;
import froztigaming.fantasyorigins.client.render.entity.TritonTridentEntityRenderer;
import froztigaming.fantasyorigins.client.render.entity.model.SpearEntityModel;
import froztigaming.fantasyorigins.client.render.item.SpearItemRenderer;
import froztigaming.fantasyorigins.client.render.item.TritonTridentItemRenderer;
import froztigaming.fantasyorigins.init.EntityInit;
import froztigaming.fantasyorigins.init.ItemInit;
import froztigaming.fantasyorigins.items.SpearItem;
import froztigaming.fantasyorigins.items.TravelerStone;
import froztigaming.fantasyorigins.items.TritonTridentItem;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.object.builder.v1.client.model.FabricModelPredicateProviderRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1091;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_5601;
import net.minecraft.class_5602;

@Environment(value=EnvType.CLIENT)
public class FantasyOriginsClient
implements ClientModInitializer {
    public static final class_5601 SPEAR = new class_5601(new class_2960("fantasyorigins", "spear"), "spear");
    public static final class_5601 GOBLIN_LAYER = new class_5601(new class_2960("fantasyorigins", "goblin"), "goblin");
    public static final class_5601 GOBLIN_ARMOR_OUTER = new class_5601(new class_2960("fantasyorigins", "goblin_armor_outer"), "guard_armor_outer");
    public static final class_5601 GOBLIN_ARMOR_INNER = new class_5601(new class_2960("fantasyorigins", "goblin_armor_inner"), "guard_armor_inner");

    public void onInitializeClient() {
        EntityInit.initClient();
        this.initialiseTritonTrident();
        this.initialiseSpear();
        FabricModelPredicateProviderRegistry.register((class_1792)ItemInit.TRAVELER_STONE, (class_2960)new class_2960("charged"), (itemStack, world, entity, seed) -> entity != null && TravelerStone.isDimension() ? 1.0f : 0.0f);
        FabricModelPredicateProviderRegistry.register((class_1792)ItemInit.ELVEN_BOW, (class_2960)new class_2960("pull"), (itemStack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.method_6030() != itemStack ? 0.0f : (float)(itemStack.method_7935() - entity.method_6014()) / 20.0f;
        });
        FabricModelPredicateProviderRegistry.register((class_1792)ItemInit.ELVEN_BOW, (class_2960)new class_2960("pulling"), (itemStack, clientWorld, livingEntity, seed) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f;
        });
    }

    public void initialiseTritonTrident() {
        TritonTridentItem item = ItemInit.TRITON_TRIDENT;
        class_2960 tridentId = class_2378.field_11142.method_10221((Object)item);
        class_2960 texture = new class_2960(tridentId.method_12836(), "textures/entity/" + tridentId.method_12832() + ".png");
        class_5601 modelLayer = class_5602.field_27668;
        TritonTridentItemRenderer tridentItemRenderer = new TritonTridentItemRenderer(tridentId, texture, modelLayer);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)tridentItemRenderer);
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)item, (BuiltinItemRendererRegistry.DynamicItemRenderer)tridentItemRenderer);
        EntityRendererRegistry.register(item.getEntityType(), ctx -> new TritonTridentEntityRenderer(ctx, texture, modelLayer));
        FabricModelPredicateProviderRegistry.register((class_1792)item, (class_2960)new class_2960("throwing"), (stack, world, entity, seed) -> entity != null && entity.method_6115() && entity.method_6030() == stack ? 1.0f : 0.0f);
        ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> out.accept(new class_1091(tridentId + "_in_inventory", "inventory")));
    }

    public void initialiseSpear() {
        EntityModelLayerRegistry.registerModelLayer((class_5601)SPEAR, SpearEntityModel::getTexturedModelData);
        SpearItem item = ItemInit.SPEAR;
        class_2960 spearId = class_2378.field_11142.method_10221((Object)item);
        class_2960 texture = new class_2960(spearId.method_12836(), "textures/entity/" + spearId.method_12832() + ".png");
        class_5601 modelLayer = SPEAR;
        SpearItemRenderer spearItemRenderer = new SpearItemRenderer(spearId, texture, modelLayer);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)spearItemRenderer);
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)item, (BuiltinItemRendererRegistry.DynamicItemRenderer)spearItemRenderer);
        EntityRendererRegistry.register(item.getEntityType(), ctx -> new SpearEntityRenderer(ctx, texture, modelLayer));
        FabricModelPredicateProviderRegistry.register((class_1792)item, (class_2960)new class_2960("throwing"), (stack, world, entity, seed) -> entity != null && entity.method_6115() && entity.method_6030() == stack ? 1.0f : 0.0f);
        ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> out.accept(new class_1091(spearId + "_in_inventory", "inventory")));
    }
}

