/*
 * Decompiled with CFR 0.152.
 */
package carpetfixes;

import carpet.CarpetServer;
import carpet.settings.Rule;
import carpetfixes.helpers.UpdateScheduler;
import carpetfixes.settings.Conditions;
import carpetfixes.settings.Validators;
import carpetfixes.settings.VersionConditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class CFSettings {
    public static boolean scheduleWorldBorderReset = false;
    public static HashMap<class_1937, UpdateScheduler> updateScheduler = new HashMap();
    public static final ThreadLocal<Set<class_2338>> LAST_DIRT = ThreadLocal.withInitial(HashSet::new);
    public static final Predicate<class_2680> IS_REPLACEABLE = state -> state.method_26207().method_15800();
    public static final ThreadLocal<Boolean> IS_TICK_SAVE = ThreadLocal.withInitial(() -> false);
    @Rule(desc="Fixes End Crystals not exploding when damaged from explosions. End Crystal chaining", extra={"[MC-118429](https://bugs.mojang.com/browse/MC-118429)"}, category={"bugfix"})
    public static boolean crystalExplodeOnExplodedFix = false;
    @Rule(desc="Fixes sponges not giving block updates when absorbing water", extra={"[MC-220636](https://bugs.mojang.com/browse/MC-220636)"}, category={"bugfix"})
    public static boolean spongeUpdateFix = false;
    @Rule(desc="Fixes hoppers not giving block updates when placed while powered", extra={"invisibleHopperFix is automatically enabled when used", "[Youtube Video](https://www.youtube.com/watch?v=QVOONJ1OY44)"}, category={"bugfix", "recommended"})
    public static boolean hopperUpdateFix = false;
    @Rule(desc="Fixes observers not giving block updates when retracted and immediately repowered", extra={"[MC-136566](https://bugs.mojang.com/browse/MC-136566)"}, category={"bugfix"})
    public static boolean observerUpdateFix = false;
    @Rule(desc="Fixes target blocks not giving shape updates when retracted and immediately repowered", category={"bugfix"})
    public static boolean targetBlockUpdateFix = false;
    @Rule(desc="Fixes StringTag Exploits due to StringTag writeUTF() not respecting readUTF() Limits causing crashes internally", extra={"This was the cause of ChunkRegen, and the book dupe. Both patched, although StringTag is still broken", "[MC-134892](https://bugs.mojang.com/browse/MC-134892)"}, category={"bugfix", "crashfix", "recommended", "vanilla", "dupe"})
    public static boolean stringTagExploitFix = false;
    @Rule(desc="Fixes incorrect block collision checks for players", extra={"This bug allows you to teleport to the end at your overworld position, amongst many other problems", "[MC-123364](https://bugs.mojang.com/browse/MC-123364)"}, category={"bugfix"})
    public static boolean blockCollisionCheckFix = false;
    @Rule(desc="Fixes issues where block updates are directional. Changes block update order from XYZ to XZY", extra={"Warning! This changes how block updates are done and could effect some contraptions", "[MC-161402](https://bugs.mojang.com/browse/MC-161402)"}, category={"bugfix"})
    public static boolean blockUpdateOrderFix = false;
    @Rule(desc="Changes block updates that go 2 blocks out, so they have the same block update order", extra={"Changes extended block update order from YZX to XZY", "Warning! This changes how some block updates are done and could effect some contraptions"}, category={"bugfix"})
    public static boolean extendedBlockUpdateOrderFix = false;
    @Rule(desc="Fixes the issue where comparators don't always get updated correctly", extra={"[MC-120986](https://bugs.mojang.com/browse/MC-120986)"}, category={"bugfix"})
    public static boolean comparatorUpdateFix = false;
    @Rule(desc="Prevents update suppression from working. When the stack is reached, the following updates are moved to the next tick", extra={"This does not prevent stack overflow exploits, it simple makes sure to update block after"}, category={"bugfix", "crashfix", "recommended", "dupe"})
    public static boolean updateSuppressionFix = false;
    @Rule(desc="Fixes some entities not bouncing on slime blocks and getting stuck", extra={"[MC-216985](https://bugs.mojang.com/browse/MC-216985)"}, category={"bugfix", "experimental"})
    public static boolean incorrectBounceLogicFix = false;
    @Rule(desc="Fixes some entities getting stuck in bubble columns", extra={"[MC-207866](https://bugs.mojang.com/browse/MC-207866)"}, category={"bugfix", "experimental"})
    public static boolean incorrectBubbleColumnLogicFix = false;
    @Rule(desc="Fixes movement slowdown being calculated based on last block in search. Uses the slowest value instead", extra={"[MC-202654](https://bugs.mojang.com/browse/MC-202654)"}, category={"bugfix"})
    public static boolean directionalBlockSlowdownFix = false;
    @Rule(desc="Fixes cats sometimes breaking there leads after giving a gift", extra={"[MC-202607](https://bugs.mojang.com/browse/MC-202607)"}, category={"bugfix", "recommended"})
    public static boolean catsBreakLeadsDuringGiftFix = false;
    @Rule(desc="Fixes Leashed pets teleporting to the player when reloaded, breaking there leads", extra={"[MC-173303](https://bugs.mojang.com/browse/MC-173303)"}, category={"bugfix", "recommended"})
    public static boolean petsBreakLeadsDuringReloadFix = false;
    @Rule(desc="Fixes enderman not updating the block they place correctly", extra={"Only applies if you use datapacks or mods. E.x. Enderman placing a wither skull will not spawn a wither", "[MC-183054](https://bugs.mojang.com/browse/MC-183054)"}, category={"bugfix", "experimental"})
    public static boolean endermanDontUpdateOnPlaceFix = false;
    @Rule(desc="Fixes enderman constantly trying to teleport when in a minecart under daylight", extra={"[MC-227008](https://bugs.mojang.com/browse/MC-227008)"}, category={"bugfix", "vanilla"})
    public static boolean endermanUselessMinecartTeleportingFix = false;
    @Rule(desc="Fixes rails updating other rails before checking if they are in a valid location", extra={"[MC-174864](https://bugs.mojang.com/browse/MC-174864)"}, category={"bugfix"})
    public static boolean railInvalidUpdateOnPushFix = false;
    @Rule(desc="Fixes rails not updating other rails on being moved, allowing for invalid states", extra={"Prevents redstone budding from working", "[MC-123311](https://bugs.mojang.com/browse/MC-123311)"}, category={"bugfix"})
    public static boolean railMissingUpdateOnPushFix = false;
    @Rule(desc="Fixes rails not updating other rails after being moved", extra={"[MC-96224](https://bugs.mojang.com/browse/MC-96224)"}, category={"bugfix"})
    public static boolean railMissingUpdateAfterPushFix = false;
    @Rule(desc="Fixes the void rings in the end, which is a floating point error", extra={"[MC-159283](https://bugs.mojang.com/browse/MC-159283)"}, category={"bugfix", "optimization"})
    public static boolean endVoidRingsFix = false;
    @Rule(desc="Fixes getting kicked for flying too long when jumping and riding an entity", extra={"Fixes [MC-98727](https://bugs.mojang.com/browse/MC-98727)"}, category={"bugfix", "recommended", "vanilla"}, condition={VersionConditions.LT_22w03a.class})
    public static boolean mountingFlyingTooLongFix = false;
    @Rule(desc="Fixes fall damage being delayed by sleeping, fall damage will be removed instead", extra={"[MC-19830](https://bugs.mojang.com/browse/MC-19830)"}, category={"bugfix", "recommended"})
    public static boolean sleepingDelaysFallDamageFix = false;
    @Rule(desc="Fixes TNT Entity not being able to go through nether portals", extra={"[MC-8983](https://bugs.mojang.com/browse/MC-8983)"}, category={"bugfix"})
    public static boolean tntCantUseNetherPortalsFix = false;
    @Rule(desc="Fixes Falling Blocks not being able to go through nether portals", extra={"[MC-9644](https://bugs.mojang.com/browse/MC-9644)"}, category={"bugfix"})
    public static boolean fallingBlocksCantUseNetherPortalsFix = false;
    @Rule(desc="Fixes Spawn Chunks not ticking entities and block entities if no player online", extra={"[MC-59134](https://bugs.mojang.com/browse/MC-59134)"}, category={"bugfix", "vanilla"})
    public static boolean spawnChunkEntitiesUnloadingFix = false;
    @Rule(desc="Fixes Named Blocks not stacking due to useless RepairCost tag", extra={"[MC-197473](https://bugs.mojang.com/browse/MC-197473)"}, category={"bugfix", "recommended"})
    public static boolean repairCostItemNotStackingFix = false;
    @Rule(desc="Fixes enchantments not working on tridents if thrown by a drowned", extra={"[MC-127321](https://bugs.mojang.com/browse/MC-127321)"}, category={"bugfix"})
    public static boolean drownedEnchantedTridentsFix = false;
    @Rule(desc="Fixes multiple bugs related to effects happening only when player center in block instead of hitbox", extra={"[MC-1133](https://bugs.mojang.com/browse/MC-1133)"}, category={"bugfix"})
    public static boolean playerBlockCollisionUsingCenterFix = false;
    @Rule(desc="Fixes incorrect cat types spawning inside swamp huts", extra={"[MC-147659](https://bugs.mojang.com/browse/MC-147659)"}, category={"bugfix", "recommended", "wontfix", "vanilla"})
    public static boolean witchHutsSpawnIncorrectCatFix = false;
    @Rule(desc="Fixes incorrect sea level height being used when datapacks change the sea height", extra={"[MC-226687](https://bugs.mojang.com/browse/MC-226687)"}, category={"bugfix"})
    public static boolean hardcodedSeaLevelFix = false;
    @Rule(desc="Fixes being able to fish outside of water", extra={"[MC-175544](https://bugs.mojang.com/browse/MC-175544)"}, category={"bugfix", "recommended"}, condition={VersionConditions.GT_22w05a.class})
    public static boolean fishingOutsideWaterFix = false;
    @Rule(desc="Fixes experience orbs treating flowing lava as a full block", extra={"[MC-226961](https://bugs.mojang.com/browse/MC-226961)"}, category={"bugfix", "recommended"}, condition={VersionConditions.GT_22w05a.class})
    public static boolean xpOrbCollisionFix = false;
    @Rule(desc="Fixes multiple different mob conversions, not transferring all the correct nbt", extra={"[MC-88967](https://bugs.mojang.com/browse/MC-88967)"}, category={"bugfix", "experimental"})
    public static boolean conversionFix = false;
    @Rule(desc="Fixes Explosions being able to destroy item frames in water", extra={"[MC-3697](https://bugs.mojang.com/browse/MC-3697)"}, category={"bugfix"})
    public static boolean explosionBreaksItemFrameInWaterFix = false;
    @Rule(desc="Fixes Moving Blocks from destroying path blocks", extra={"[MC-161026](https://bugs.mojang.com/browse/MC-161026)"}, category={"bugfix"})
    public static boolean movingBlocksDestroyPathFix = false;
    @Rule(desc="Fixes Withers and Golems not spawning due to replaceable blocks being in the way", extra={"[MC-60792](https://bugs.mojang.com/browse/MC-60792)"}, validate={Validators.WitherGolemSpawningFixValidator.class}, category={"bugfix", "intended", "recommended"})
    public static boolean witherGolemSpawningFix = false;
    @Rule(desc="Fixes Breaking blocks that should not be able to be broken using headless pistons", extra={"Illegal blocks are any blocks that have a hardness value of -1.0F", "[MC-188220](https://bugs.mojang.com/browse/MC-188220)"}, category={"bugfix", "recommended"})
    public static boolean illegalBreakingFix = false;
    @Rule(desc="Fixes being able to make and use Headless Pistons", extra={"[MC-27056](https://bugs.mojang.com/browse/MC-27056)"}, category={"bugfix", "recommended"})
    public static boolean headlessPistonFix = false;
    @Rule(desc="Fixes the thunder timer being reset whenever players sleep", category={"bugfix"})
    public static boolean sleepingResetsThunderFix = false;
    @Rule(desc="Fixes incorrect explosion exposure calculations", extra={"[MC-232355](https://bugs.mojang.com/browse/MC-232355)"}, category={"bugfix", "recommended", "vanilla"})
    public static boolean incorrectExplosionExposureFix = false;
    @Rule(desc="Fixes some redstone components sending duplicated block updates", extra={"[MC-231071](https://bugs.mojang.com/browse/MC-231071)"}, category={"bugfix", "experimental", "recommended", "vanilla", "optimization"})
    public static boolean duplicateBlockUpdatesFix = false;
    @Rule(desc="Fixes some blocks not popping off when a trapdoor opens", extra={"[MC-157300](https://bugs.mojang.com/browse/MC-157300)"}, category={"bugfix"})
    public static boolean trapdoorMissingUpdateFix = false;
    @Rule(desc="Fixes the detector rail giving useless comparator updates on entity collision", category={"bugfix"})
    public static boolean uselessDetectorRailUpdateFix = false;
    @Rule(desc="Fixes bees getting stuck in the void due to gravity being disabled", extra={"[MC-167279](https://bugs.mojang.com/browse/MC-167279)"}, category={"bugfix", "recommended"})
    public static boolean beeStuckInVoidFix = false;
    @Rule(desc="Fixes being able to make permanent invulnerable end crystals", category={"bugfix", "experimental"})
    public static boolean invulnerableEndCrystalFix = false;
    @Rule(desc="Fixes signal strength being inaccurate and skipping odd signal strengths due to precision loss with distance", extra={"[MC-218222](https://bugs.mojang.com/browse/MC-218222)"}, category={"bugfix", "experimental"})
    public static boolean sculkSensorPrecisionLossFix = false;
    @Rule(desc="Fixes creepers resetting there fuse duration when travelling through a nether portal after being ignited by flint & steel", extra={"[MC-234754](https://bugs.mojang.com/browse/MC-234754)"}, category={"bugfix"})
    public static boolean creeperPortalFuseResetsFix = false;
    @Rule(desc="Fixes soul speed enchantment from damaging boots when riding a vehicle", extra={"[MC-200991](https://bugs.mojang.com/browse/MC-200991)"}, category={"bugfix", "recommended"})
    public static boolean soulSpeedIncorrectDamageFix = false;
    @Rule(desc="Fixes placing end crystals too early not re-summoning the Ender Dragon", extra={"[MC-215763](https://bugs.mojang.com/browse/MC-215763)"}, category={"bugfix", "recommended"})
    public static boolean endCrystalPlacingTooEarlyFix = false;
    @Rule(desc="Fixes being able to respawn the ender dragon using only 2 ender crystals instead of the intended 4", extra={"[MC-102774](https://bugs.mojang.com/browse/MC-102774)"}, category={"bugfix"})
    public static boolean respawnDragonWithoutAllEndCrystalsFix = false;
    @Rule(desc="Fixes trees considering the bottom block as a trunk and modifying leaves because of it", category={"bugfix"})
    public static boolean treeTrunkLogicFix = false;
    @Rule(desc="Fixes blocks using updateNeighbors() on blocks next to them, making itself get a block update even though it does not accept block updates", extra={"Some blocks do accept block updates, although we make sure to update them correctly"}, category={"bugfix", "recommended", "vanilla", "optimization"})
    public static boolean uselessSelfBlockUpdateFix = false;
    @Rule(desc="Fixes Tnt Minecarts being able to explode twice, killing their own drops", category={"bugfix", "recommended"})
    public static boolean tntMinecartExplodesTwiceFix = false;
    @Rule(desc="Fixes Zombies & Vindicators being able to break any block where a door was", extra={"[MC-95467](https://bugs.mojang.com/browse/MC-95467)"}, category={"bugfix", "recommended"})
    public static boolean breakAnythingDoorGoalFix = false;
    @Rule(desc="Fixes Blackstone Buttons taking longer then other buttons to break", extra={"[MC-199752](https://bugs.mojang.com/browse/MC-199752)"}, category={"bugfix"}, condition={VersionConditions.GT_22w05a.class})
    public static boolean blackstoneButtonBreakSpeedFix = false;
    @Rule(desc="Fixes Transparent blocks placed between bookshelves and enchanting tables negating bonuses received", extra={"[MC-2474](https://bugs.mojang.com/browse/MC-2474)"}, category={"bugfix", "recommended"})
    public static boolean transparentBlocksNegateEnchantingFix = false;
    @Rule(desc="Fixes chests being accessible outside the world border by placing a chest near it", extra={"We do this by preventing chests from merging with other chests outside of the world border", "[MC-67844](https://bugs.mojang.com/browse/MC-67844)"}, category={"bugfix"})
    public static boolean chestUsablePastWorldBorderFix = false;
    @Rule(desc="Fixes item frames playing a sound when they are read from nbt", extra={"[MC-123450](https://bugs.mojang.com/browse/MC-123450)"}, category={"bugfix", "vanilla"})
    public static boolean itemFramePlaysSoundOnReadFix = false;
    @Rule(desc="Fixes commands not allowing all nbt tags to work correctly", extra={"[MC-112257](https://bugs.mojang.com/browse/MC-112257)"}, category={"bugfix", "vanilla", "recommended", "creative"})
    public static boolean incorrectNbtChecks = false;
    @Rule(desc="Fixes the end portal removing your status effects when going from the overworld to the end", extra={"[MC-6431](https://bugs.mojang.com/browse/MC-6431)"}, category={"bugfix", "recommended"})
    public static boolean endPortalRemovesEffectsFix = false;
    @Rule(desc="Fixes burnt-out redstone torches having inconsistent behavior for turning on again", extra={"[MC-120938](https://bugs.mojang.com/browse/MC-120938)"}, category={"bugfix", "recommended"})
    public static boolean inconsistentRedstoneTorchFix = false;
    @Rule(desc="Fixes gamerule doMobLoot not effecting foxes from dropping their items", extra={"[MC-153010](https://bugs.mojang.com/browse/MC-153010)"}, category={"bugfix"})
    public static boolean foxesDropItemsWithLootOffFix = false;
    @Rule(desc="Fixes fluids being able to instantly flow!", extra={"[MC-215636](https://bugs.mojang.com/browse/MC-215636)"}, category={"bugfix"})
    public static boolean instantFluidFlowingFix = false;
    @Rule(desc="Changes the code to use less copy calls, and instead pass references when possible", category={"bugfix", "recommended", "dupe"})
    public static boolean saferItemTransfers = false;
    @Rule(desc="Fixes the sculk sensor having a directional bias with wool occlusion", extra={"[MC-207289](https://bugs.mojang.com/browse/MC-207289) & [MC-207635](https://bugs.mojang.com/browse/MC-207635)"}, category={"bugfix", "recommended"})
    public static boolean sculkSensorBiasFix = false;
    @Rule(desc="Fixes bees not leaving the hive in the end & nether due to weather conditions", extra={"[MC-168329](https://bugs.mojang.com/browse/MC-168329)"}, category={"bugfix"})
    public static boolean beeNotLeavingHiveFix = false;
    @Rule(desc="Fixes item frames & paintings being able to interact with pressure plates & tripwire hooks, causing them to not de-power", extra={"[MC-82055](https://bugs.mojang.com/browse/MC-82055)"}, category={"bugfix"})
    public static boolean hangingEntityTriggersTrapsFix = false;
    @Rule(desc="Fixes boats breaking and giving fall damage under certain circumstances", extra={"[MC-119369](https://bugs.mojang.com/browse/MC-119369)"}, category={"bugfix"})
    public static boolean boatsTakeFallDamageFix = false;
    @Rule(desc="Fixes boats not being destroyed by fall damage", extra={"[MC-98160](https://bugs.mojang.com/browse/MC-98160)"}, category={"bugfix"})
    public static boolean boatsDontTakeFallDamageFix = false;
    @Rule(desc="Fixes buried treasure always generating in the center of a chunk", extra={"[MC-227443](https://bugs.mojang.com/browse/MC-227443)"}, category={"bugfix"})
    public static boolean buriedTreasureAlwaysCenterFix = false;
    @Rule(desc="Fixes reinforcements only spawning zombies", extra={"[MC-14800](https://bugs.mojang.com/browse/MC-14800)"}, category={"bugfix"})
    public static boolean reinforcementsOnlySpawnZombiesFix = false;
    @Rule(desc="Fixes incorrect fall distance calculations causing fall distance to build up over time with leads", extra={"[MC-14167](https://bugs.mojang.com/browse/MC-14167)"}, category={"bugfix"})
    public static boolean incorrectFallDamageFix = false;
    @Rule(desc="Fixes the void killing loyalty tridents, even though they should come back to the player", extra={"[MC-125755](https://bugs.mojang.com/browse/MC-125755)"}, category={"bugfix", "intended"})
    public static boolean voidKillsLoyaltyTridentsFix = false;
    @Rule(desc="Fixes piercing projectiles lowering there piercing when 'hitting' an enderman", extra={"[MC-145557](https://bugs.mojang.com/browse/MC-145557)"}, category={"bugfix"})
    public static boolean endermanLowerPiercingFix = false;
    @Rule(desc="Fixes placing a button/pressure plate inside of a projectile not activating it", extra={"[MC-209284](https://bugs.mojang.com/browse/MC-209284)"}, category={"bugfix"})
    public static boolean projectileNotDetectedOnPlaceFix = false;
    @Rule(desc="Fixes arrows of harming bypassing Totems of Undying", extra={"[MC-206307](https://bugs.mojang.com/browse/MC-206307)"}, category={"bugfix"})
    public static boolean arrowEffectsBypassTotemsFix = false;
    @Rule(desc="Fixes mobs continuing to convert even if the block is no longer there", extra={"[MC-227250](https://bugs.mojang.com/browse/MC-227250)"}, category={"bugfix"})
    public static boolean mobsConvertingWithoutBlocksFix = false;
    @Rule(desc="Fixes Mobs ignoring 'Owner' when picking up loot", extra={"[MC-120578](https://bugs.mojang.com/browse/MC-120578)"}, category={"bugfix"})
    public static boolean mobsIgnoreOwnerOnPickupFix = false;
    @Rule(desc="Fixes redstone torch/repeater/comparator update order when being broken, causing incorrect update order", extra={"[MC-157644](https://bugs.mojang.com/browse/MC-157644)"}, category={"bugfix"})
    public static boolean redstoneComponentUpdateOrderOnBreakFix = false;
    @Rule(desc="Fixes falling blocks not behaving as expected when being teleported", extra={"[MC-151488](https://bugs.mojang.com/browse/MC-151488)"}, category={"bugfix"}, condition={VersionConditions.LT_22w03a.class})
    public static boolean fallingBlockTeleportingFix = false;
    @Rule(desc="Fixes player velocity on X and Z axis being cancelled separately at low values", extra={"[MC-241951](https://bugs.mojang.com/browse/MC-241951) & [MC-160304](https://bugs.mojang.com/browse/MC-160304)"}, category={"bugfix"})
    public static boolean velocitySeparateAxisCancellingFix = false;
    @Rule(desc="Fixes ArmorStands losing functionality due to 'optimizations'", extra={"The marker tag will still prevent interaction though", "[MC-244956](https://bugs.mojang.com/browse/MC-244956)"}, category={"bugfix"})
    public static boolean armorStandMissingFunctionalityFix = false;
    @Rule(desc="Fixes enderman teleporting when they have the NoAI tag", extra={"[MC-65668](https://bugs.mojang.com/browse/MC-65668)"}, category={"bugfix", "wontfix"})
    public static boolean endermanTeleportWithoutAIFix = false;
    @Rule(desc="Fixes redstone redirection missing updates on redirecting", extra={"[MC-3703](https://bugs.mojang.com/browse/MC-3703)"}, category={"bugfix"})
    public static boolean redstoneRedirectionMissingUpdateFix = false;
    @Rule(desc="Fixes being able to push waterlogged blocks while retaining the waterlogged state using a short pulse", extra={"[MC-130183](https://bugs.mojang.com/browse/MC-130183)"}, category={"bugfix"})
    public static boolean pistonsPushWaterloggedBlocksFix = false;
    @Rule(desc="Fixes tile drops at the world border spawning at the wrong location", extra={"Relates to [MC-4](https://bugs.mojang.com/browse/MC-4)"}, category={"bugfix"})
    public static boolean tileDropsAffectedByFloatingPointFix = false;
    @Rule(desc="Fixes players being able to crack there player seed", extra={"This makes it so random is shared between all entities. Which is a good performance boost", "recommended that you set this on permanently, and restart the server for best results"}, category={"bugfix", "optimization"})
    public static boolean entityRandomCrackingFix = false;
    @Rule(desc="Fixes world border collision rounding to blocks for entity collisions", extra={"[MC-88482](https://bugs.mojang.com/browse/MC-88482) & [MC-247422](https://bugs.mojang.com/browse/MC-247422)"}, validate={Validators.WorldBorderCollisionRoundingFixValidator.class}, category={"bugfix", "intended"})
    public static boolean worldBorderCollisionRoundingFix = false;
    @Rule(desc="Fixes comparator signal ending prematurely due to offset block updates", extra={"[MC-247420](https://bugs.mojang.com/browse/MC-247420)"}, category={"bugfix"})
    public static boolean detectorRailOffsetUpdateFix = false;
    @Rule(desc="Fixes being able to place blocks outside of the world border", extra={"[MC-63578](https://bugs.mojang.com/browse/MC-63578) & [MC-223613](https://bugs.mojang.com/browse/MC-223613)"}, category={"bugfix"})
    public static boolean placeBlocksOutsideWorldBorderFix = false;
    @Rule(desc="Fixes pistons being able to push blocks outside of the world border", extra={"[MC-82010](https://bugs.mojang.com/browse/MC-82010)"}, category={"bugfix"})
    public static boolean incorrectPistonWorldBorderCheckFix = false;
    @Rule(desc="Fixes explosions being able to destroy blocks outside of the world border", extra={"[MC-54606](https://bugs.mojang.com/browse/MC-54606)"}, category={"bugfix"})
    public static boolean explosionsBypassWorldBorderFix = false;
    @Rule(desc="Fixes players sending the STEP event before the HIT_GROUND event", extra={"[MC-247417](https://bugs.mojang.com/browse/MC-247417)"}, category={"bugfix"})
    public static boolean playerStepEventFix = false;
    @Rule(desc="Fixes projectiles sending the PROJECTILE_LAND event when landing on a vibration occluding block", extra={"[MC-208771](https://bugs.mojang.com/browse/MC-208771)"}, category={"bugfix"}, condition={VersionConditions.GT_22w05a.class})
    public static boolean projectileMissingOcclusionFix = false;
    @Rule(desc="Fixes boats sending the SPLASH event when ridden over a vibration occluding block", extra={"[MC-208597](https://bugs.mojang.com/browse/MC-208597)"}, category={"bugfix"}, condition={VersionConditions.GT_22w05a.class})
    public static boolean boatMissingOcclusionFix = false;
    @Rule(desc="Fixes spawn eggs having an offset game event when spawning an entity", extra={"[MC-247643](https://bugs.mojang.com/browse/MC-247643)"}, category={"bugfix"}, condition={VersionConditions.GT_22w05a.class})
    public static boolean spawnEggOffsetEventFix = false;
    @Rule(desc="Fixes Spawning entities using spawn eggs on vibration occluding blocks not occluding", extra={"[MC-247645](https://bugs.mojang.com/browse/MC-247645)"}, category={"bugfix"}, condition={VersionConditions.GT_22w05a.class})
    public static boolean spawnEggMissingOcclusionFix = false;
    @Rule(desc="Fixes Spawning entities using spawn eggs on entities not creating ENTITY_PLACE game event", extra={"[MC-214472](https://bugs.mojang.com/browse/MC-214472)"}, category={"bugfix"}, condition={VersionConditions.GT_22w05a.class})
    public static boolean spawnEggMissingEventFix = false;
    @Rule(desc="Fixes minecarts sending the ENTITY_PLACE event when placed on a vibration occluding block", extra={"[MC-213823](https://bugs.mojang.com/browse/MC-213823)"}, category={"bugfix"}, condition={VersionConditions.GT_22w05a.class})
    public static boolean minecartMissingOcclusionFix = false;
    @Rule(desc="Fixes villagers not giving a discount if you log out while they are being cured", extra={"[MC-247647](https://bugs.mojang.com/browse/MC-247647)"}, category={"bugfix"})
    public static boolean villagerDiscountIgnoresOfflinePlayersFix = false;
    @Rule(desc="Fixes foxes pathfinding to origin (0,0) during a thunderstorm", extra={"[MC-179916](https://bugs.mojang.com/browse/MC-179916)"}, category={"bugfix"})
    public static boolean foxesGoToOriginDuringThunderFix = false;
    @Rule(desc="Fixes villagers converting to witches while sleeping, not changing the bed occupancy", extra={"[MC-167242](https://bugs.mojang.com/browse/MC-167242)"}, category={"bugfix"})
    public static boolean villagerToWitchBedOccupiedFix = false;
    @Rule(desc="Fixes reload update order for tile entities", extra={"Fixes instant wires randomly breaking - Effective after chunk reload.", "Fixes [MC-89146](https://bugs.mojang.com/browse/MC-89146)"}, category={"bugfix"})
    public static boolean reloadUpdateOrderFix = false;
    @Rule(desc="Fixes piston lastProgress not being set correctly", extra={"Related to [MC-89146](https://bugs.mojang.com/browse/MC-89146)"}, category={"bugfix", "nbt"})
    public static boolean pistonReloadInconsistencyFix = false;
    @Rule(desc="Fixes armor stands not taking damage in lava", extra={"[MC-199210](https://bugs.mojang.com/browse/MC-199210)"}, category={"bugfix", "recommended"})
    public static boolean armorStandNegateLavaDamageFix = false;
    @Rule(desc="Fixes armor stands not being damaged by cactus", extra={"[MC-224420](https://bugs.mojang.com/browse/MC-224420)"}, category={"bugfix", "recommended"})
    public static boolean armorStandNegateCactusDamageFix = false;
    @Rule(desc="Fixes armor stands not being damaged by anvils", extra={"[MC-203302](https://bugs.mojang.com/browse/MC-203302)"}, category={"bugfix", "recommended"})
    public static boolean armorStandNegateAnvilDamageFix = false;
    @Rule(desc="Fixes tripwires not being disarmed correctly", extra={"[MC-129055](https://bugs.mojang.com/browse/MC-129055)"}, category={"bugfix"})
    public static boolean tripwireNotDisarmingFix = false;
    @Rule(desc="Fixes powder snow letting light pass through it", extra={"[MC-205044](https://bugs.mojang.com/browse/MC-205044)"}, category={"bugfix", "intended"})
    public static boolean powderedSnowOpacityFix = false;
    @Rule(desc="Fixes hoppers being invisible when placed next to a powered block", extra={"It fixes clients not being able to see the hopper, by redrawing them if powered"}, category={"bugfix", "recommended"})
    public static boolean invisibleHopperFix = false;
    @Rule(desc="Fixes jumping always favors x axis, and having z collision restoring x velocity", extra={"[MC-146854](https://bugs.mojang.com/browse/MC-146854) & [MC-156309](https://bugs.mojang.com/browse/MC-156309)"}, category={"bugfix"}, condition={VersionConditions.LT_1_18_2_pre1.class})
    public static boolean velocityNotCancelledFix = false;
    @Rule(desc="Fixes Wither skull projectiles not saving if its charged/blue in there nbt", extra={"[MC-81656](https://bugs.mojang.com/browse/MC-81656)"}, category={"bugfix", "nbt"})
    public static boolean blueWitherSkullNotSavedFix = false;
    @Rule(desc="Fixes BlockPos distance calculations being offset, resulting in them being directional & incorrect", extra={"[MC-248225](https://bugs.mojang.com/browse/MC-248225)"}, category={"bugfix", "recommended"}, condition={VersionConditions.LT_22w05a.class})
    public static boolean incorrectBlockPosDistanceFix = false;
    @Rule(desc="Fixes a memory leak within the new TagKey system", extra={"[MC-248621](https://bugs.mojang.com/browse/MC-248621)"}, category={"bugfix", "crashfix", "recommended"}, validate={Validators.TagKeyMemoryLeakFixValidator.class}, condition={VersionConditions.GT_22w05a.class, Conditions.ConflictTechReborn.class})
    public static boolean tagKeyMemoryLeakFix = false;
    @Rule(desc="Prevents the NoCom Exploit from being able to crash the server", extra={"There is a fabric mod that is able to do this in vanilla!"}, category={"bugfix", "crashfix", "recommended"})
    public static boolean nocomExploitFix = false;
    @Rule(desc="Fixes the structure manager not being able to load snbt versions of nbt files", extra={"This makes it possible for structure blocks to load snbt files also.", "Should not be used in survival or for datapacks, since its slower than nbt"}, category={"bugfix", "creative"})
    public static boolean structureManagerCantLoadSnbtFix = false;
    @Rule(desc="Fixes the stepAndDestroyBlockGoal using the origin without first checking if its valid", category={"bugfix"})
    public static boolean stepAndDestroyBlockGoalUsesOriginFix = false;
    @Rule(desc="Fixes hopper minecarts being 4x slower at [0,0,0]", category={"bugfix"})
    public static boolean hopperMinecartSlowerAtOriginFix = false;
    @Rule(desc="Fixes cactus breaking when moving a non-solid block next to them with a piston", extra={"[MC-160095](https://bugs.mojang.com/browse/MC-160095)"}, category={"bugfix"})
    public static boolean nonSolidBlocksBreakCactusIfPushedFix = false;
    @Rule(desc="Fixes mobs being able to spawn on moving pistons", category={"bugfix"})
    public static boolean mobsSpawnOnMovingPistonsFix = false;
    @Rule(desc="Fixes an edge case within geodes where it will waterlog a block next to lava, due to missing fluid check", category={"bugfix"})
    public static boolean geodeLavalogFix = false;
    @Rule(desc="Fixes client stats being lost when teleporting between dimensions", extra={"[MC-124177](https://bugs.mojang.com/browse/MC-124177)"}, category={"bugfix"})
    public static boolean crossDimensionTeleportLosesStatsFix = false;
    @Rule(desc="Fixes InhabitedTime not always updating in some chunks", extra={"[MC-127407](https://bugs.mojang.com/browse/MC-127407)"}, category={"bugfix"})
    public static boolean inhabitedTimeFix = false;
    @Rule(desc="Fixes coral being movable. Controversial fix - If you don't like it, don't use it xD", extra={"[MC-133541](https://bugs.mojang.com/browse/MC-133541)"}, category={"bugfix"})
    public static boolean movableCoralFanFix = false;
    @Rule(desc="Fixes dying entities being affected by splash potion effects and area effect clouds", extra={"[MC-114761](https://bugs.mojang.com/browse/MC-114761)"}, category={"bugfix"})
    public static boolean potionEffectsAffectDeadEntitiesFix = false;
    @Rule(desc="Fixes chorus fruits item not resetting fall damage on teleport", extra={"[MC-112133](https://bugs.mojang.com/browse/MC-112133)"}, category={"bugfix"})
    public static boolean chorusFruitFallDamageFix = false;
    @Rule(desc="Fixes comparators being unable to get the signal strength from a blocked chest", extra={"[MC-100302](https://bugs.mojang.com/browse/MC-100302)"}, category={"bugfix"})
    public static boolean comparatorSkipsBlockedChestFix = false;
    @Rule(desc="Fixes brewing stands resetting there brewTime when being unloaded", extra={"[MC-26304](https://bugs.mojang.com/browse/MC-26304)"}, category={"bugfix"})
    public static boolean brewingResetsOnUnloadFix = false;
    @Rule(desc="Fixes tnt being created in extended hitboxes causing tnt to clip through them", extra={"[MC-12730](https://bugs.mojang.com/browse/MC-12730)"}, category={"bugfix"})
    public static boolean tntExtendedHitboxClipFix = false;
    @Rule(desc="Fixes tnt minecarts blowing up when basically turning any rail while next to a block", extra={"[MC-7464](https://bugs.mojang.com/browse/MC-7464)"}, category={"bugfix"})
    public static boolean tntMinecartTerribleCollisionFix = false;
    @Rule(desc="Fixes tridents not dealing damage after having been in a block", extra={"[MC-130151](https://bugs.mojang.com/browse/MC-130151)"}, category={"bugfix"})
    public static boolean tridentFallingDamageFix = false;
    @Rule(desc="Fixes daylight sensors not setting there power state when placed by a player", extra={"[MC-156867](https://bugs.mojang.com/browse/MC-156867)"}, category={"bugfix"})
    public static boolean daylightSensorPlacementFix = false;
    @Rule(desc="Fixes comparators not being able to get containers through opaque full blocks like pistons & observers", category={"bugfix", "parity"})
    public static boolean comparatorTransparencyFix = false;
    @Rule(desc="Fixes enderman doing teleporting effects and sounds and avoiding projectiles while in a vehicle", extra={"[MC-183446](https://bugs.mojang.com/browse/MC-183446)"}, category={"bugfix"})
    public static boolean endermanAvoidProjectilesInVehicleFix = false;
    @Rule(desc="Fixes enderman teleporting away during damage, making other damage systems believe the enderman got hurt. Such as wither skulls applying wither", extra={"[MC-186119](https://bugs.mojang.com/browse/MC-186119)"}, category={"bugfix"})
    public static boolean endermanPainfulTeleportFix = false;
    @Rule(desc="Fixes villagers being hurt by there own fireworks", extra={"[MC-195326](https://bugs.mojang.com/browse/MC-195326) & [MC-233250](https://bugs.mojang.com/browse/MC-233250)"}, category={"bugfix"})
    public static boolean badVillagerPyrotechnicsFix = false;
    @Rule(desc="Fixes the projectileAttackGoal targetting dead entities", extra={"[MC-165516](https://bugs.mojang.com/browse/MC-165516)"}, category={"bugfix"})
    public static boolean projectileGoalTargetsDeadEntitiesFix = false;
    @Rule(desc="Fixes the enderdragon not dropping the blocks it breaks", extra={"[MC-220519](https://bugs.mojang.com/browse/MC-220519)"}, category={"bugfix"})
    public static boolean enderDragonDoesntDropBlocksFix = false;
    @Rule(desc="Fixes the end gateway teleport check using blocks that should be invalid as valid for teleporting", extra={"[MC-193421](https://bugs.mojang.com/browse/MC-193421)"}, category={"bugfix"})
    public static boolean spawnInsideGatewayFix = false;
    @Rule(desc="Fixes sweeping edge not applying fire aspect", extra={"[MC-93669](https://bugs.mojang.com/browse/MC-93669)"}, category={"bugfix"})
    public static boolean sweepingIgnoresFireAspectFix = false;
    @Rule(desc="Fixes snow golem attacking creepers, resulting in there death", extra={"[MC-73964](https://bugs.mojang.com/browse/MC-73964)"}, category={"bugfix"})
    public static boolean snowGolemAttackCreepersFix = false;
    @Rule(desc="Fixes shulker box missing a block update", extra={"[MC-190815](https://bugs.mojang.com/browse/MC-190815)"}, category={"bugfix"})
    public static boolean shulkerBoxMissingUpdateFix = false;
    @Rule(desc="Fixes the viewer count for some inventories (chest, ender chest, barrel) being able to go into the negatives", extra={"[MC-229680](https://bugs.mojang.com/browse/MC-229680) & [MC-208051](https://bugs.mojang.com/browse/MC-208051)"}, category={"bugfix"})
    public static boolean viewerCountNegativesFix = false;
    @Rule(desc="Fixes a 8x teleport exploit using beds", category={"bugfix"})
    public static boolean bedTeleportExploitFix = false;
    @Rule(desc="Fixes record world events being sent at the wrong time, causing multiple disks to play at the same time", extra={"[MC-112245](https://bugs.mojang.com/browse/MC-112245)"}, category={"bugfix"})
    public static boolean recordWorldEventFix = false;
    @Rule(desc="Fixes pointed dripstone skipping the entity check", extra={"[MC-206599](https://bugs.mojang.com/browse/MC-206599)"}, category={"bugfix"})
    public static boolean dripstoneSkipsEntityCheckFix = false;
    @Rule(desc="Fixes double blocks like beds & doors from skipping the entity check", extra={"[MC-123619](https://bugs.mojang.com/browse/MC-123619)"}, category={"bugfix"})
    public static boolean doubleBlocksSkipEntityCheckFix = false;
    @Rule(desc="Fixes mobs attacking themselves. Self-Harm should not be taught to kids ;)", extra={"[MC-110386](https://bugs.mojang.com/browse/MC-110386)"}, category={"bugfix"})
    public static boolean selfHarmFix = false;
    @Rule(desc="Fixes mobs being able to hit entities through blocks", extra={"This might have an impact on performance, although shouldn't be that bad", "[MC-2310](https://bugs.mojang.com/browse/MC-2310)"}, category={"bugfix"})
    public static boolean mobsAttackThroughBlocksFix = false;
    @Rule(desc="Fixes bees being able to feel none-existing rain", extra={"[MC-178119](https://bugs.mojang.com/browse/MC-178119)"}, category={"bugfix"})
    public static boolean beesFearRainFix = false;
    @Rule(desc="Fixes being able to start the conversion of zombie villagers while they are already converting", extra={"[MC-166984](https://bugs.mojang.com/browse/MC-166984)"}, category={"bugfix"})
    public static boolean convertConvertingZombieVillagersFix = false;
    @Rule(desc="Fixes pistons pushing entities too far due to the offset", category={"bugfix"})
    public static boolean pistonsPushTooFarFix = false;
    @Rule(desc="Fixes bees just not flying when spawning due to navigation not being set", extra={"[MC-190042](https://bugs.mojang.com/browse/MC-190042)"}, category={"bugfix"})
    public static boolean beesDropLikeBouldersFix = false;
    @Rule(desc="Fixes the follow parent goal not setting the movement control, causing babies to move incorrectly", extra={"[MC-149838](https://bugs.mojang.com/browse/MC-149838)"}, category={"bugfix"})
    public static boolean followParentGoalBreaksMovementFix = false;
    @Rule(desc="Fixes leash not updating when mobs break there leashes", extra={"[MC-16663](https://bugs.mojang.com/browse/MC-16663), [MC-96347](https://bugs.mojang.com/browse/MC-96347), and [MC-102214](https://bugs.mojang.com/browse/MC-102214)"}, category={"bugfix"})
    public static boolean leashKnotNotUpdatingOnBreakFix = false;
    @Rule(desc="Fixes leashes not being detached on mobs being put in a bucket. So you don't get your leash back", extra={"[MC-229057](https://bugs.mojang.com/browse/MC-229057)"}, category={"bugfix"})
    public static boolean bucketableMobsNotDetachingLeashesFix = false;
    @Rule(desc="Fixes snowman creating snow while not touching the ground", extra={"[MC-214344](https://bugs.mojang.com/browse/MC-214344)"}, category={"bugfix"})
    public static boolean snowmanCreateSnowWhileFloatingFix = false;
    @Rule(desc="Fixes sheep being able to eat grass through full blocks", extra={"[MC-76490](https://bugs.mojang.com/browse/MC-76490)"}, category={"bugfix"})
    public static boolean sheepEatGrassThroughBlocksFix = false;
    @Rule(desc="Fixes ocelots and cats trying to flee from the player while being stuck in a vehicle like a boat", extra={"[MC-53721](https://bugs.mojang.com/browse/MC-53721)"}, category={"bugfix"})
    public static boolean ocelotsAndCatsTryToFleeInVehicleFix = false;
    @Rule(desc="Fixes enchanting in creative mode still deducting experience", extra={"[MC-12656](https://bugs.mojang.com/browse/MC-12656)"}, category={"bugfix", "creative"})
    public static boolean creativeEnchantingCostsExperienceFix = false;
    @Rule(desc="Fixes boats created from dispensers spawning more then half a block higher then the water", category={"bugfix"})
    public static boolean boatsCreatedTooHighFix = false;
    @Rule(desc="Fixes boats getting created within the dispenser that created them", extra={"[MC-1310](https://bugs.mojang.com/browse/MC-1310)"}, category={"bugfix"})
    public static boolean boatsStuckInDispensersFix = false;
    @Rule(desc="Fixes armor stands not being able to ride vehicles", extra={"[MC-90923](https://bugs.mojang.com/browse/MC-90923)"}, category={"bugfix"})
    public static boolean armorStandsCantRideVehiclesFix = false;
    @Rule(desc="Fixes marker armor stands being able to trigger traps such as pressure plates, and string", extra={"[MC-135809](https://bugs.mojang.com/browse/MC-135809)"}, category={"bugfix"})
    public static boolean markerArmorStandsTriggerBlocksFix = false;
    @Rule(desc="Fixes marker armor stands creating bubbles in water", extra={"[MC-78314](https://bugs.mojang.com/browse/MC-78314)"}, category={"bugfix"})
    public static boolean markerArmorStandsCreateBubblesFix = false;
    @Rule(desc="Fixes beacons always playing the depowering sound when broken even if it was not powered", extra={"[MC-153086](https://bugs.mojang.com/browse/MC-153086)"}, category={"bugfix"})
    public static boolean beaconsAlwaysPlaySoundOnBreakFix = false;
    @Rule(desc="Fixes falling block damage bounding box being offset", extra={"[MC-203302](https://bugs.mojang.com/browse/MC-203302)"}, category={"bugfix"})
    public static boolean fallingBlockDamageIsOffsetFix = false;
    @Rule(desc="Fixes hunger depleting in peaceful mode", extra={"[MC-31819](https://bugs.mojang.com/browse/MC-31819)"}, category={"bugfix"})
    public static boolean hungerGoesDownInPeacefulFix = false;
    @Rule(desc="Fixes bees trying to swim in water causing them to die", extra={"Bees must be reloaded for the fix to take place", "[MC-190261](https://bugs.mojang.com/browse/MC-190261)"}, category={"bugfix"})
    public static boolean beesSwimInWaterAndDieFix = false;
    @Rule(desc="Fixes hoppers choosing a random minecart, resulting in slower item transfers", extra={"[MC-124099](https://bugs.mojang.com/browse/MC-124099)"}, category={"bugfix"})
    public static boolean hoppersSelectMinecartsRandomlyFix = false;
    @Rule(desc="Fixes jukebox not spawning disc in the center of the block when broken", extra={"[MC-166032](https://bugs.mojang.com/browse/MC-166032)"}, category={"bugfix"})
    public static boolean jukeboxDiscItemOffsetOnBreakFix = false;
    @Rule(desc="Fixes mobs with a deathTime higher then 19 causing entities to never die", extra={"[MC-84873](https://bugs.mojang.com/browse/MC-84873)"}, category={"bugfix"})
    public static boolean deathTimeCorruptsMobsFix = false;
    @Rule(desc="Fixes witches & cats spawning inside of each other, by shifting the cat over by another block", extra={"[MC-163503](https://bugs.mojang.com/browse/MC-163503)"}, category={"bugfix"})
    public static boolean witchAndCatSpawnMergedFix = false;
    @Rule(desc="Fixes ice not turning to water when broken by a player if the block below is waterlogged", extra={"[MC-206185](https://bugs.mojang.com/browse/MC-206185)"}, category={"bugfix"})
    public static boolean iceWaterSkipsWaterloggedFix = false;
    @Rule(desc="Fixes entities created with duplicate uuid's", extra={"[MC-137370](https://bugs.mojang.com/browse/MC-137370)"}, category={"bugfix", "experimental"})
    public static boolean duplicateEntityUUIDFix = false;
    @Rule(desc="Fixes giant trees creating an extra single log at the top corner", category={"bugfix"})
    public static boolean giantTreesHaveExtraLogFix = false;
    @Rule(desc="Fixes players unable to jump off the edge of blocks while sneaking and having a block above them", extra={"[MC-197647](https://bugs.mojang.com/browse/MC-197647)"}, category={"bugfix"})
    public static boolean cantJumpOffBlockWhenSneakingFix = false;
    @Rule(desc="Fixes projectiles keeping there velocity", extra={"[MC-198908](https://bugs.mojang.com/browse/MC-198908)"}, category={"bugfix"})
    public static boolean projectileKeepsVelocityFix = false;
    @Rule(desc="Fixes BreakDoorGoal not stopping on entity death, leading to cracks that stay for a while", extra={"[MC-185597](https://bugs.mojang.com/browse/MC-185597)"}, category={"bugfix"})
    public static boolean doorBreakNotStoppedOnDeathFix = false;
    @Rule(desc="Fixes shipwrecks having different block palettes and heights between chunk borders", extra={"[MC-131745](https://bugs.mojang.com/browse/MC-131745)"}, category={"bugfix"})
    public static boolean shipwreckChunkBorderIssuesFix = false;
    @Rule(desc="Fixes note blocks not setting there powered state when placed by a player", category={"bugfix"})
    public static boolean noteBlockNotPoweredOnPlaceFix = false;
    @Rule(desc="Fixes wolves getting hurt from damage that should not hurt, such as snowballs", extra={"[MC-72151](https://bugs.mojang.com/browse/MC-72151)"}, category={"bugfix"})
    public static boolean zeroDamageHurtsWolvesFix = false;
    @Rule(desc="Fixes absorption effect not going away even after the absorption hearts are gone", extra={"[MC-202432](https://bugs.mojang.com/browse/MC-202432)"}, category={"bugfix"})
    public static boolean absorptionStaysWithoutHeartsFix = false;
    @Rule(desc="Fixes broken status effect logic resulting in hidden status effects not running onRemove() or onApplied() for the correct effect strength", extra={"[MC-182497](https://bugs.mojang.com/browse/MC-182497)"}, category={"bugfix"})
    public static boolean brokenHiddenStatusEffectFix = false;
    @Rule(desc="Fixes powder snow only slowing down players when there feet are in the block", extra={"[MC-205242](https://bugs.mojang.com/browse/MC-205242)"}, category={"bugfix"})
    public static boolean powderSnowOnlySlowIfFeetInBlockFix = false;
    @Rule(desc="Fixes lava creating fire with incorrect block states", extra={"[MC-250048](https://bugs.mojang.com/browse/MC-250048)"}, category={"bugfix"})
    public static boolean lavaCalculatesWrongFireStateFix = false;
    @Rule(desc="Fixes void trading", extra={"The ability to trade with a villager in unloaded chunks allowing for infinite trading"}, category={"bugfix"})
    public static boolean voidTradingFix = false;
    @Rule(desc="Fixes villager trade demand decreases indefinitely", extra={"[MC-163962](https://bugs.mojang.com/browse/MC-163962)"}, category={"bugfix"})
    public static boolean tradeDemandDecreasesIndefinitelyFix = false;
    @Rule(desc="Fixes not being able to use /data on players", extra={"[MC-122102](https://bugs.mojang.com/browse/MC-122102)"}, category={"bugfix", "experimental", "intended"})
    public static boolean unableToModifyPlayerDataFix = false;
    @Rule(desc="Fixes the pressure plate hitbox not matching the model", extra={"[MC-248753](https://bugs.mojang.com/browse/MC-248753)"}, validate={Validators.wrongPressurePlateHitboxValidator.class}, category={"bugfix"})
    public static boolean wrongPressurePlateHitboxFix = false;
    @Rule(desc="Fixes an ArrayIndexOutOfBoundsException error within the merchant trade packet", extra={"[MC-200000](https://bugs.mojang.com/browse/MC-200000)"}, category={"bugfix"})
    public static boolean merchantTradePacketExceptionFix = false;
    @Rule(desc="Fixes cakes being eaten from all sides", extra={"[MC-249685](https://bugs.mojang.com/browse/MC-249685)"}, category={"bugfix"})
    public static boolean eatCakeFromAllSidesFix = false;
    @Rule(desc="Fixes some events / actions not triggering observers", extra={"[MC-107664](https://bugs.mojang.com/browse/MC-107664)"}, category={"bugfix"})
    public static boolean missingObserverUpdatesFix = false;
    @Rule(desc="Fixes pistons pulling/pushing blocks using a hashmap causing order to be locational", extra={"[MC-233420](https://bugs.mojang.com/browse/MC-233420)"}, category={"bugfix"})
    public static boolean pistonUpdateOrderIsLocationalFix = false;
    @Rule(desc="Fixes an optimization in 1.18 changing the behaviour of many goals even though mojang said it would change nothing", extra={"This bug results in many goals being slower, or happening less often. It also seems to cause other goals to be faster!"}, category={"bugfix"})
    public static boolean slowedEntityGoalsFix = false;
    @Rule(desc="Fixes Entities growing up still clipping through walls if they have a collision above them", extra={"Suggested fix by __MethodZz__ from: https://www.youtube.com/watch?v=Tg5eQk6P-NQ"}, category={"bugfix"})
    public static boolean entityGrowingUpCollisionClippingFix = false;
    @Rule(desc="Fixes striders with noAi still getting cold", extra={"[MC-176081](https://bugs.mojang.com/browse/MC-176081)"}, category={"bugfix"})
    public static boolean noAIStriderGetsColdFix = false;
    @Rule(desc="Fixes mobs that fight as a group targeting dead entities, leading to many bugs", extra={"[MC-183990](https://bugs.mojang.com/browse/MC-183990)"}, category={"bugfix"})
    public static boolean mobsTargetDeadEntitiesFix = false;
    @Rule(desc="Fixes frictionless goats, currently requires to be modified per mob", extra={"[MC-228273](https://bugs.mojang.com/browse/MC-228273)"}, category={"bugfix"})
    public static boolean frictionlessEntitiesFix = false;
    @Rule(desc="Fixes the end obsidian platform breaking blocks above the platform every time you travel to the end", extra={"[MC-902](https://bugs.mojang.com/browse/MC-902)"}, category={"bugfix"})
    public static boolean obsidianPlatformDestroysBlocksFix = false;
    @Rule(desc="Fixes grindstones not being movable", extra={"[MC-140498](https://bugs.mojang.com/browse/MC-140498)"}, category={"bugfix"})
    public static boolean grindstonesNotMovableFix = false;
    @Rule(desc="Fixes depth strider slowing down riptide, causing riptide to be slower in water and messing up the launching", extra={"[MC-136249](https://bugs.mojang.com/browse/MC-136249)"}, category={"bugfix", "client"})
    public static boolean depthStriderSlowsRiptideFix = false;
    @Rule(desc="Fixes enderman, chorus fruit, and some other teleports from teleporting past the world border", extra={"[MC-106416](https://bugs.mojang.com/browse/MC-106416)"}, category={"bugfix"})
    public static boolean teleportPastWorldBorderFix = false;
    @Rule(desc="Fixes grass turning to dirt if more then 1 snow layer is on top of it.", extra={"[MC-150654](https://bugs.mojang.com/browse/MC-150654)"}, category={"bugfix"})
    public static boolean grassSnowLayersFix = false;
    @Rule(desc="Fixes lava not being able to convert bubble columns to stone", extra={"[MC-137713](https://bugs.mojang.com/browse/MC-137713)"}, category={"bugfix"})
    public static boolean lavaIgnoresBubbleColumnFix = false;
    @Rule(desc="Fixes minecart colliding when standing still", extra={"[MC-14850](https://bugs.mojang.com/browse/MC-14850)"}, category={"bugfix"})
    public static boolean directionalMinecartCollisionFix = false;
    @Rule(desc="Fixes minecart not bouncing from any transparent block with a full face", extra={"[MC-6311](https://bugs.mojang.com/browse/MC-6311) & [MC-171903](https://bugs.mojang.com/browse/MC-171903)"}, category={"bugfix"})
    public static boolean minecartWontBounceFix = false;
    @Rule(desc="Fixes detector rails detecting the minecarts to early and causing minecarts to go in the wrong direction", extra={"[MC-868](https://bugs.mojang.com/browse/MC-868)"}, category={"bugfix"})
    public static boolean detectorRailDetectsTooEarlyFix = false;
    @Rule(desc="Makes rails faster by removing most updates on themselves, duplicate updates, and doing rail search internally", extra={"This kind of prevents update suppression using a normal suppressor. It requires an angled suppressor to work!", "This probably changes some rail behavior although so far does not seem to do so. Does change amount of block updates tho"}, category={"optimization"})
    public static boolean optimizedPoweredRails = false;
    @Rule(desc="Initial made for Lithium, although was not exactly vanilla behavior. This is a very small optimization!", category={"optimization"})
    public static boolean optimizedTicketManager = false;
    @Rule(desc="Changes Math.round to a faster implementation. Although it does not give the exact same results", extra={"This does not affect many things and will most likely be unnoticeable. It is ~1.28x faster"}, category={"optimization"})
    public static boolean optimizedRounding = false;
    @Rule(desc="Changes MathHelper.hypot to a faster implementation. It gives nearly perfectly accurate results", extra={"Currently only effect chunks blending so will likely be unnoticeable. It is ~1.6x faster", "recommended that you set this on permanently, and restart the server for best results"}, category={"optimization"})
    public static boolean optimizedHypot = false;
    @Rule(desc="Changes many of the main Random() calls to use XoroShiro128++ instead", extra={"This will break anything related to random, technically still possible to crack*", "recommended that you set this on permanently, and restart the server for best results"}, category={"optimization"})
    public static boolean optimizedRandom = false;
    @Rule(desc="Optimized the getBiome call to be 25% - 75% faster", extra={"This is a fully vanilla optimization. This can optimize the client also, go check Blanket-client-tweaks for that"}, category={"optimization", "vanilla", "recommended"}, condition={VersionConditions.GT_22w05a.class})
    public static boolean optimizedBiomeAccess = false;
    @Rule(desc="Optimized the RecipeManager getFirstMatch call to be up to 3x faster", extra={"This is a fully vanilla optimization. Improves: [Blast]Furnace/Campfire/Smoker/Stonecutter/Crafting/Sheep Color Choosing", "This was mostly made for the auto crafting table, since the performance boost is much more visible while using that mod"}, category={"optimization", "vanilla", "recommended"})
    public static boolean optimizedRecipeManager = false;
    @Rule(desc="Optimized the Furnace code drastically. Improving expensive checks, and expensive recipe lookups", extra={"This is a fully vanilla optimization. Improves: Furnace, Blast Furnace, Smoker, & any furnace extension", "This is incredibly visible in modded scenarios"}, category={"optimization", "vanilla", "recommended"})
    public static boolean optimizedFurnaces = false;
    @Rule(desc="Fixes falling blocks duping using the end portal", category={"bugfix", "dupe"})
    public static boolean fallingBlockDuplicationFix = false;
    @Rule(desc="Fixes rails duplicating", category={"bugfix", "dupe"})
    public static boolean railDuplicationFix = false;
    @Rule(desc="Fixes TNT & carpet dupers, and part of rail dupers", extra={"Attachment block update based dupers will do nothing and redstone component update based dupers can no longer keep their duped block", "Implementation by Carpet-TIS-Addition - Dupe bad dig good"}, category={"bugfix", "dupe"})
    public static boolean pistonDupingFix = false;
    @Rule(desc="Fixes being able to dupe items using the /give command", extra={"[MC-120507](https://bugs.mojang.com/browse/MC-120507)"}, category={"bugfix", "recommended", "dupe"})
    public static boolean giveCommandDupeFix = false;
    @Rule(desc="Fixes /data duping inventories when modifying entity data", extra={"[MC-112826](https://bugs.mojang.com/browse/MC-112826) & [MC-191011](https://bugs.mojang.com/browse/MC-191011)"}, category={"bugfix", "recommended", "vanilla", "dupe"})
    public static boolean nbtDataDupeFix = false;
    @Rule(desc="Fixes bees duplicating while trying to load a beehive/beenest in unloaded chunks", extra={"[MC-234471](https://bugs.mojang.com/browse/MC-234471)"}, category={"bugfix", "experimental", "dupe"})
    public static boolean beeDupeFix = false;
    @Rule(desc="Fixes a general item dupe using shulker boxes", category={"bugfix", "recommended", "dupe"})
    public static boolean breakSwapGeneralItemDupeFix = false;
    @Rule(desc="Fixes a string dupe using water & tripwire hooks", extra={"[MC-59471](https://bugs.mojang.com/browse/MC-59471)"}, category={"bugfix", "dupe"})
    public static boolean stringDupeFix = false;
    @Rule(desc="Fixes a tripwire hook dupe using doors & trapdoors", category={"bugfix", "dupe"})
    public static boolean tripwireHookDupeFix = false;
    @Rule(desc="Fixes a donkey/llama/horse dupe that is possible by using a client-side mod", category={"bugfix", "dupe"})
    public static boolean horseDupeFix = false;
    @Rule(desc="Re-introduces target blocks being permanently powered when moved by pistons", extra={"Reverts [MC-173244](https://bugs.mojang.com/browse/MC-173244)"}, category={"reintroduce"})
    public static boolean reIntroduceTargetBlockPermanentlyPowered = false;
    @Rule(desc="Re-introduces lightning rods being permanently powered when moved by pistons", extra={"Reverts [MC-203718](https://bugs.mojang.com/browse/MC-203718)"}, category={"reintroduce"})
    public static boolean reIntroduceLightningRodPermanentlyPowered = false;
    @Rule(desc="Re-introduces general item dupe using dolphins, and some other dimension change dupes", category={"reintroduce", "dupe"})
    public static boolean reIntroducePortalGeneralItemDupe = false;
    @Rule(desc="Re-introduces 1.12 flint and steel behavior. Flint and steel can be used for updating observers / buds", extra={"Reverts [MC-4923](https://bugs.mojang.com/browse/MC-4923) from 18w05a"}, category={"reintroduce"})
    public static boolean reIntroduceFlintAndSteelBehavior = false;
    @Rule(desc="Re-introduces multiplayer donkey/llama dupe bug based on disconnecting while riding donkey/llama", extra={"Reverts [MC-181241](https://bugs.mojang.com/browse/MC-181241) from 18w05a", "This has not been tested in 1.18 and may not work!"}, category={"reintroduce", "experimental", "dupe"})
    public static boolean reIntroduceDonkeyRidingDupe = false;
    @Rule(desc="Re-introduces item shadowing!", extra={"[PR0CESS's Video](https://youtu.be/i8_FPyn20ns) & [Fallen_Breath's Video](https://youtu.be/mTeYwq7HaEA)"}, category={"reintroduce", "dupe"})
    public static boolean reIntroduceItemShadowing = false;
    @Rule(desc="Re-introduces zero tick farms", extra={"Reverts [MC-113809](https://bugs.mojang.com/browse/MC-113809) from 20w12a"}, category={"reintroduce"})
    public static boolean reIntroduceZeroTickFarms = false;
    @Rule(desc="Re-introduces only saving during autosaves instead of any time", extra={"Reverts 'saving chunks whenever there is time spare to reduce autosave spikes' from 20w12a", "This makes your hard drive work overtime, so people with slow drives might suffer from this. This fixes that!"}, category={"reintroduce"})
    public static boolean reIntroduceOnlyAutoSaveSaving = false;
    @Rule(desc="Re-introduces very aggressive saving by removing the chunk save cooldown that was added in 22w05a", extra={"For obvious reasons, this does not work when `reIntroduceOnlyAutoSaveSaving` is enabled"}, category={"reintroduce"})
    public static boolean reIntroduceVeryAggressiveSaving = false;
    @Rule(desc="Re-introduces falling blocks giving block updates during the entity phase changed in 22w03a", category={"reintroduce"})
    public static boolean reIntroduceFallingBlockEntityPhase = false;
    @Rule(desc="Re-introduces Piston Translocation from 1.10", category={"reintroduce"})
    public static boolean reIntroducePistonTranslocation = false;
    @Rule(desc="Re-introduces or better said, reverts an optimization made in 21w39a that broken many entity goaltimings. The optimization made many tasks slower, and others faster. It was not done correctly!", extra={"Technically this was an optimization so enabling this rule will most likely come at a performance cost!"}, category={"reintroduce"})
    public static boolean reIntroduceProperGoalTimings = false;
    @Rule(desc="Fixes Lightning killing the items that drop from entities it kills", extra={"[MC-206922](https://bugs.mojang.com/browse/MC-206922)"}, category={"bugfix"})
    public static boolean lightningKillsDropsFix = false;
    @Rule(desc="Re-adds 1.8 double retraction to pistons", category={"bugfix", "experimental"}, extra={"Gives pistons the ability to double retract without side effects", "Fixes [MC-88959](https://bugs.mojang.com/browse/MC-88959)"})
    public static boolean doubleRetraction = false;
    @Rule(desc="Fixes Quick pulses getting lost in repeater setups", extra={"Probably brings back pre 1.8 behaviour", "[MC-54711](https://bugs.mojang.com/browse/MC-54711)"}, category={"bugfix"})
    public static boolean repeaterPriorityFix = false;
    @Rule(desc="Allows you to change the max amount of chunks that can save per autosave", extra={"If your server has large lag spikes due to chunk saving, you can lower this number."}, options={"300", "200", "100", "50"}, category={"advanced", "optimization"}, condition={VersionConditions.GT_22w04a.class})
    public static int maxChunksSavedPerAutoSave = 200;
    @Rule(desc="Allows you to change the max amount of chunks that can save per tick for the 1.18 chunk saving system", extra={"This is for the system which just attempt to save chunks every tick. Max chunks saved per tick"}, options={"100", "50", "20", "10"}, category={"advanced", "optimization"}, condition={VersionConditions.GT_22w04a.class})
    public static int maxChunksSavedPerTick = 20;
    @Rule(desc="Allows you to change the delay between autosaves in ticks", extra={"Shortening this number will make your server save more often which will also spread the load on the server"}, options={"12000", "6000", "3600", "1200"}, category={"advanced", "optimization"})
    public static int delayBetweenAutoSaves = 6000;
    @Rule(desc="Allows you to change max tick delay before a task is cancelled", extra={"Lower value raises the task leniency. Basically lower number means higher chance of success"}, options={"12", "6", "3", "1"}, category={"advanced", "experimental"})
    public static int maxTickLatency = 3;
    @Rule(desc="Allows you to change how long the server player list wait before updating", extra={"delay is in nanoseconds. Default is 5 seconds (5000000000) [1m,10s,5s,1s]"}, options={"60000000000", "10000000000", "5000000000", "1000000000"}, category={"advanced"})
    public static long statusUpdateDelay = 5000000000L;
    @Rule(desc="Allows you to toggle onlineMode without needing to restart the server", validate={Validators.onlineModeValidator.class}, category={"advanced", "experimental"})
    public static boolean toggleOnlineMode = CarpetServer.minecraft_server == null || CarpetServer.minecraft_server.method_3828();
    @Rule(desc="Allows you to toggle preventing proxy connections without needing to restart the server", validate={Validators.preventProxyConnectionsValidator.class}, category={"advanced", "experimental"})
    public static boolean togglePreventProxyConnections = CarpetServer.minecraft_server != null && CarpetServer.minecraft_server.method_3775();
    @Rule(desc="Allows you to toggle pvpEnabled without needing to restart the server", validate={Validators.pvpEnabledValidator.class}, category={"advanced"})
    public static boolean togglePvpEnabled = CarpetServer.minecraft_server == null || CarpetServer.minecraft_server.method_3852();
    @Rule(desc="Allows you to toggle flightEnabled without needing to restart the server", validate={Validators.flightEnabledValidator.class}, category={"advanced"})
    public static boolean toggleFlightEnabled = CarpetServer.minecraft_server != null && CarpetServer.minecraft_server.method_3718();
    @Rule(desc="Allows you to toggle enforcing the whitelist without needing to restart the server", validate={Validators.enforceWhitelistValidator.class}, category={"advanced"})
    public static boolean toggleEnforceWhitelist = CarpetServer.minecraft_server != null && CarpetServer.minecraft_server.method_3729();
    @Rule(desc="Allows you to change the chunk save cooldown added in 22w05a", extra={"Set to 10s by default, this is the delay between chunks aggressively saving", "If your server has large lag spikes due to chunk saving, you can raise this number.", "For obvious reasons, this rule is disabled when `reIntroduceVeryAggressiveSaving` is enabled"}, options={"120000", "60000", "10000", "1000", "0"}, category={"advanced", "optimization"}, condition={VersionConditions.GT_22w04a.class})
    public static int chunkSaveCooldownDelay = 10000;
    @Rule(desc="Makes block update order random", category={"parity"})
    public static boolean parityRandomBlockUpdates = false;
    @Rule(desc="Allows pistons to push and pull light blocks", category={"parity"})
    public static boolean parityMovableLightBlocks = false;
    @Rule(desc="Comparators no longer output level 15 if the full block its reading from is powered if there is a container behind it", extra={"Relates to [MC-64394](https://bugs.mojang.com/browse/MC-64394) which marked as Works As Intended"}, category={"parity"})
    public static boolean parityTerribleComparators = false;
}

