/*
 * Decompiled with CFR 0.152.
 */
package carpetfixes.mixins.optimizations;

import carpetfixes.CFSettings;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.function.Predicate;
import net.minecraft.class_3204;
import net.minecraft.class_3228;
import net.minecraft.class_3898;
import net.minecraft.class_4706;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_3204.class})
public abstract class ChunkTicketManager_optimizationMixin {
    @Shadow
    private long field_13894;
    @Shadow
    @Final
    Long2ObjectOpenHashMap<class_4706<class_3228<?>>> field_13895;
    @Shadow
    @Final
    private class_3204.class_4077 field_18252;
    private final Long2ObjectOpenHashMap<class_4706<class_3228<?>>> positionWithExpiringTicket = new Long2ObjectOpenHashMap();

    @Shadow
    private static int method_14046(class_4706<class_3228<?>> sortedArraySet) {
        throw new UnsupportedOperationException();
    }

    private static boolean canAnyExpire(class_4706<class_3228<?>> tickets) {
        for (class_3228 ticket : tickets) {
            if (!ChunkTicketManager_optimizationMixin.canExpire(ticket)) continue;
            return true;
        }
        return false;
    }

    private static boolean canExpire(class_3228<?> ticket) {
        return ticket.method_14281().method_20629() != 0L;
    }

    @Shadow
    public abstract boolean method_15892(class_3898 var1);

    @Inject(method={"addTicket(JLnet/minecraft/server/world/ChunkTicket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/collection/SortedArraySet;addAndGet(Ljava/lang/Object;)Ljava/lang/Object;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void registerExpiringTicket(long position, class_3228<?> ticket, CallbackInfo ci, class_4706<class_3228<?>> ticketsAtPos, int i) {
        if (CFSettings.optimizedTicketManager && ChunkTicketManager_optimizationMixin.canExpire(ticket)) {
            this.positionWithExpiringTicket.put(position, ticketsAtPos);
        }
    }

    @Inject(method={"removeTicket(JLnet/minecraft/server/world/ChunkTicket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ChunkTicketManager$TicketDistanceLevelPropagator;updateLevel(JIZ)V")})
    private void unregisterExpiringTicket(long pos, class_3228<?> ticket, CallbackInfo ci) {
        class_4706 ticketsAtPos;
        if (CFSettings.optimizedTicketManager && ChunkTicketManager_optimizationMixin.canExpire(ticket) && !ChunkTicketManager_optimizationMixin.canAnyExpire(ticketsAtPos = (class_4706)this.positionWithExpiringTicket.get(pos))) {
            this.positionWithExpiringTicket.remove(pos);
        }
    }

    @Inject(method={"purge()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void purge(CallbackInfo ci) {
        if (CFSettings.optimizedTicketManager) {
            ++this.field_13894;
            ObjectIterator iterator = this.field_13895.long2ObjectEntrySet().fastIterator();
            Predicate<class_3228> predicate = chunkTicket -> chunkTicket.method_20627(this.field_13894);
            this.positionWithExpiringTicket.long2ObjectEntrySet().fastIterator();
            Predicate<class_3228> isExpiredPredicate = chunkTicket -> chunkTicket.method_20627(this.field_13894);
            while (iterator.hasNext()) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
                class_4706 value = (class_4706)entry.getValue();
                class_4706 ticketsAtPos = (class_4706)entry.getValue();
                long pos = entry.getLongKey();
                if (value.removeIf(predicate)) {
                    this.field_18252.method_14027(entry.getLongKey(), ChunkTicketManager_optimizationMixin.method_14046((class_4706)entry.getValue()), false);
                }
                if (!ticketsAtPos.removeIf(isExpiredPredicate)) continue;
                assert (this.field_13895.get(pos) == ticketsAtPos);
                this.field_18252.method_14027(pos, ChunkTicketManager_optimizationMixin.method_14046(ticketsAtPos), false);
                if (!value.isEmpty()) continue;
                iterator.remove();
                if (!ChunkTicketManager_optimizationMixin.canAnyExpire(ticketsAtPos)) {
                    iterator.remove();
                }
                if (!ticketsAtPos.isEmpty()) continue;
                this.field_13895.remove(pos, (Object)ticketsAtPos);
            }
            ci.cancel();
        }
    }
}

