/*
 * Decompiled with CFR 0.152.
 */
package carpetfixes.settings;

import carpet.settings.Condition;
import carpetfixes.helpers.Utils;

public class VersionConditions {

    public static interface hasVersionPredicate {
        public String getPredicate();
    }

    public static class CustomCondition
    implements Condition,
    hasVersionPredicate {
        @Override
        public String getPredicate() {
            return "*";
        }

        public boolean isTrue() {
            return Utils.isMCVersionCompat(this.getPredicate());
        }
    }

    public static class LT_22w03a
    extends CustomCondition {
        @Override
        public String getPredicate() {
            return "<1.18.2-alpha.22.3.a";
        }
    }

    public static class GT_22w04a
    extends CustomCondition {
        @Override
        public String getPredicate() {
            return ">1.18.2-alpha.22.4.a";
        }
    }

    public static class LT_22w05a
    extends CustomCondition {
        @Override
        public String getPredicate() {
            return "<1.18.2-alpha.22.5.a";
        }
    }

    public static class GT_22w05a
    extends CustomCondition {
        @Override
        public String getPredicate() {
            return ">1.18.2-alpha.22.5.a";
        }
    }

    public static class LT_1_18_2_pre1
    extends CustomCondition {
        @Override
        public String getPredicate() {
            return "<1.18.2-pre1";
        }
    }
}

