/*
 * Decompiled with CFR 0.152.
 */
package carpetfixes.testing.tests;

import java.util.ArrayList;
import java.util.stream.Stream;
import mctester.annotation.GameTest;
import mctester.annotation.GameTestTemplate;
import mctester.common.test.creation.GameTestHelper;
import mctester.common.test.creation.TestConfig;
import mctester.common.test.exceptions.GameTestAssertException;
import mctester.common.util.GameTestUtil;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2428;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3499;
import net.minecraft.class_4513;
import net.minecraft.class_4517;

public class TestRuleTemplate {
    @GameTestTemplate(name="default")
    public static Stream<TestConfig> testFromStructure(String structureName) {
        TestConfig testConfig = new TestConfig(TestRuleTemplate::test_rule).structureName(structureName).structurePlaceCooldown(6L).timeout(360);
        return Stream.of(testConfig);
    }

    private static boolean isEarlyTriggerBlock(class_2680 blockState) {
        return blockState.method_27852(class_2246.field_10046);
    }

    private static boolean isFinishedTriggerBlock(class_2680 blockState) {
        return blockState.method_27852(class_2246.field_10383);
    }

    private static boolean isSuccessBlock(class_2680 blockState) {
        return blockState.method_27852(class_2246.field_10028);
    }

    private static boolean isFailureBlock(class_2680 blockState) {
        return blockState.method_27852(class_2246.field_10314);
    }

    private static void onFinish(GameTestHelper helper) {
        GameTestUtil.streamPositions((class_4517)helper.gameTest).forEach(pos -> {
            class_2680 blockState = helper.gameTest.method_22176().method_8320(pos);
            if (TestRuleTemplate.isFinishedTriggerBlock(blockState)) {
                helper.gameTest.method_22176().method_8501(pos, class_2246.field_10002.method_9564());
            }
        });
    }

    @GameTest
    public static void test_rule(GameTestHelper helper) {
        ArrayList successBlocks = new ArrayList();
        ArrayList failureBlocks = new ArrayList();
        GameTestUtil.streamPositions((class_4517)helper.gameTest).forEach(blockPos -> {
            class_2680 blockState = helper.gameTest.method_22176().method_8320(blockPos);
            if (TestRuleTemplate.isSuccessBlock(blockState)) {
                successBlocks.add(blockPos.method_10062());
            }
            if (TestRuleTemplate.isFailureBlock(blockState)) {
                failureBlocks.add(blockPos.method_10062());
            }
        });
        if (successBlocks.isEmpty()) {
            throw new GameTestAssertException("Expected success condition blocks anywhere inside the test. test_rule requires at least 1");
        }
        GameTestUtil.streamPositions((class_4517)helper.gameTest).forEach(blockPos -> {
            class_2680 blockState = helper.gameTest.method_22176().method_8320(blockPos);
            if (TestRuleTemplate.isEarlyTriggerBlock(blockState)) {
                helper.gameTest.method_22176().method_8501(blockPos, class_2246.field_10002.method_9564());
            }
        });
        GameTestUtil.streamPositions((class_4517)helper.gameTest).forEach(blockPos -> {
            class_2680 blockState = helper.gameTest.method_22176().method_8320(blockPos);
            if (blockState.method_27852(class_2246.field_10328)) {
                helper.gameTest.method_22176().method_8501(blockPos, class_2246.field_10002.method_9564());
            }
        });
        helper.succeedWhen(helper1 -> {
            if (helper1.gameTest.method_22180()) {
                return helper1.gameTest.method_22177();
            }
            if (failureBlocks.stream().anyMatch(blockPos -> {
                class_2680 blockState = helper1.gameTest.method_22176().method_8320(blockPos.method_10084());
                return blockState.method_27852(class_2246.field_10179) && (Boolean)blockState.method_11654((class_2769)class_2428.field_11326) != false && TestRuleTemplate.isFailureBlock(helper1.gameTest.method_22176().method_8320(blockPos));
            })) {
                TestRuleTemplate.onFinish(helper);
                class_2338 blockPos2 = helper1.gameTest.method_22172();
                class_2338 absolutePos = (class_2338)successBlocks.get(0);
                class_2338 relativePos = class_3499.method_15168((class_2338)absolutePos, (class_2415)class_2415.field_11302, (class_2470)GameTestUtil.getInverse((class_2470)helper1.gameTest.method_29402()), (class_2338)blockPos2).method_10069(-blockPos2.method_10263(), -blockPos2.method_10264(), -blockPos2.method_10260());
                return false;
            }
            TestRuleTemplate.onFinish(helper);
            return successBlocks.stream().anyMatch(blockPos -> {
                class_2680 blockState = helper1.gameTest.method_22176().method_8320(blockPos.method_10084());
                return blockState.method_27852(class_2246.field_10179) && (Boolean)blockState.method_11654((class_2769)class_2428.field_11326) != false && TestRuleTemplate.isSuccessBlock(helper1.gameTest.method_22176().method_8320(blockPos));
            });
        }, helper1 -> {
            class_2338 blockPos = helper1.gameTest.method_22172();
            class_2338 absolutePos = (class_2338)successBlocks.get(0);
            class_2338 relativePos = class_3499.method_15168((class_2338)absolutePos, (class_2415)class_2415.field_11302, (class_2470)GameTestUtil.getInverse((class_2470)helper1.gameTest.method_29402()), (class_2338)blockPos).method_10069(-blockPos.method_10263(), -blockPos.method_10264(), -blockPos.method_10260());
            TestRuleTemplate.onFinish(helper);
            return new class_4513("Expected powered noteblock on top of a success condition block", absolutePos, relativePos, helper1.currTick);
        });
    }
}

