/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.creaturesofthesnow.entity;

import java.util.Arrays;
import java.util.Comparator;
import net.frozenblock.creaturesofthesnow.registry.RegisterEntities;
import net.frozenblock.creaturesofthesnow.registry.RegisterItems;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1342;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1378;
import net.minecraft.class_1391;
import net.minecraft.class_1393;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1422;
import net.minecraft.class_1429;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class PenguinEntity
extends class_1321 {
    public int life;
    private static final int lifeBeforeBreak = 650;
    private static final double percentage = 48.0;
    private int slidingTicksLeft;
    public static final int BLACK = 0;
    public static final int WHITE = 1;
    public static final int SCARF_WHITE = 0;
    public static final int SCARF_ORANGE = 1;
    public static final int SCARF_MAGENTA = 2;
    public static final int SCARF_LIGHT_BLUE = 3;
    public static final int SCARF_YELLOW = 4;
    public static final int SCARF_LIME = 5;
    public static final int SCARF_PINK = 6;
    public static final int SCARF_GRAY = 7;
    public static final int SCARF_LIGHT_GRAY = 8;
    public static final int SCARF_CYAN = 9;
    public static final int SCARF_PURPLE = 10;
    public static final int SCARF_BLUE = 11;
    public static final int SCARF_BROWN = 12;
    public static final int SCARF_GREEN = 13;
    public static final int SCARF_RED = 14;
    public static final int SCARF_BLACK = 15;
    public static final int EGG_FALSE = 0;
    public static final int EGG_TRUE = 1;
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(PenguinEntity.class, (class_2941)class_2943.field_13327);
    public static final String VARIANT_KEY = "Variant";
    private static final class_2940<Integer> SCARF_VARIANT = class_2945.method_12791(PenguinEntity.class, (class_2941)class_2943.field_13327);
    public static final String SCARF_VARIANT_KEY = "ScarfVariant";
    private static final class_2940<Integer> EGG = class_2945.method_12791(PenguinEntity.class, (class_2941)class_2943.field_13327);
    public static final String EGG_KEY = "Egg";
    private static final double speed = 0.33;

    public PenguinEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createPenguinAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.33).method_26868(class_5134.field_23721, 1.0);
    }

    public boolean method_5675() {
        return false;
    }

    public boolean method_6094() {
        return true;
    }

    public class_1310 method_6046() {
        return class_1310.field_6292;
    }

    public int method_5970() {
        return 100;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1342((class_1314)this));
        this.field_6201.method_6277(1, (class_1352)new class_1393((class_1314)this));
        this.field_6201.method_6277(2, (class_1352)new class_1378((class_1314)this, 1.0, 10));
        this.field_6201.method_6277(3, (class_1352)new class_1374((class_1314)this, 0.66));
        this.field_6201.method_6277(4, (class_1352)new class_1341((class_1429)this, 0.33));
        this.field_6201.method_6277(5, (class_1352)new class_1391((class_1314)this, 0.41250000000000003, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8846}), false));
        this.field_6201.method_6277(6, (class_1352)new class_1353((class_1429)this, 0.41250000000000003));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 0.33));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(9, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(10, (class_1352)new class_1400((class_1308)this, class_1422.class, 10, true, true, null));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)0);
        this.field_6011.method_12784(SCARF_VARIANT, (Object)0);
        this.field_6011.method_12784(EGG, (Object)0);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569(VARIANT_KEY, this.getVariant().getId());
        nbt.method_10569(SCARF_VARIANT_KEY, this.getScarfVariant().getId());
        nbt.method_10569(EGG_KEY, this.getEgg().getId());
    }

    public void method_5958() {
        double CHANCE = 0.003;
        if (Math.random() * 70.0 < CHANCE) {
            this.method_5706((class_1935)RegisterItems.PENGUIN_FEATHER);
        }
        if (this.getEgg() == Egg.TRUE) {
            ++this.life;
            if (this.life > 13000 && Math.random() < 0.48) {
                this.setEgg(Egg.FALSE);
                class_1296 passiveEntity = (class_1296)RegisterEntities.PENGUIN.method_5883(this.method_5770());
                passiveEntity.method_7217(true);
                passiveEntity.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), 0.0f, 0.0f);
                this.method_5770().method_8649((class_1297)passiveEntity);
            }
        } else {
            this.life = 0;
        }
        super.method_5958();
    }

    public void method_6007() {
        if (this.slidingTicksLeft > 0) {
            --this.slidingTicksLeft;
        }
        if ((this.method_5770().method_8320(this.method_24515().method_10074()) == class_2246.field_10384.method_9564() || this.method_5770().method_8320(this.method_24515().method_10074()) == class_2246.field_10225.method_9564() || this.method_5770().method_8320(this.method_24515().method_10074()) == class_2246.field_10295.method_9564()) && Math.random() < 0.002 && this.getEgg() == Egg.FALSE) {
            double angle = Math.random() * 360.0;
            double radius = 0.6;
            this.method_36456((float)angle);
            this.slidingTicksLeft = 15;
            this.field_6002.method_8421((class_1297)this, (byte)1);
            this.method_5724(0.9f, new class_243(-Math.sin(angle) * radius, 0.0, -Math.cos(angle) * radius));
            this.method_5988().method_19615(new class_243(-Math.sin(angle) * radius, 0.0, -Math.cos(angle) * radius));
        }
        super.method_6007();
    }

    public Variant getVariant() {
        return Variant.VARIANTS[(Integer)this.field_6011.method_12789(VARIANT)];
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    public ScarfVariant getScarfVariant() {
        return ScarfVariant.SCARF_VARIANTS[(Integer)this.field_6011.method_12789(SCARF_VARIANT)];
    }

    public void setScarfVariant(ScarfVariant variant) {
        this.field_6011.method_12778(SCARF_VARIANT, (Object)variant.getId());
    }

    public Egg getEgg() {
        return Egg.EGGS[(Integer)this.field_6011.method_12789(EGG)];
    }

    public void setEgg(Egg egg) {
        this.field_6011.method_12778(EGG, (Object)egg.getId());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(Variant.VARIANTS[nbt.method_10550(VARIANT_KEY)]);
        this.setScarfVariant(ScarfVariant.SCARF_VARIANTS[nbt.method_10550(SCARF_VARIANT_KEY)]);
        this.setEgg(Egg.EGGS[nbt.method_10550(EGG_KEY)]);
    }

    public double getSliding() {
        return this.slidingTicksLeft;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        this.setEgg(Egg.TRUE);
        return null;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        super.method_5992(player, hand);
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7929(class_1802.field_8846.method_7854())) {
            int i = this.method_5618();
            if (!this.field_6002.field_9236 && i == 0 && this.method_6482()) {
                this.method_6475(player, hand, itemStack);
                this.method_6480(player);
                this.method_33569(class_5712.field_28725, this.method_33575());
                return class_1269.field_5812;
            }
            if (this.method_6109()) {
                this.method_6475(player, hand, itemStack);
                this.method_5620((int)((float)(-i / 20) * 0.1f), true);
                this.method_33569(class_5712.field_28725, this.method_33575());
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            if (this.field_6002.field_9236) {
                return class_1269.field_21466;
            }
            return class_1269.field_5811;
        }
        if (this.method_6181()) {
            if (player == this.method_6177()) {
                if (this.colorScarf(itemStack)) {
                    return class_1269.field_5812;
                }
                return class_1269.field_5811;
            }
            return class_1269.field_5811;
        }
        if (itemStack.method_7929(class_1802.field_8429.method_7854())) {
            double x = this.method_23317();
            double y = this.method_23318();
            double z = this.method_23321();
            if (Math.random() < 0.3) {
                this.field_6002.method_8406((class_2394)class_2398.field_11201, x, y, z, 2.0, 2.0, 2.0);
                if (Math.random() <= 0.3) {
                    this.setScarfVariant(ScarfVariant.WHITE);
                } else if (Math.random() > 0.5) {
                    this.setScarfVariant(ScarfVariant.RED);
                } else {
                    this.setScarfVariant(ScarfVariant.BLUE);
                }
                this.method_6170(player);
                return class_1269.field_5812;
            }
            this.field_6002.method_8406((class_2394)class_2398.field_11237, x, y, z, 0.5, 0.5, 0.5);
            return class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    private boolean colorScarf(class_1799 itemStack) {
        boolean exit = true;
        if (itemStack.method_7929(class_1802.field_8446.method_7854())) {
            this.setScarfVariant(ScarfVariant.WHITE);
        } else if (itemStack.method_7929(class_1802.field_8492.method_7854())) {
            this.setScarfVariant(ScarfVariant.ORANGE);
        } else if (itemStack.method_7929(class_1802.field_8669.method_7854())) {
            this.setScarfVariant(ScarfVariant.MAGENTA);
        } else if (itemStack.method_7929(class_1802.field_8273.method_7854())) {
            this.setScarfVariant(ScarfVariant.LIGHT_BLUE);
        } else if (itemStack.method_7929(class_1802.field_8192.method_7854())) {
            this.setScarfVariant(ScarfVariant.YELLOW);
        } else if (itemStack.method_7929(class_1802.field_8131.method_7854())) {
            this.setScarfVariant(ScarfVariant.LIME);
        } else if (itemStack.method_7929(class_1802.field_8330.method_7854())) {
            this.setScarfVariant(ScarfVariant.PINK);
        } else if (itemStack.method_7929(class_1802.field_8298.method_7854())) {
            this.setScarfVariant(ScarfVariant.GRAY);
        } else if (itemStack.method_7929(class_1802.field_8851.method_7854())) {
            this.setScarfVariant(ScarfVariant.LIGHT_GRAY);
        } else if (itemStack.method_7929(class_1802.field_8632.method_7854())) {
            this.setScarfVariant(ScarfVariant.CYAN);
        } else if (itemStack.method_7929(class_1802.field_8296.method_7854())) {
            this.setScarfVariant(ScarfVariant.PURPLE);
        } else if (itemStack.method_7929(class_1802.field_8345.method_7854())) {
            this.setScarfVariant(ScarfVariant.BLUE);
        } else if (itemStack.method_7929(class_1802.field_8099.method_7854())) {
            this.setScarfVariant(ScarfVariant.BROWN);
        } else if (itemStack.method_7929(class_1802.field_8408.method_7854())) {
            this.setScarfVariant(ScarfVariant.GREEN);
        } else if (itemStack.method_7929(class_1802.field_8264.method_7854())) {
            this.setScarfVariant(ScarfVariant.RED);
        } else if (itemStack.method_7929(class_1802.field_8226.method_7854())) {
            this.setScarfVariant(ScarfVariant.BLACK);
        } else {
            exit = false;
        }
        return exit;
    }

    public class_3414 method_5994() {
        return class_3417.field_28290;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15077;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15234;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        if (Math.random() > 0.5) {
            this.setVariant(Variant.WILD_ONE);
        } else if (Math.random() > 0.3) {
            this.setVariant(Variant.WILD_TWO);
        }
        this.setEgg(Egg.FALSE);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public void method_5711(byte status) {
        if (status == 1) {
            this.slidingTicksLeft = 10;
        }
    }

    public static enum Variant {
        WILD_ONE(0, "black", false),
        WILD_TWO(1, "white", false);

        public static final Variant[] VARIANTS;
        private final int id;
        private final String name;
        private final boolean natural;

        private Variant(int id, String name, boolean natural) {
            this.id = id;
            this.name = name;
            this.natural = natural;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        static {
            VARIANTS = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }

    public static enum ScarfVariant {
        WHITE(0, "white_scarf", false),
        ORANGE(1, "orange_scarf", false),
        MAGENTA(2, "magenta_scarf", false),
        LIGHT_BLUE(3, "light_blue_scarf", false),
        YELLOW(4, "yellow_scarf", false),
        LIME(5, "lime_scarf", false),
        PINK(6, "pink_scarf", false),
        GRAY(7, "gray_scarf", false),
        LIGHT_GRAY(8, "light_gray_scarf", false),
        CYAN(9, "cyan_scarf", false),
        PURPLE(10, "purple_scarf", false),
        BLUE(11, "blue_scarf", false),
        BROWN(12, "brown_scarf", false),
        GREEN(13, "green_scarf", false),
        RED(14, "red_scarf", false),
        BLACK(15, "black_scarf", false);

        public static final ScarfVariant[] SCARF_VARIANTS;
        private final int id;
        private final String name;
        private final boolean natural;

        private ScarfVariant(int id, String name, boolean natural) {
            this.id = id;
            this.name = name;
            this.natural = natural;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        static {
            SCARF_VARIANTS = (ScarfVariant[])Arrays.stream(ScarfVariant.values()).sorted(Comparator.comparingInt(ScarfVariant::getId)).toArray(ScarfVariant[]::new);
        }
    }

    public static enum Egg {
        FALSE(0, "false", false),
        TRUE(1, "true", false);

        public static final Egg[] EGGS;
        private final int id;
        private final String name;
        private final boolean natural;

        private Egg(int id, String name, boolean natural) {
            this.id = id;
            this.name = name;
            this.natural = natural;
        }

        public int getId() {
            return this.id;
        }

        static {
            EGGS = (Egg[])Arrays.stream(Egg.values()).sorted(Comparator.comparingInt(Egg::getId)).toArray(Egg[]::new);
        }
    }
}

