/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.gui;

import java.io.IOException;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.server.block.entity.IncubatorBlockEntity;
import org.jurassicraft.server.container.IncubatorContainer;
import org.jurassicraft.server.message.ChangeTemperatureMessage;

@SideOnly(value=Side.CLIENT)
public class IncubatorGui
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("jurassicraft:textures/gui/incubator.png");
    private final InventoryPlayer playerInventory;
    private final IncubatorBlockEntity incubator;

    public IncubatorGui(InventoryPlayer playerInv, IncubatorBlockEntity incubator) {
        super((Container)new IncubatorContainer(playerInv, (TileEntity)incubator));
        this.playerInventory = playerInv;
        this.incubator = incubator;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.dragTemperatureSlider(mouseX, mouseY);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.dragTemperatureSlider(mouseX, mouseY);
    }

    private void dragTemperatureSlider(int mouseX, int mouseY) {
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        for (int i = 0; i < 5; ++i) {
            int x = 0;
            int y = 0;
            switch (i) {
                case 0: {
                    x = 33;
                    y = 28;
                    break;
                }
                case 1: {
                    x = 56;
                    y = 21;
                    break;
                }
                case 2: {
                    x = 79;
                    y = 14;
                    break;
                }
                case 3: {
                    x = 102;
                    y = 21;
                    break;
                }
                case 4: {
                    x = 125;
                    y = 28;
                }
            }
            if (mouseX <= (x += k - 2) || mouseY <= (y += 18 + l) || mouseX >= x + 21 || mouseY >= y + 5) continue;
            int temp = (mouseX - x + 1) * 4;
            if (temp == this.incubator.func_174887_a_(i + 10)) break;
            this.incubator.func_174885_b(i + 10, temp);
            JurassiCraft.NETWORK_WRAPPER.sendToServer((IMessage)new ChangeTemperatureMessage(this.incubator.func_174877_v(), i, temp, this.incubator.func_145831_w().field_73011_w.getDimension()));
            break;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String name = this.incubator.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 4, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int i = 0; i < 5; ++i) {
            int progress = this.getProgress(i, 14);
            int x = 0;
            int y = 0;
            switch (i) {
                case 0: {
                    x = 33;
                    y = 28;
                    break;
                }
                case 1: {
                    x = 56;
                    y = 21;
                    break;
                }
                case 2: {
                    x = 79;
                    y = 14;
                    break;
                }
                case 3: {
                    x = 102;
                    y = 21;
                    break;
                }
                case 4: {
                    x = 125;
                    y = 28;
                }
            }
            this.func_73729_b(k + ++x, l + (y += 24), 176, 5, progress, 5);
            int temp = this.getTemperature(i, 20);
            this.func_73729_b(k + x + temp - 3, l + y - 6, 176, 0, 3, 5);
        }
    }

    private int getProgress(int slot, int scale) {
        int j = this.incubator.func_174887_a_(slot);
        int k = this.incubator.func_174887_a_(slot + 5);
        return k != 0 && j != 0 ? j * scale / k : 0;
    }

    private int getTemperature(int slot, int scale) {
        int j = this.incubator.func_174887_a_(slot + 10);
        int k = 100;
        return j != 0 ? j * scale / k : 0;
    }
}

