/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.message.PlacePaddockSignMessage;
import org.lwjgl.opengl.GL11;

public class SelectDinoGui
extends GuiScreen {
    private final Map<Integer, ResourceLocation> TEXTURES = new HashMap<Integer, ResourceLocation>();
    public int columnsPerPage = 5;
    public int rowsPerPage = 3;
    private int page;
    private int pageCount;
    private GuiButton forward;
    private GuiButton backward;
    private final BlockPos pos;
    private final EnumFacing facing;
    private final EnumHand hand;
    private List<Dinosaur> dinosaurs;

    public SelectDinoGui(BlockPos pos, EnumFacing facing, EnumHand hand) {
        this.pos = pos;
        this.facing = facing;
        this.hand = hand;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiButton(0, (this.field_146294_l - 150) / 2, this.field_146295_m / 5 + 150, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.backward = new GuiButton(1, this.field_146294_l / 2 - 105, this.field_146295_m / 5 + 150, 20, 20, "<");
        this.field_146292_n.add(this.backward);
        this.forward = new GuiButton(2, this.field_146294_l / 2 + 85, this.field_146295_m / 5 + 150, 20, 20, ">");
        this.field_146292_n.add(this.forward);
        this.page = 0;
        this.dinosaurs = new ArrayList<Dinosaur>(EntityHandler.getRegisteredDinosaurs());
        Collections.sort(this.dinosaurs);
        this.pageCount = this.dinosaurs.size() / (this.columnsPerPage * this.rowsPerPage);
        this.enableDisablePages();
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (state == 0) {
            int signsPerPage = this.columnsPerPage * this.rowsPerPage;
            int xOffset = 0;
            int yOffset = 0;
            this.pageCount = this.dinosaurs.size() / signsPerPage;
            for (int i = 0; i < this.dinosaurs.size(); ++i) {
                if (i < signsPerPage * this.page || i >= signsPerPage * (this.page + 1)) continue;
                float scale = 3.0f;
                int x = (int)((float)(this.field_146294_l / 2 - 140 + xOffset) / scale);
                int y = (int)((float)(this.field_146295_m / 8 + yOffset - 20) / scale);
                float scaledMouseX = (float)mouseX / scale;
                float scaledMouseY = (float)mouseY / scale;
                if (scaledMouseX > (float)x && scaledMouseY > (float)y && scaledMouseX < (float)(x + 16) && scaledMouseY < (float)(y + 16)) {
                    this.selectDinosaur(this.dinosaurs.get(i));
                    break;
                }
                xOffset = (int)((float)xOffset + 180.0f / scale);
                if (i % this.columnsPerPage < this.columnsPerPage - 1) continue;
                xOffset = 0;
                yOffset = (int)((float)yOffset + 180.0f / scale);
            }
        }
    }

    public void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 1) {
            if (this.page > 0) {
                --this.page;
            }
        } else if (id == 2) {
            if (this.page < this.pageCount) {
                ++this.page;
            }
        } else {
            this.field_146297_k.func_147108_a(null);
        }
        this.enableDisablePages();
    }

    public void enableDisablePages() {
        this.backward.field_146124_l = this.page > 0;
        this.forward.field_146124_l = this.page < this.pageCount;
    }

    public void selectDinosaur(Dinosaur dinosaur) {
        this.field_146297_k.func_147108_a(null);
        if (!this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
            InventoryPlayer inventory = this.field_146297_k.field_71439_g.field_71071_by;
            inventory.func_70298_a(inventory.field_70461_c, 1);
        }
        JurassiCraft.NETWORK_WRAPPER.sendToServer((IMessage)new PlacePaddockSignMessage(this.hand, this.facing, this.pos, dinosaur));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int signsPerPage = this.columnsPerPage * this.rowsPerPage;
        int xOffset = 0;
        int yOffset = 0;
        this.pageCount = this.dinosaurs.size() / signsPerPage;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = 0;
        for (Dinosaur dinosaur : this.dinosaurs) {
            if (i >= signsPerPage * this.page && i < signsPerPage * (this.page + 1)) {
                int id = EntityHandler.getDinosaurId(dinosaur);
                GlStateManager.func_179094_E();
                ResourceLocation texture = this.TEXTURES.get(id);
                if (texture == null) {
                    ResourceLocation identifier = dinosaur.getIdentifier();
                    texture = new ResourceLocation(identifier.func_110624_b(), "textures/paddock/" + identifier.func_110623_a() + ".png");
                    this.TEXTURES.put(id, texture);
                }
                this.field_146297_k.func_110434_K().func_110577_a(texture);
                float scale = 3.0f;
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                int x = (int)((float)(this.field_146294_l / 2 - 140 + xOffset) / scale);
                int y = (int)((float)(this.field_146295_m / 8 + yOffset - 20) / scale);
                float scaledMouseX = (float)mouseX / scale;
                float scaledMouseY = (float)mouseY / scale;
                if (scaledMouseX > (float)x && scaledMouseY > (float)y && scaledMouseX < (float)(x + 16) && scaledMouseY < (float)(y + 16)) {
                    this.drawBoxOutline(x - 1, y - 1, 18, 17, 1, 0x60606060);
                }
                this.drawTexturedModalRect(x, y, 0, 0, 16, 16, 16, 16);
                float textScale = 0.22f;
                GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)textScale);
                this.func_73732_a(this.field_146297_k.field_71466_p, dinosaur.getLocalizedName(), (int)((float)(x + 8) / textScale), (int)((float)(y + 17) / textScale), 0xFFFFFF);
                GlStateManager.func_179121_F();
                xOffset = (int)((float)xOffset + 180.0f / scale);
                if (i % this.columnsPerPage >= this.columnsPerPage - 1) {
                    xOffset = 0;
                    yOffset = (int)((float)yOffset + 180.0f / scale);
                }
            }
            ++i;
        }
    }

    public void drawScaledRect(int x, int y, int width, int height, int colour) {
        GL11.glDisable((int)3553);
        float red = (float)(colour >> 24 & 0xFF) / 255.0f;
        float green = (float)(colour >> 16 & 0xFF) / 255.0f;
        float blue = (float)(colour >> 8 & 0xFF) / 255.0f;
        float a = (float)(colour & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)a);
        float f = 1.0f / (float)width;
        float f1 = 1.0f / (float)height;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a(0.0, (double)((float)height * f1)).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)width * f), (double)((float)height * f1)).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a((double)((float)width * f), 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }

    public void drawBoxOutline(int x, int y, int sizeX, int sizeY, int borderSize, int colour) {
        this.drawScaledRect(x, y, sizeX, borderSize, colour);
        this.drawScaledRect(x + sizeX, y, borderSize, sizeY + borderSize, colour);
        this.drawScaledRect(x, y + borderSize, borderSize, sizeY, colour);
        this.drawScaledRect(x + borderSize, y + sizeY, sizeX - borderSize, borderSize, colour);
    }

    public void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height, int textureWidth, int textureHeight) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a((double)(textureX / textureWidth), (double)((textureY + height) / textureHeight)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((textureX + width) / textureWidth), (double)((textureY + height) / textureHeight)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a((double)((textureX + width) / textureWidth), (double)(textureY / textureHeight)).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a((double)(textureX / width), (double)(textureY / textureHeight)).func_181675_d();
        tessellator.func_78381_a();
    }

    public boolean func_73868_f() {
        return false;
    }
}

