/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.model;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.ilexiconn.llibrary.client.model.tabula.ITabulaModelAnimator;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaModelContainer;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.client.model.FixedTabulaModel;
import org.jurassicraft.server.api.Animatable;
import org.jurassicraft.server.entity.AnimalMetadata;

@SideOnly(value=Side.CLIENT)
public class AnimatableModel
extends FixedTabulaModel {
    public AnimatableModel(TabulaModelContainer model, AnimalMetadata animal, ITabulaModelAnimator animator) {
        super(model, animal, animator);
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float rotation, float rotationYaw, float rotationPitch, float partialTicks, Entity entity) {
        Animatable animatable = (Animatable)entity;
        if (animatable.isCarcass()) {
            this.setMovementScale(0.0f);
        } else {
            this.setMovementScale(animatable.isSleeping() ? 0.5f : 1.0f);
        }
        super.func_78087_a(limbSwing, limbSwingAmount, rotation, rotationYaw, rotationPitch, partialTicks, entity);
    }

    public String[] getCubeIdentifierArray() {
        String[] cubeIdentifiers = new String[this.identifierMap.size()];
        int index = 0;
        Set identifiers = this.identifierMap.keySet();
        Iterator iterator = identifiers.iterator();
        while (iterator.hasNext()) {
            String identifier;
            cubeIdentifiers[index] = identifier = (String)iterator.next();
            ++index;
        }
        return cubeIdentifiers;
    }

    public String[] getCubeNames() {
        String[] cubeNames = new String[this.cubes.size()];
        int index = 0;
        Set names = this.cubes.keySet();
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            String identifier;
            cubeNames[index] = identifier = (String)iterator.next();
            ++index;
        }
        return cubeNames;
    }

    public Map<String, AdvancedModelRenderer> getIdentifierCubes() {
        return this.identifierMap;
    }

    public void faceTarget(float yaw, float pitch, float rotationDivisor, AdvancedModelRenderer ... boxes) {
        float actualRotationDivisor = rotationDivisor * (float)boxes.length;
        float yawAmount = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)yaw), (float)-45.0f, (float)45.0f) / 57.295776f / actualRotationDivisor;
        float pitchAmount = MathHelper.func_76142_g((float)pitch) / 57.295776f / actualRotationDivisor;
        for (AdvancedModelRenderer box : boxes) {
            box.field_78796_g += yawAmount;
            box.field_78795_f += pitchAmount;
        }
    }
}

