/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.model.animation;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.ilexiconn.llibrary.server.animation.Animation;
import org.jurassicraft.server.entity.dinosaur.DryosaurusEntity;
import org.jurassicraft.server.entity.dinosaur.MetriacanthosaurusEntity;
import org.jurassicraft.server.entity.dinosaur.StegosaurusEntity;
import org.jurassicraft.server.entity.dinosaur.TyrannosaurusEntity;

public enum EntityAnimation {
    IDLE(false, false, false),
    ATTACKING(false, false, new IdentifierContainer(StegosaurusEntity.class, 1)),
    INJURED(false, false),
    HEAD_COCKING,
    CALLING,
    HISSING,
    POUNCING(false, false),
    SNIFFING,
    EATING,
    DRINKING,
    MATING(false, false),
    SLEEPING(true, false),
    RESTING(true, true),
    ROARING(new IdentifierContainer(TyrannosaurusEntity.class, 2), new IdentifierContainer(MetriacanthosaurusEntity.class, 1)),
    SPEAK(false, false),
    LOOKING_LEFT,
    LOOKING_RIGHT,
    LOOKING_BACK,
    BEGGING,
    SNAP,
    DYING(true, false, false),
    SCRATCHING,
    SPITTING,
    PECKING,
    PREENING,
    TAIL_DISPLAY,
    REARING_UP,
    SENTRY,
    LAYING_EGG,
    GIVING_BIRTH,
    TOE_TAP,
    GLIDING(true, false, true),
    ON_LAND(false, true, false),
    HOPPING(false, false, false),
    WALKING(false, false, false, new IdentifierContainer(DryosaurusEntity.class, 1)),
    RUNNING(false, false, false),
    SWIMMING(false, false, false),
    FLYING(false, false, false),
    CLIMBING(false, false, false),
    PREPARE_LEAP(false, false),
    LEAP(true, false),
    LEAP_LAND(true, false, false),
    START_CLIMBING(false, false),
    DILOPHOSAURUS_SPIT(false, false);

    private Animation animation;
    private final boolean hold;
    private final boolean doesBlockMovement;
    private final boolean useInertia;
    private final Map<Class, Integer> variants;

    private EntityAnimation(boolean hold, boolean blockMovement, IdentifierContainer ... variants) {
        this(hold, blockMovement, true, variants);
    }

    private EntityAnimation(boolean hold, boolean blockMovement) {
        this(hold, blockMovement, true, new IdentifierContainer[0]);
    }

    private EntityAnimation(boolean hold, boolean blockMovement, boolean useInertia) {
        this(hold, blockMovement, useInertia, new IdentifierContainer[0]);
    }

    private EntityAnimation(boolean hold, boolean blockMovement, boolean useInertia, IdentifierContainer ... variants) {
        this.hold = hold;
        this.doesBlockMovement = blockMovement;
        this.useInertia = useInertia;
        this.variants = Arrays.stream(variants).collect(Collectors.toMap(IdentifierContainer::getName, IdentifierContainer::getVariant));
    }

    private EntityAnimation(IdentifierContainer ... variants) {
        this(false, true, variants);
    }

    private EntityAnimation() {
        this(false, true, new IdentifierContainer[0]);
    }

    public static Animation[] getAnimations() {
        Animation[] animations = new Animation[EntityAnimation.values().length];
        for (int i = 0; i < animations.length; ++i) {
            animations[i] = EntityAnimation.values()[i].get();
        }
        return animations;
    }

    public static EntityAnimation getAnimation(Animation animation) {
        for (EntityAnimation animations : EntityAnimation.values()) {
            if (!animation.equals(animations.animation)) continue;
            return animations;
        }
        return IDLE;
    }

    public Animation get() {
        if (this.animation == null) {
            this.animation = Animation.create((int)-1);
        }
        return this.animation;
    }

    public boolean shouldHold() {
        return this.hold;
    }

    public boolean hasVariants(Class name) {
        return this.variants.containsKey(name) && this.variants.get(name) > 0;
    }

    public int getVariants(Class name) {
        return this.variants.getOrDefault(name, 0);
    }

    public boolean doesBlockMovement() {
        return this.doesBlockMovement;
    }

    public boolean useInertia() {
        return this.useInertia;
    }

    private static class IdentifierContainer {
        private final Class name;
        private final int variants;

        public IdentifierContainer(Class name, int variants) {
            this.name = name;
            this.variants = variants;
        }

        public Class getName() {
            return this.name;
        }

        public int getVariant() {
            return this.variants;
        }
    }
}

