/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.model.animation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.model.AnimatableModel;
import org.jurassicraft.client.model.animation.EntityAnimation;
import org.jurassicraft.client.model.animation.JabelarAnimationHandler;
import org.jurassicraft.client.model.animation.PosedCuboid;
import org.jurassicraft.client.model.animation.dto.AnimatableRenderDefDTO;
import org.jurassicraft.client.model.animation.dto.AnimationsDTO;
import org.jurassicraft.client.model.animation.dto.PoseDTO;
import org.jurassicraft.client.model.animation.dto.VariantDTO;
import org.jurassicraft.server.api.Animatable;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.AnimalMetadata;
import org.jurassicraft.server.entity.GrowthStage;
import org.jurassicraft.server.tabula.TabulaModelHelper;

public class PoseHandler<ENTITY extends EntityLivingBase> {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(AnimatableRenderDefDTO.class, (Object)new AnimatableRenderDefDTO.AnimatableDeserializer()).create();
    private final AnimalMetadata metadata;
    private Map<GrowthStage, ModelData> modelData = new EnumMap<GrowthStage, ModelData>(GrowthStage.class);

    public PoseHandler(Dinosaur dinosaur) {
        this(dinosaur.getIdentifier(), dinosaur.getSupportedStages(), dinosaur.getMetadata());
    }

    public PoseHandler(ResourceLocation identifier, List<GrowthStage> supported, AnimalMetadata meta) {
        this.metadata = meta;
        this.modelData = new EnumMap<GrowthStage, ModelData>(GrowthStage.class);
        ResourceLocation entityResource = new ResourceLocation(identifier.func_110624_b(), "models/entities/" + identifier.func_110623_a());
        for (GrowthStage growth : GrowthStage.values()) {
            try {
                GrowthStage actualGrowth = growth;
                if (!supported.contains((Object)actualGrowth)) {
                    actualGrowth = GrowthStage.ADULT;
                }
                if (this.modelData.containsKey((Object)actualGrowth)) {
                    this.modelData.put(growth, this.modelData.get((Object)actualGrowth));
                    continue;
                }
                ModelData loaded = this.loadModelData(identifier, entityResource, actualGrowth);
                this.modelData.put(growth, loaded);
                if (actualGrowth == growth) continue;
                this.modelData.put(actualGrowth, loaded);
            }
            catch (Exception e) {
                JurassiCraft.getLogger().fatal("Failed to parse growth stage " + (Object)((Object)growth) + " for dinosaur " + identifier, (Throwable)e);
                this.modelData.put(growth, new ModelData());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ModelData loadModelData(ResourceLocation identifier, ResourceLocation origin, GrowthStage growth) {
        String namespace = origin.func_110624_b();
        String name = identifier.func_110623_a();
        ResourceLocation stageOrigin = new ResourceLocation(namespace, origin.func_110623_a() + "/" + growth.getKey());
        ResourceLocation definition = new ResourceLocation(namespace, stageOrigin.func_110623_a() + "/" + name + "_" + growth.getKey() + ".json");
        try (InputStream modelStream = TabulaModelHelper.class.getResourceAsStream("/assets/" + definition.func_110624_b() + "/" + definition.func_110623_a());){
            if (modelStream == null) {
                throw new IllegalArgumentException("No model definition for the dino " + identifier + " with grow-state " + (Object)((Object)growth) + " exists. Expected at " + definition);
            }
            InputStreamReader reader = new InputStreamReader(modelStream);
            AnimationsDTO rawAnimations = (AnimationsDTO)GSON.fromJson((Reader)reader, AnimationsDTO.class);
            ModelData data = this.loadModelData(stageOrigin, rawAnimations);
            JurassiCraft.getLogger().debug("Successfully loaded " + identifier + "(" + (Object)((Object)growth) + ") from " + definition);
            ((Reader)reader).close();
            ModelData modelData = data;
            return modelData;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ModelData loadModelData(ResourceLocation origin, AnimationsDTO animationsDefinition) {
        if (animationsDefinition == null || animationsDefinition.poses == null || animationsDefinition.poses.get(EntityAnimation.IDLE.name()) == null || animationsDefinition.poses.get((Object)EntityAnimation.IDLE.name()).variants == null || animationsDefinition.poses.get((Object)EntityAnimation.IDLE.name()).variants.size() == 0 || animationsDefinition.poses.get((Object)EntityAnimation.IDLE.name()).variants.get("0") == null || animationsDefinition.poses.get((Object)EntityAnimation.IDLE.name()).variants.get("0").length == 0) {
            throw new IllegalArgumentException("Animation files must define at least one variant and pose for the IDLE animation");
        }
        ArrayList<ResourceLocation> posedModelResources = new ArrayList<ResourceLocation>();
        for (Map.Entry<String, VariantDTO> variants : animationsDefinition.poses.entrySet()) {
            if (variants == null) continue;
            for (Map.Entry<String, Object> entry : variants.getValue().variants.entrySet()) {
                if (entry == null) continue;
                for (PoseDTO pose : (PoseDTO[])entry.getValue()) {
                    if (pose == null) continue;
                    if (pose.pose == null) {
                        throw new IllegalArgumentException("Every pose must define a pose file");
                    }
                    ResourceLocation resolvedRes = new ResourceLocation(origin.func_110624_b(), origin.func_110623_a() + "/" + pose.pose);
                    int index = posedModelResources.indexOf(resolvedRes);
                    if (index == -1) {
                        pose.index = posedModelResources.size();
                        posedModelResources.add(resolvedRes);
                        continue;
                    }
                    pose.index = index;
                }
            }
        }
        HashMap<Animation, float[][][]> animations = new HashMap<Animation, float[][][]>();
        HashMap<Animation, byte[]> poseCount = new HashMap<Animation, byte[]>();
        for (Map.Entry<String, Object> entry : animationsDefinition.poses.entrySet()) {
            int length = 0;
            for (Map.Entry<String, PoseDTO[]> posesList : ((VariantDTO)entry.getValue()).variants.entrySet()) {
                PoseDTO[] poses = posesList.getValue();
                if (length >= poses.length) continue;
                length = poses.length;
            }
            for (Map.Entry<String, PoseDTO[]> posesList : ((VariantDTO)entry.getValue()).variants.entrySet()) {
                Animation animation = EntityAnimation.valueOf(entry.getKey()).get();
                PoseDTO[] poses = posesList.getValue();
                float[][][] poseSequence = (float[][][])animations.get(animation);
                byte[] counts = (byte[])poseCount.get(animation);
                if (poseSequence == null) {
                    poseSequence = new float[((VariantDTO)entry.getValue()).variants.size()][length][2];
                    counts = new byte[((VariantDTO)entry.getValue()).variants.size()];
                }
                counts[Integer.parseInt((String)posesList.getKey())] = (byte)poses.length;
                poseCount.put(animation, counts);
                for (int i = 0; i < poses.length; ++i) {
                    poseSequence[Integer.parseInt((String)posesList.getKey())][i][0] = poses[i].index;
                    poseSequence[Integer.parseInt((String)posesList.getKey())][i][1] = poses[i].time;
                }
                animations.put(animation, poseSequence);
            }
        }
        if (FMLCommonHandler.instance().getSide().isClient()) {
            return this.loadModelDataClient(posedModelResources, animations, poseCount);
        }
        return new ModelData(animations, poseCount);
    }

    @SideOnly(value=Side.CLIENT)
    private ModelData loadModelDataClient(List<ResourceLocation> posedModelResources, Map<Animation, float[][][]> animations, Map<Animation, byte[]> poseCount) {
        PosedCuboid[][] posedCuboids = new PosedCuboid[posedModelResources.size()][];
        AnimatableModel mainModel = JabelarAnimationHandler.loadModel(posedModelResources.get(0), this.metadata);
        if (mainModel == null) {
            throw new IllegalArgumentException("Couldn't load the model from " + posedModelResources.get(0));
        }
        String[] identifiers = mainModel.getCubeIdentifierArray();
        int partCount = identifiers.length;
        for (int i = 0; i < posedModelResources.size(); ++i) {
            ResourceLocation resource = posedModelResources.get(i);
            AnimatableModel model = JabelarAnimationHandler.loadModel(resource, this.metadata);
            if (model == null) {
                throw new IllegalArgumentException("Couldn't load the model from " + resource);
            }
            PosedCuboid[] pose = new PosedCuboid[partCount];
            for (int partIndex = 0; partIndex < partCount; ++partIndex) {
                String identifier = identifiers[partIndex];
                AdvancedModelRenderer cube = model.getCubeByIdentifier(identifier);
                if (cube == null) {
                    AdvancedModelRenderer mainCube = mainModel.getCubeByIdentifier(identifier);
                    JurassiCraft.getLogger().error("Could not retrieve cube " + identifier + " (" + mainCube.field_78802_n + ", " + partIndex + ") from the model " + resource + " (We're aware of this problem!)");
                    pose[partIndex] = new PosedCuboid(mainCube);
                    continue;
                }
                pose[partIndex] = new PosedCuboid(cube);
            }
            posedCuboids[i] = pose;
        }
        return new ModelData(posedCuboids, animations, poseCount);
    }

    @SideOnly(value=Side.CLIENT)
    public JabelarAnimationHandler<ENTITY> createAnimationHandler(ENTITY entity, AnimatableModel model, GrowthStage growthStage, boolean useInertialTweens) {
        ModelData growthModel = this.modelData.get((Object)growthStage);
        if (!((Animatable)entity).canUseGrowthStage(growthStage)) {
            growthModel = this.modelData.get((Object)growthStage);
        }
        return new JabelarAnimationHandler<ENTITY>(entity, model, growthModel.poses, growthModel.animations, growthModel.poseCount, useInertialTweens);
    }

    public Map<Animation, float[][][]> getAnimations(GrowthStage growthStage) {
        return this.modelData.get((Object)((Object)growthStage)).animations;
    }

    public float getAnimationLength(Animation animation, GrowthStage growthStage, byte variant) {
        Map<Animation, float[][][]> animations = this.getAnimations(growthStage);
        float duration = 0.0f;
        if (animation != null && animations.get(animation) != null && animations.get(animation)[variant] != null) {
            for (float[] pose : animations.get(animation)[variant]) {
                duration += pose[1];
            }
        }
        return duration;
    }

    public boolean hasAnimation(Animation animation, GrowthStage growthStage) {
        return this.modelData.get((Object)((Object)growthStage)).animations.get(animation) != null;
    }

    private class ModelData {
        @SideOnly(value=Side.CLIENT)
        PosedCuboid[][] poses;
        Map<Animation, float[][][]> animations;
        Map<Animation, byte[]> poseCount;

        public ModelData() {
            this(null, null);
        }

        @SideOnly(value=Side.CLIENT)
        public ModelData(PosedCuboid[][] cuboids, Map<Animation, float[][][]> animations, Map<Animation, byte[]> poseCount) {
            this(animations, poseCount);
            if (cuboids == null) {
                cuboids = new PosedCuboid[][]{};
            }
            this.poses = cuboids;
        }

        public ModelData(Map<Animation, float[][][]> animations, Map<Animation, byte[]> poseCount) {
            if (animations == null) {
                animations = new LinkedHashMap<Animation, float[][][]>();
            }
            if (poseCount == null) {
                poseCount = new LinkedHashMap<Animation, byte[]>();
            }
            this.animations = animations;
            this.poseCount = poseCount;
        }
    }
}

