/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.model.animation.entity;

import java.util.HashMap;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.BooleanUtils;
import org.jurassicraft.client.model.AnimatableModel;
import org.jurassicraft.client.model.animation.EntityAnimation;
import org.jurassicraft.client.model.animation.EntityAnimator;
import org.jurassicraft.client.model.animation.entity.LegArticulator;
import org.jurassicraft.client.proxy.ClientProxy;
import org.jurassicraft.client.sound.SoundHandler;
import org.jurassicraft.server.entity.dinosaur.CeratosaurusEntity;

@SideOnly(value=Side.CLIENT)
public class CeratosaurusAnimator
extends EntityAnimator<CeratosaurusEntity> {
    private final HashMap<CeratosaurusEntity, AnimState> states = new HashMap();

    @Override
    protected void performAnimations(AnimatableModel model, CeratosaurusEntity entity, float f, float f1, float ticks, float rotationYaw, float rotationPitch, float scale) {
        if (!entity.field_70128_L && !entity.isCarcass()) {
            if (!this.states.containsKey(entity)) {
                this.states.put(entity, new AnimState(0.0f, FootStatus.EQUAL, 0.0f, 0.0f, FootStatus.EQUAL, 0.0f));
            }
        } else {
            this.states.remove(entity);
        }
        AdvancedModelRenderer waist = model.getCube("bodyHips");
        AdvancedModelRenderer stomach = model.getCube("bodyBack");
        AdvancedModelRenderer chest = model.getCube("bodyShoulders");
        AdvancedModelRenderer neck1 = model.getCube("neck1");
        AdvancedModelRenderer neck2 = model.getCube("neck2");
        AdvancedModelRenderer neck3 = model.getCube("neck3");
        AdvancedModelRenderer neck4 = model.getCube("neck4");
        AdvancedModelRenderer neck5 = model.getCube("neck5");
        AdvancedModelRenderer neck6 = model.getCube("neck6");
        AdvancedModelRenderer neck7 = model.getCube("neck7");
        AdvancedModelRenderer neck8 = model.getCube("neck8");
        AdvancedModelRenderer throat1 = model.getCube("throat1");
        AdvancedModelRenderer throat2 = model.getCube("throat2");
        AdvancedModelRenderer throat3 = model.getCube("throat3");
        AdvancedModelRenderer throat4 = model.getCube("throat4");
        AdvancedModelRenderer throat5 = model.getCube("throat5");
        AdvancedModelRenderer head = model.getCube("head");
        AdvancedModelRenderer tail1 = model.getCube("tail1");
        AdvancedModelRenderer tail2 = model.getCube("tail2");
        AdvancedModelRenderer tail3 = model.getCube("tail3");
        AdvancedModelRenderer tail4 = model.getCube("tail4");
        AdvancedModelRenderer tail5 = model.getCube("tail5");
        AdvancedModelRenderer tail6 = model.getCube("tail6");
        AdvancedModelRenderer handLeft = model.getCube("armHandLeft");
        AdvancedModelRenderer lowerArmLeft = model.getCube("armBicepLeft");
        AdvancedModelRenderer handRight = model.getCube("armHandRight");
        AdvancedModelRenderer lowerArmRight = model.getCube("armBicepRight");
        AdvancedModelRenderer leftThigh = model.getCube("legThighLeft");
        AdvancedModelRenderer rightThigh = model.getCube("legThighRight");
        AdvancedModelRenderer[] feet = new AdvancedModelRenderer[]{model.getCube("legFootLeft"), model.getCube("legFootRight")};
        AdvancedModelRenderer[] tailParts = new AdvancedModelRenderer[]{tail6, tail5, tail4, tail3, tail2, tail1};
        AdvancedModelRenderer[] bodyParts = new AdvancedModelRenderer[]{head, throat3, throat2, throat1, neck8, neck7, neck6, neck5, neck4, neck3, neck2, neck1, chest, stomach, waist};
        AdvancedModelRenderer[] leftArmParts = new AdvancedModelRenderer[]{handLeft, lowerArmLeft};
        AdvancedModelRenderer[] rightArmParts = new AdvancedModelRenderer[]{handRight, lowerArmRight};
        float delta = ClientProxy.MC.func_184121_ak();
        if (!entity.field_70128_L && !entity.isCarcass()) {
            AnimState statt = this.states.get(entity);
            FootStatus[] tempStatus = new FootStatus[2];
            for (int i = 0; i < feet.length; ++i) {
                boolean isLeft;
                boolean bl = isLeft = !BooleanUtils.toBoolean((int)i);
                tempStatus[i] = feet[i].field_78795_f > statt.getAngle(isLeft) ? FootStatus.UP : (feet[i].field_78795_f < statt.getAngle(isLeft) ? FootStatus.DOWN : statt.getStatus(isLeft));
                if (tempStatus[i] != statt.getStatus(isLeft)) {
                    if (tempStatus[i] == FootStatus.DOWN && (double)feet[i].field_78795_f > 0.5 && statt.getTicks(isLeft) + 10.0f <= ticks) {
                        statt.setTicks(isLeft, ticks);
                        if (entity.field_70122_E && !entity.func_70090_H() && (entity.getAnimation() == EntityAnimation.IDLE.get() || entity.getAnimation() == EntityAnimation.WALKING.get() || entity.getAnimation() == EntityAnimation.RUNNING.get() || entity.getAnimation() == EntityAnimation.ROARING.get() || entity.getAnimation() == EntityAnimation.DRINKING.get() || entity.getAnimation() == EntityAnimation.RESTING.get() || entity.getAnimation() == EntityAnimation.INJURED.get())) {
                            ClientProxy.MC.field_71439_g.field_70170_p.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundHandler.TYRANNOSAURUS_STOMP, SoundCategory.HOSTILE, (float)entity.interpolate(0.1f, 1.0), entity.func_70647_i(), false);
                        }
                    }
                    statt.setStatus(isLeft, tempStatus[i]);
                }
                statt.setAngle(isLeft, feet[i].field_78795_f);
            }
        }
        AdvancedModelRenderer leftCalf = model.getCube("legCalfLeft");
        AdvancedModelRenderer rightCalf = model.getCube("legCalfRight");
        LegArticulator.articulateBiped(entity, entity.legSolver, waist, leftThigh, leftCalf, rightThigh, rightCalf, 0.4f, 0.4f, delta);
        float globalSpeed = 0.5f;
        float globalDegree = 0.5f;
        model.bob(waist, 0.25f, 0.75f, false, f, f1);
        model.bob(rightThigh, 0.25f, 0.75f, false, f, f1);
        model.bob(leftThigh, 0.25f, 0.75f, false, f, f1);
        model.chainWave(tailParts, 0.25f, 0.025f, 1.0, f, f1);
        model.chainWave(bodyParts, 0.25f, 0.0125f, 3.0, f, f1);
        model.chainWave(bodyParts, 0.1f, -0.03f, 3.0, ticks, 0.25f);
        model.chainWave(rightArmParts, -0.1f, 0.2f, 4.0, ticks, 0.25f);
        model.chainWave(leftArmParts, -0.1f, 0.2f, 4.0, ticks, 0.25f);
        model.chainWave(tailParts, 0.1f, -0.1f, 2.0, ticks, 0.1f);
        model.faceTarget(rotationYaw, rotationPitch, 1.5f, chest, neck1, neck7, throat4, throat5, head);
        entity.tailBuffer.applyChainSwingBuffer((ModelRenderer[])tailParts);
    }

    private static class AnimState {
        public float angleR;
        public FootStatus statusR;
        public float ticksR;
        public float angleL;
        public FootStatus statusL;
        public float ticksL;

        public AnimState(float angleR, FootStatus statusR, float ticksR, float angleL, FootStatus statusL, float ticksL) {
            this.angleR = angleR;
            this.statusR = statusR;
            this.ticksR = ticksR;
            this.angleL = angleL;
            this.statusL = statusL;
            this.ticksL = ticksL;
        }

        public float getAngle(boolean isLeft) {
            return isLeft ? this.angleL : this.angleR;
        }

        public FootStatus getStatus(boolean isLeft) {
            return isLeft ? this.statusL : this.statusR;
        }

        public float getTicks(boolean isLeft) {
            return isLeft ? this.ticksL : this.ticksR;
        }

        public void setTicks(boolean isLeft, float ticks) {
            if (isLeft) {
                this.ticksL = ticks;
                return;
            }
            this.ticksR = ticks;
        }

        public void setStatus(boolean isLeft, FootStatus status) {
            if (isLeft) {
                this.statusL = status;
                return;
            }
            this.statusR = status;
        }

        public void setAngle(boolean isLeft, float angle) {
            if (isLeft) {
                this.angleL = angle;
                return;
            }
            this.angleR = angle;
        }
    }

    private static enum FootStatus {
        EQUAL,
        DOWN,
        UP;

    }
}

