/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.model.animation.entity.vehicle;

import com.google.common.collect.Lists;
import java.util.List;
import net.ilexiconn.llibrary.client.model.tabula.ITabulaModelAnimator;
import net.ilexiconn.llibrary.client.model.tabula.TabulaModel;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.math.Vec3d;
import org.jurassicraft.client.proxy.ClientProxy;
import org.jurassicraft.server.entity.ai.util.InterpValue;
import org.jurassicraft.server.entity.vehicle.HelicopterEntity;
import org.jurassicraft.server.entity.vehicle.VehicleEntity;

public class CarAnimator
implements ITabulaModelAnimator<VehicleEntity> {
    private final List<Door> doorList = Lists.newArrayList();
    public float partialTicks;

    public CarAnimator addDoor(Door door) {
        this.doorList.add(door);
        return this;
    }

    public void setRotationAngles(TabulaModel model, VehicleEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        if (!(entity instanceof HelicopterEntity)) {
            float steerAmount;
            this.doorList.forEach(door -> {
                VehicleEntity.Seat seat;
                InterpValue value = door.getInterpValue(entity);
                VehicleEntity.Seat closestSeat = seat = door.getSeat(entity);
                EntityPlayerSP player = ClientProxy.MC.field_71439_g;
                Vec3d playerPos = player.func_174791_d();
                for (Door door1 : this.doorList) {
                    if (!(door1.getSeat(entity).getPos().func_72438_d(playerPos) <= closestSeat.getPos().func_72438_d(playerPos))) continue;
                    closestSeat = door1.getSeat(entity);
                }
                value.setTarget(Math.toRadians(player.func_175149_v() || entity.func_184188_bt().contains(player) || entity.getEntityInSeat(door.getSeatIndex()) != null || closestSeat != seat || closestSeat.getPos().func_72438_d(playerPos) > 4.0 ? 0.0 : (door.isLeft() ? 60.0 : -60.0)));
                model.getCube((String)door.getName()).field_78796_g = (float)value.getValueForRendering(this.partialTicks);
            });
            AdvancedModelRenderer wheelHolderFront = model.getCube("wheel holder front");
            AdvancedModelRenderer wheelHolderBack = model.getCube("wheel holder back");
            float wheelRotation = entity.prevWheelRotateAmount + (entity.wheelRotateAmount - entity.prevWheelRotateAmount) * this.partialTicks;
            float wheelRotationAmount = entity.wheelRotation - entity.wheelRotateAmount * (1.0f - this.partialTicks);
            if (entity.backward()) {
                wheelRotationAmount = -wheelRotationAmount;
            }
            wheelHolderFront.field_78795_f = wheelRotationAmount * 0.5f;
            wheelHolderBack.field_78795_f = wheelRotationAmount * 0.5f;
            entity.steerAmount.setTarget(Math.toRadians(entity.left() ? 40.0 : (entity.right() ? -40.0 : 0.0)) * (double)wheelRotation);
            model.getCube((String)"steering wheel main").field_78808_h = steerAmount = (float)entity.steerAmount.getValueForRendering(this.partialTicks);
            wheelHolderFront.field_78796_g = -steerAmount * 0.15f;
        }
    }

    public static class Door {
        private final String name;
        private final int seatIndex;
        private final boolean isLeft;

        public Door(String name, int seatIndex, boolean isLeft) {
            this.name = name;
            this.seatIndex = seatIndex;
            this.isLeft = isLeft;
        }

        public InterpValue getInterpValue(VehicleEntity entity) {
            return this.getSeat(entity).getInterpValue();
        }

        public String getName() {
            return this.name;
        }

        public int getSeatIndex() {
            return this.seatIndex;
        }

        public VehicleEntity.Seat getSeat(VehicleEntity entity) {
            return entity.getSeat(this.seatIndex);
        }

        public boolean isLeft() {
            return this.isLeft;
        }
    }
}

