/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.proxy;

import com.google.common.io.Resources;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class UsernameCache {
    private static final ExecutorService threadPool = new ThreadPoolExecutor(0, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    private static final Map<UUID, String> names = new HashMap<UUID, String>();

    public static String getPlayerName(UUID uuid) {
        String name = null;
        try {
            return threadPool.submit(() -> UsernameCache.fetchPlayerName(uuid)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            names.put(uuid, "");
            return name;
        }
    }

    private static String fetchPlayerName(UUID uuid) throws IOException {
        if (names.containsKey(uuid)) {
            return names.get(uuid);
        }
        String url = "https://api.mojang.com/user/profiles/%s/names";
        try (BufferedReader reader = Resources.asCharSource((URL)new URL(String.format(url, uuid.toString().replaceAll("-", ""))), (Charset)StandardCharsets.UTF_8).openBufferedStream();){
            JsonReader json = new JsonReader((Reader)reader);
            json.beginArray();
            String name = "";
            long when = 0L;
            while (json.hasNext()) {
                String tempName = null;
                long time = 0L;
                json.beginObject();
                block18: while (json.hasNext()) {
                    String key;
                    switch (key = json.nextName()) {
                        case "name": {
                            tempName = json.nextString();
                            continue block18;
                        }
                        case "changedToAt": {
                            time = json.nextLong();
                            continue block18;
                        }
                    }
                    json.skipValue();
                }
                json.endObject();
                if (tempName == null || time < when) continue;
                name = tempName;
            }
            json.endArray();
            json.close();
            names.put(uuid, name);
            String string = name;
            return string;
        }
    }
}

