/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.render.entity;

import java.awt.Color;
import java.util.Random;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.client.proxy.ClientProxy;
import org.jurassicraft.client.render.entity.dinosaur.DinosaurRenderInfo;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.dinosaur.DinosaurMetadata;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.GrowthStage;
import org.jurassicraft.server.entity.OverlayType;

@SideOnly(value=Side.CLIENT)
public class DinosaurRenderer
extends RenderLiving<DinosaurEntity> {
    public final Dinosaur dinosaur;
    public final DinosaurRenderInfo renderInfo;
    public final Random random;

    public DinosaurRenderer(DinosaurRenderInfo renderInfo, RenderManager renderManager) {
        super(renderManager, null, 0.0f);
        this.dinosaur = renderInfo.getDinosaur();
        this.random = new Random();
        this.renderInfo = renderInfo;
        this.func_177094_a(new LayerOverlay(this, this.dinosaur.getMetadata().getOverlays()));
    }

    public void preRenderCallback(DinosaurEntity entity, float partialTick) {
        String name;
        DinosaurMetadata metadata = this.dinosaur.getMetadata();
        float scaleModifier = entity.getAttributes().getScaleModifier();
        float scale = (float)entity.interpolate(metadata.getScaleInfant(), metadata.getScaleAdult()) * scaleModifier;
        this.field_76989_e = scale * this.renderInfo.getShadowSize();
        GlStateManager.func_179109_b((float)(metadata.getOffsetX() * scale), (float)(metadata.getOffsetY() * scale), (float)(metadata.getOffsetZ() * scale));
        switch (name = entity.func_95999_t()) {
            case "Kashmoney360": 
            case "JTGhawk137": {
                GlStateManager.func_179152_a((float)0.1f, (float)scale, (float)scale);
                break;
            }
            case "Gegy": {
                GlStateManager.func_179152_a((float)scale, (float)0.01f, (float)scale);
                break;
            }
            case "Notch": {
                GlStateManager.func_179152_a((float)(scale * 2.0f), (float)(scale * 2.0f), (float)(scale * 2.0f));
                break;
            }
            case "jglrxavpok": {
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)(scale * -1.0f));
                break;
            }
            case "Wyn": {
                int color = Color.HSBtoRGB((float)(entity.field_70170_p.func_82737_E() % 1000L) / 100.0f, 1.0f, 1.0f);
                GlStateManager.func_179124_c((float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color >> 16 & 0xFF) / 255.0f));
            }
            default: {
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            }
        }
    }

    public void doRender(DinosaurEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.field_77045_g = this.renderInfo.getModel(entity.getGrowthStage(), entity.getSkeletonVariant());
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    public ResourceLocation getEntityTexture(DinosaurEntity entity) {
        GrowthStage growthStage = entity.getGrowthStage();
        if (!this.dinosaur.doesSupportGrowthStage(growthStage)) {
            growthStage = GrowthStage.ADULT;
        }
        return growthStage == GrowthStage.SKELETON ? (entity.getIsFossile() ? this.dinosaur.getMaleTexture(growthStage) : this.dinosaur.getFemaleTexture(growthStage)) : (entity.isMale() ? this.dinosaur.getMaleTexture(growthStage) : this.dinosaur.getFemaleTexture(growthStage));
    }

    protected void applyRotations(DinosaurEntity entity, float p_77043_2_, float p_77043_3_, float partialTicks) {
        GlStateManager.func_179114_b((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerOverlay
    implements LayerRenderer<DinosaurEntity> {
        private final DinosaurRenderer renderer;
        private final OverlayType[] type;

        public LayerOverlay(DinosaurRenderer renderer, OverlayType[] type) {
            this.renderer = renderer;
            this.type = type;
        }

        public void doRenderLayer(DinosaurEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float age, float yaw, float pitch, float scale) {
            if (!entity.func_82150_aj()) {
                for (OverlayType type : this.type) {
                    if (entity.areEyelidsClosed() && type == OverlayType.EYELID) {
                        this.renderOverlay(type, entity, limbSwing, limbSwingAmount, partialTicks, age, yaw, pitch, scale);
                        continue;
                    }
                    if (!entity.areEyelidsClosed() && type == OverlayType.EYE) {
                        this.renderOverlay(type, entity, limbSwing, limbSwingAmount, partialTicks, age, yaw, pitch, scale);
                        continue;
                    }
                    if (type == OverlayType.EYE || type == OverlayType.EYELID) continue;
                    this.renderOverlay(type, entity, limbSwing, limbSwingAmount, partialTicks, age, yaw, pitch, scale);
                }
            }
        }

        public boolean func_177142_b() {
            return true;
        }

        private void renderOverlay(OverlayType type, DinosaurEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float age, float yaw, float pitch, float scale) {
            ITextureObject textureObject;
            ResourceLocation texture = this.renderer.dinosaur.getOverlayTextures(type, entity);
            if (texture != null && (textureObject = ClientProxy.MC.func_110434_K().func_110581_b(texture)) != TextureUtil.field_111001_a) {
                this.renderer.func_110776_a(texture);
                this.renderer.func_177087_b().func_78088_a((Entity)entity, limbSwing, limbSwingAmount, age, yaw, pitch, scale);
            }
        }
    }
}

