/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.render.entity;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector4d;
import net.ilexiconn.llibrary.client.model.tabula.ITabulaModelAnimator;
import net.ilexiconn.llibrary.client.model.tabula.TabulaModel;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaModelContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.client.model.TabulaModelUV;
import org.jurassicraft.client.model.animation.entity.vehicle.HelicopterAnimator;
import org.jurassicraft.server.entity.vehicle.HelicopterEntity;
import org.jurassicraft.server.entity.vehicle.VehicleEntity;
import org.jurassicraft.server.tabula.TabulaModelHelper;
import org.jurassicraft.server.util.MathUtils;

@SideOnly(value=Side.CLIENT)
public abstract class HelicopterRenderer<E extends HelicopterEntity>
extends Render<E> {
    private static final ResourceLocation[] DESTROY_STAGES = (ResourceLocation[])IntStream.range(0, 10).mapToObj(n -> new ResourceLocation(String.format("textures/blocks/destroy_stage_%d.png", n))).toArray(ResourceLocation[]::new);
    private static ResourceLocation positionLights;
    protected final String helicopterName;
    protected final ResourceLocation texture;
    protected HelicopterAnimator animator;
    protected TabulaModel baseModel;
    protected TabulaModel destroyModel;
    protected int passedRenderTicks = 0;

    protected HelicopterRenderer(RenderManager renderManager, String helicopterName) {
        super(renderManager);
        this.helicopterName = helicopterName;
        this.animator = this.createCarAnimator();
        this.texture = new ResourceLocation("jurassicraft", "textures/entities/" + helicopterName + "/" + helicopterName + ".png");
        positionLights = new ResourceLocation("jurassicraft", "textures/entities/" + helicopterName + "/" + helicopterName + "_position_lights.png");
        try {
            TabulaModelContainer container = TabulaModelHelper.loadTabulaModel(new ResourceLocation("jurassicraft", "models/entities/" + helicopterName + "/" + helicopterName));
            this.baseModel = new TabulaModel(container, (ITabulaModelAnimator)this.animator);
            this.destroyModel = new TabulaModel((TabulaModelContainer)new TabulaModelUV(container, 16, 16), (ITabulaModelAnimator)this.animator);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load helicopter " + helicopterName, e);
        }
        this.passedRenderTicks = 0;
    }

    public void doRender(E entity, double x, double y, double z, float yaw, float partialTicks) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.func_180548_c((Entity)entity);
        this.renderModel(entity, x, y, z, yaw, partialTicks, false);
        this.renderPositionLamp(entity, x, y, z, yaw, partialTicks);
        this.renderDestroyTexture(entity, x, y, z, yaw, partialTicks);
        GlStateManager.func_179084_k();
        super.func_76986_a(entity, x, y, z, yaw, partialTicks);
    }

    protected void renderModel(E entity, double x, double y, double z, float yaw, float partialTicks, boolean destroy) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.25f), (float)((float)z));
        GlStateManager.func_179114_b((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((HelicopterEntity)entity).pitch, (float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((HelicopterEntity)entity).roll, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        (destroy ? this.destroyModel : this.baseModel).func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179121_F();
    }

    protected void renderPositionLamp(E entity, double x, double y, double z, float yaw, float partialTicks) {
        if (((VehicleEntity)entity).func_184179_bs() != null || ((HelicopterEntity)entity).getCurrentEngineSpeed() > 1.0f) {
            if (Minecraft.func_71410_x().field_71441_e.func_82737_E() - (long)this.passedRenderTicks > (long)(((HelicopterEntity)entity).getPositionLightFrequency() * 2)) {
                this.passedRenderTicks = (int)Minecraft.func_71410_x().field_71441_e.func_82737_E();
            }
            if (Minecraft.func_71410_x().field_71441_e.func_82737_E() - (long)this.passedRenderTicks <= (long)((HelicopterEntity)entity).getPositionLightFrequency()) {
                GlStateManager.func_179131_c((float)6.0f, (float)6.0f, (float)6.0f, (float)1.0f);
                this.func_110776_a(positionLights);
                this.renderModel(entity, x, y, z, yaw, partialTicks, false);
            }
        }
    }

    protected void renderDestroyTexture(E entity, double x, double y, double z, float yaw, float partialTicks) {
        int destroyStage = Math.min(10, (int)(10.0f - ((VehicleEntity)entity).getHealth() / 40.0f * 10.0f)) - 1;
        if (destroyStage >= 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
            GlStateManager.func_179088_q();
            RenderHelper.func_74518_a();
            this.func_110776_a(DESTROY_STAGES[destroyStage]);
            this.renderModel(entity, x, y, z, yaw, partialTicks, true);
            GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
            GlStateManager.func_179113_r();
            RenderHelper.func_74519_b();
        }
    }

    protected void doCarRotations(E entity, float partialTicks) {
        if (!(entity instanceof HelicopterEntity)) {
            double backValue = ((HelicopterEntity)entity).backValue.getValueForRendering(partialTicks);
            double frontValue = ((HelicopterEntity)entity).frontValue.getValueForRendering(partialTicks);
            double leftValue = ((HelicopterEntity)entity).leftValue.getValueForRendering(partialTicks);
            double rightValue = ((HelicopterEntity)entity).rightValue.getValueForRendering(partialTicks);
            Vector4d vec = ((VehicleEntity)entity).getCarDimensions();
            Vector2d rot = ((VehicleEntity)entity).getBackWheelRotationPoint();
            GlStateManager.func_179137_b((double)0.0, (double)rot.x, (double)rot.y);
            float localRotationPitch = (float)MathUtils.cosineFromPoints(new Vec3d(frontValue, 0.0, vec.w), new Vec3d(backValue, 0.0, vec.w), new Vec3d(backValue, 0.0, vec.y));
            GlStateManager.func_179114_b((float)(frontValue < backValue ? -localRotationPitch : localRotationPitch), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)(-rot.x), (double)(-rot.y));
            float localRotationRoll = (float)MathUtils.cosineFromPoints(new Vec3d(rightValue, 0.0, vec.z), new Vec3d(leftValue, 0.0, vec.z), new Vec3d(leftValue, 0.0, vec.x));
            GlStateManager.func_179114_b((float)(leftValue < rightValue ? localRotationRoll : -localRotationRoll), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected abstract HelicopterAnimator createCarAnimator();

    @Nullable
    protected ResourceLocation getEntityTexture(E entity) {
        return this.texture;
    }
}

