/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.render.overlay;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import org.jurassicraft.server.entity.vehicle.HelicopterEntity;
import org.lwjgl.opengl.GL11;

public class HelicopterHUDRenderer {
    public static int marginLeft = 25;
    private static float hudScale = 1.0f;

    public static void render(HelicopterEntity heli, float partialTicks) {
        HudOverlay overlay = heli.getHudOverlay();
        overlay.render(partialTicks);
    }

    public static class HudElementStatsDisplay
    extends HudElement {
        boolean autopilotEnabled = false;
        boolean lockOn = false;

        @Override
        public void update(Object ... param) {
            this.autopilotEnabled = (Boolean)param[0];
            this.lockOn = (Boolean)param[1];
        }

        @Override
        public void render(float partialTicks) {
            ScaledResolution scaledResolution = new ScaledResolution(mc);
            int yPosition = scaledResolution.func_78328_b();
            GlStateManager.func_179097_i();
            if (!this.autopilotEnabled) {
                HudElementStatsDisplay.mc.field_71466_p.func_175063_a("Autopilot disabled!", (float)marginLeft, (float)(yPosition - 140), Color.WHITE.getRGB());
            }
            HudElementStatsDisplay.mc.field_71466_p.func_175063_a(this.lockOn ? "Rotation lock on" : "Rotation lock off", (float)marginLeft, (float)(yPosition - 130), Color.WHITE.getRGB());
            GlStateManager.func_179126_j();
        }
    }

    public static class HudElementCompass
    extends HudElement {
        public HudElementCompass() {
            this.backgroundTexture = new ResourceLocation("jurassicraft", "textures/entities/helicopter/hud/compass.png");
            this.needleTexture = new ResourceLocation("jurassicraft", "textures/entities/helicopter/hud/compass_needle.png");
            this.index = 3;
            this.shouldRenderText = false;
        }

        @Override
        public void update(Object ... param) {
            this.value = ((Float)param[0]).floatValue();
            this.needleRotation = (int)((Float)param[0]).floatValue() - 180;
            this.pointerRotation = 0;
        }
    }

    public static class HudElementTachometer
    extends HudElement {
        public HudElementTachometer() {
            this.backgroundTexture = new ResourceLocation("jurassicraft", "textures/entities/helicopter/hud/tachometer.png");
            this.needleTexture = new ResourceLocation("jurassicraft", "textures/entities/helicopter/hud/tachometer_needle.png");
            this.pointerTexture = new ResourceLocation("jurassicraft", "textures/entities/helicopter/hud/tachometer_pointer.png");
            this.index = 0;
        }

        @Override
        public void update(Object ... param) {
            this.value = ((Float)param[0]).floatValue();
            this.needleRotation = (int)(33.0f + ((Float)param[1]).floatValue() * 294.0f);
            this.pointerRotation = (int)(33.0f + ((Float)param[2]).floatValue() * 294.0f);
        }
    }

    public static class HudElementArtificialHorizon
    extends HudElement {
        private float pitchLevel = 0.0f;
        private float prevPitchLevel = 0.0f;
        private final ResourceLocation secondLayer;
        private final ResourceLocation alpha;

        public HudElementArtificialHorizon() {
            this.backgroundTexture = new ResourceLocation("jurassicraft", "textures/entities/helicopter/hud/artificial_horizon.png");
            this.needleTexture = new ResourceLocation("jurassicraft", "textures/entities/helicopter/hud/artificial_horizon_needle.png");
            this.pointerTexture = new ResourceLocation("jurassicraft", "textures/entities/helicopter/hud/artificial_horizon_pointer.png");
            this.secondLayer = new ResourceLocation("jurassicraft", "textures/entities/helicopter/hud/artificial_horizon_second_layer.png");
            this.alpha = new ResourceLocation("jurassicraft", "textures/entities/helicopter/hud/artificial_horizon_alpha.png");
            this.index = 1;
        }

        @Override
        public void update(Object ... param) {
            this.needleRotation = (int)((Float)param[0]).floatValue();
            this.prevPitchLevel = this.pitchLevel;
            this.pitchLevel = ((Float)param[1]).floatValue();
        }

        @Override
        public void render(float partialTicks) {
            ScaledResolution scaledResolution = new ScaledResolution(mc);
            int xPosition = scaledResolution.func_78326_a();
            int yPosition = scaledResolution.func_78328_b();
            GlStateManager.func_179141_d();
            GlStateManager.func_179094_E();
            this.renderHorizon(xPosition, yPosition, scaledResolution.func_78325_e(), partialTicks);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            HudElementArtificialHorizon.mc.field_71446_o.func_110577_a(this.secondLayer);
            HudElementArtificialHorizon.func_146110_a((int)((int)((float)marginLeft + (float)(this.index * 75) * hudScale)), (int)((int)((float)(yPosition - 36) - 64.0f * hudScale)), (float)0.0f, (float)0.0f, (int)((int)(64.0f * hudScale)), (int)((int)(64.0f * hudScale)), (float)((int)(64.0f * hudScale)), (float)((int)(64.0f * hudScale)));
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            HudElementArtificialHorizon.mc.field_71446_o.func_110577_a(this.needleTexture);
            GlStateManager.func_179109_b((float)((float)marginLeft + (float)(this.index * 75) * hudScale + 64.0f * hudScale / 2.0f), (float)((float)(yPosition - 36) - 64.0f * hudScale + 64.0f * hudScale / 2.0f), (float)0.0f);
            GlStateManager.func_179114_b((float)this.needleRotation, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)(-((float)marginLeft + (float)(this.index * 75) * hudScale + 64.0f * hudScale / 2.0f)), (float)(-((float)(yPosition - 36) - 64.0f * hudScale + 64.0f * hudScale / 2.0f)), (float)0.0f);
            HudElementArtificialHorizon.func_146110_a((int)((int)((float)marginLeft + (float)(this.index * 75) * hudScale)), (int)((int)((float)(yPosition - 36) - 64.0f * hudScale)), (float)0.0f, (float)0.0f, (int)((int)(64.0f * hudScale)), (int)((int)(64.0f * hudScale)), (float)((int)(64.0f * hudScale)), (float)((int)(64.0f * hudScale)));
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            HudElementArtificialHorizon.mc.field_71446_o.func_110577_a(this.pointerTexture);
            HudElementArtificialHorizon.func_146110_a((int)((int)((float)marginLeft + (float)(this.index * 75) * hudScale)), (int)((int)((float)(yPosition - 36) - 64.0f * hudScale)), (float)0.0f, (float)0.0f, (int)((int)(64.0f * hudScale)), (int)((int)(64.0f * hudScale)), (float)((int)(64.0f * hudScale)), (float)((int)(64.0f * hudScale)));
            GlStateManager.func_179121_F();
            GlStateManager.func_179118_c();
            GlStateManager.func_179097_i();
            GlStateManager.func_179126_j();
        }

        private void renderHorizon(int xPosition, int yPosition, int scaleFactor, float partialTick) {
            float y;
            float top;
            float bottom;
            float partialPitch = (this.pitchLevel - this.prevPitchLevel) * partialTick;
            float currentDisplayPitch = this.prevPitchLevel + partialPitch;
            GL11.glEnable((int)3089);
            GL11.glScissor((int)((int)(((float)marginLeft + (float)(this.index * 75) * hudScale) * (float)scaleFactor)), (int)(36 * scaleFactor), (int)((int)(64.0f * hudScale * (float)scaleFactor)), (int)((int)(64.0f * hudScale * (float)scaleFactor)));
            if (currentDisplayPitch < 45.0f && currentDisplayPitch > -135.0f) {
                bottom = (45.0f - currentDisplayPitch) / 90.0f * (58.0f * hudScale);
                if (bottom > 58.0f * hudScale) {
                    bottom = 58.0f * hudScale;
                }
                HudElementArtificialHorizon.func_73734_a((int)((int)((float)marginLeft + (float)(this.index * 75 + 3) * hudScale)), (int)((int)((float)(yPosition - 36) - 61.0f * hudScale)), (int)((int)((float)marginLeft + (float)(this.index * 75 + 64 - 3) * hudScale)), (int)((int)((float)(yPosition - 36) - 61.0f * hudScale + bottom)), (int)new Color(73, 179, 255).getRGB());
            }
            if (currentDisplayPitch > -45.0f && currentDisplayPitch < 135.0f) {
                top = (int)((45.0f + currentDisplayPitch) / 90.0f * (58.0f * hudScale));
                if (top > 57.0f * hudScale) {
                    top = 58.0f * hudScale;
                }
                HudElementArtificialHorizon.func_73734_a((int)((int)((float)marginLeft + (float)(this.index * 75 + 3) * hudScale)), (int)((int)((float)(yPosition - 36) - 3.0f * hudScale - top)), (int)((int)((float)marginLeft + (float)(this.index * 75 + 64 - 3) * hudScale)), (int)((int)((float)(yPosition - 36) - 3.0f * hudScale)), (int)new Color(107, 42, 0).getRGB());
            }
            if (currentDisplayPitch < 45.0f && currentDisplayPitch > -45.0f) {
                y = (45.0f - currentDisplayPitch) / 90.0f * 58.0f * hudScale;
                this.func_73730_a((int)((float)marginLeft + (float)(this.index * 75 + 3) * hudScale), (int)((float)marginLeft + (float)(this.index * 75 + 60 - 3) * hudScale), (int)((float)(yPosition - 36) - 61.0f * hudScale + y), Color.WHITE.getRGB());
            }
            if (currentDisplayPitch > 135.0f || currentDisplayPitch < -135.0f) {
                bottom = (1.0f - ((float)(currentDisplayPitch > 0.0f ? 180 : -180) - currentDisplayPitch + 45.0f) / 90.0f) * (58.0f * hudScale);
                if (bottom > 58.0f * hudScale) {
                    bottom = 58.0f * hudScale;
                }
                HudElementArtificialHorizon.func_73734_a((int)((int)((float)marginLeft + (float)(this.index * 75 + 3) * hudScale)), (int)((int)((float)(yPosition - 36) - 3.0f * hudScale - bottom)), (int)((int)((float)marginLeft + (float)(this.index * 75 + 64 - 3) * hudScale)), (int)((int)((float)(yPosition - 36) - 3.0f * hudScale)), (int)new Color(73, 179, 255).getRGB());
            }
            if (currentDisplayPitch > 135.0f || currentDisplayPitch < -135.0f) {
                top = ((float)(currentDisplayPitch > 0.0f ? 180 : -180) - currentDisplayPitch + 45.0f) / 90.0f * (58.0f * hudScale);
                if (top > 58.0f * hudScale) {
                    top = 58.0f * hudScale;
                }
                HudElementArtificialHorizon.func_73734_a((int)((int)((float)marginLeft + (float)(this.index * 75 + 3) * hudScale)), (int)((int)((float)(yPosition - 36) - 61.0f * hudScale)), (int)((int)((float)marginLeft + (float)(this.index * 75 + 64 - 3) * hudScale)), (int)((int)((float)(yPosition - 36) - 61.0f * hudScale + top)), (int)new Color(107, 42, 0).getRGB());
            }
            if (currentDisplayPitch > 135.0f || currentDisplayPitch < -135.0f) {
                y = ((float)(currentDisplayPitch > 0.0f ? 180 : -180) - currentDisplayPitch + 45.0f) / 90.0f * (58.0f * hudScale);
                this.func_73730_a((int)((float)marginLeft + (float)(this.index * 75 + 3) * hudScale), (int)((float)marginLeft + (float)(this.index * 75 + 60 - 3) * hudScale), (int)((float)(yPosition - 36) - 61.0f * hudScale + y), Color.WHITE.getRGB());
            }
            GlStateManager.func_179124_c((float)255.0f, (float)255.0f, (float)255.0f);
            GL11.glDisable((int)3089);
        }

        private void enableStencilBuffer(int xPosition, int yPosition, int scaleFactor, float partialPitch) {
            GL11.glClear((int)256);
            GL11.glEnable((int)2960);
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            GL11.glDepthMask((boolean)false);
            GL11.glStencilFunc((int)512, (int)1, (int)255);
            GL11.glStencilOp((int)7681, (int)7680, (int)7680);
            GL11.glStencilMask((int)255);
            GL11.glClear((int)1024);
            this.drawCircle(xPosition, yPosition, scaleFactor, partialPitch);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glDepthMask((boolean)true);
            GL11.glStencilMask((int)0);
            GL11.glStencilFunc((int)514, (int)0, (int)255);
            GL11.glStencilFunc((int)514, (int)1, (int)255);
        }

        private void drawCircle(int xPosition, int yPosition, int scaleFactor, float partialPitch) {
            if (this.prevPitchLevel + partialPitch > -45.0f) {
                int top = (int)((45.0f + this.prevPitchLevel + partialPitch) / 90.0f * (58.0f * hudScale));
                if ((float)top > 58.0f * hudScale) {
                    top = (int)(58.0f * hudScale);
                }
                HudElementArtificialHorizon.func_73734_a((int)((int)((float)marginLeft + (float)(this.index * 75 + 3) * hudScale)), (int)((int)((float)(yPosition - 36) - 3.0f * hudScale - (float)top)), (int)((int)((float)marginLeft + (float)(this.index * 75 + 64 - 3) * hudScale)), (int)((int)((float)(yPosition - 36) - 3.0f * hudScale)), (int)Color.WHITE.getRGB());
            }
        }
    }

    public static class HudElementAltimeter
    extends HudElement {
        public HudElementAltimeter() {
            this.backgroundTexture = new ResourceLocation("jurassicraft", "textures/entities/helicopter/hud/altimeter.png");
            this.needleTexture = new ResourceLocation("jurassicraft", "textures/entities/helicopter/hud/altimeter_needle.png");
            this.pointerTexture = new ResourceLocation("jurassicraft", "textures/entities/helicopter/hud/altimeter_pointer.png");
            this.index = 2;
        }

        @Override
        public void update(Object ... param) {
            this.value = ((Float)param[0]).floatValue();
            this.needleRotation = (int)((((Float)param[0]).floatValue() - 63.0f) / 187.0f * 360.0f);
            this.pointerRotation = (int)(((Float)param[1]).floatValue() / 250.0f * 360.0f);
        }
    }

    public static abstract class HudElement
    extends Gui {
        protected static Minecraft mc = Minecraft.func_71410_x();
        protected ResourceLocation backgroundTexture;
        protected ResourceLocation needleTexture;
        protected int needleRotation = 0;
        protected ResourceLocation pointerTexture;
        protected int pointerRotation = 0;
        protected float value = 0.0f;
        protected boolean shouldRenderText = true;
        protected int index = 0;

        public abstract void update(Object ... var1);

        public void render(float partialTicks) {
            ScaledResolution scaledResolution = new ScaledResolution(mc);
            int xPosition = scaledResolution.func_78326_a();
            int yPosition = scaledResolution.func_78328_b();
            GlStateManager.func_179094_E();
            GlStateManager.func_179141_d();
            HudElement.mc.field_71446_o.func_110577_a(this.backgroundTexture);
            HudElement.func_146110_a((int)((int)((float)marginLeft + (float)(this.index * 75) * hudScale)), (int)((int)((float)(yPosition - 36) - 64.0f * hudScale)), (float)0.0f, (float)0.0f, (int)((int)(64.0f * hudScale)), (int)((int)(64.0f * hudScale)), (float)((int)(64.0f * hudScale)), (float)((int)(64.0f * hudScale)));
            GlStateManager.func_179118_c();
            GlStateManager.func_179121_F();
            if (this.shouldRenderText) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179097_i();
                float textScale = 0.7f * hudScale;
                GL11.glScalef((float)textScale, (float)textScale, (float)1.0f);
                String valueAsText = String.valueOf((int)this.value);
                for (int i = 1; i <= 5; ++i) {
                    float offsetX = ((float)i - 1.0f) * -4.7f;
                    HudElement.mc.field_71466_p.func_78276_b("" + (valueAsText.length() - i < 0 ? "0" : Character.valueOf(valueAsText.charAt(valueAsText.length() - i))), (int)(((float)marginLeft + ((float)(this.index * 75) + 39.5f + offsetX) * hudScale) / textScale), (int)(((float)(yPosition - 36) - 42.5f * hudScale) / textScale), Color.WHITE.getRGB());
                }
                GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179126_j();
                GlStateManager.func_179121_F();
            }
            if (this.needleTexture != null) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179141_d();
                HudElement.mc.field_71446_o.func_110577_a(this.needleTexture);
                GlStateManager.func_179109_b((float)((float)marginLeft + (float)(this.index * 75) * hudScale + 64.0f * hudScale / 2.0f), (float)((float)(yPosition - 36) - 64.0f * hudScale + 64.0f * hudScale / 2.0f), (float)0.0f);
                GlStateManager.func_179114_b((float)this.needleRotation, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)(-((float)marginLeft + (float)(this.index * 75) * hudScale + 64.0f * hudScale / 2.0f)), (float)(-((float)(yPosition - 36) - 64.0f * hudScale + 64.0f * hudScale / 2.0f)), (float)0.0f);
                HudElement.func_146110_a((int)((int)((float)marginLeft + (float)(this.index * 75) * hudScale)), (int)((int)((float)(yPosition - 36) - 64.0f * hudScale)), (float)0.0f, (float)0.0f, (int)((int)(64.0f * hudScale)), (int)((int)(64.0f * hudScale)), (float)((int)(64.0f * hudScale)), (float)((int)(64.0f * hudScale)));
                GlStateManager.func_179118_c();
                GlStateManager.func_179121_F();
            }
            if (this.pointerTexture != null) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179141_d();
                HudElement.mc.field_71446_o.func_110577_a(this.pointerTexture);
                GlStateManager.func_179109_b((float)((float)marginLeft + (float)(this.index * 75) * hudScale + 64.0f * hudScale / 2.0f), (float)((float)(yPosition - 36) - 64.0f * hudScale + 64.0f * hudScale / 2.0f), (float)0.0f);
                GlStateManager.func_179114_b((float)this.pointerRotation, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)(-((float)marginLeft + (float)(this.index * 75) * hudScale + 64.0f * hudScale / 2.0f)), (float)(-((float)(yPosition - 36) - 64.0f * hudScale + 64.0f * hudScale / 2.0f)), (float)0.0f);
                HudElement.func_146110_a((int)((int)((float)marginLeft + (float)(this.index * 75) * hudScale)), (int)((int)((float)(yPosition - 36) - 64.0f * hudScale)), (float)0.0f, (float)0.0f, (int)((int)(64.0f * hudScale)), (int)((int)(64.0f * hudScale)), (float)((int)(64.0f * hudScale)), (float)((int)(64.0f * hudScale)));
                GlStateManager.func_179118_c();
                GlStateManager.func_179121_F();
            }
        }
    }

    public static class HudOverlay {
        private final HashMap<Class, HudElement> hudElements = new HashMap();

        public void addHudElement(HudElement element) {
            this.hudElements.put(((Object)((Object)element)).getClass(), element);
        }

        public void removeHudElement(Class cls) {
            this.hudElements.remove(cls);
        }

        public HudElement getHudElement(Class cls) {
            return this.hudElements.get(cls);
        }

        public void enableHudElement(Class<HudElement> cls) {
            try {
                this.addHudElement(cls.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }

        public boolean isHudElementEnabled(Class<HudElement> cls) {
            return this.hudElements.containsKey(cls);
        }

        public void updateHudElement(Class cls, Object ... param) {
            if (this.isHudElementEnabled(cls)) {
                this.hudElements.get(cls).update(param);
            }
        }

        public HashMap<Class, HudElement> getHudElements() {
            return this.hudElements;
        }

        public void render(float partialTicks) {
            hudScale = Minecraft.func_71410_x().field_71474_y.field_74320_O > 0 ? 0.5f : 1.0f;
            int i = 0;
            for (Map.Entry<Class, HudElement> entry : this.hudElements.entrySet()) {
                entry.getValue().render(partialTicks);
                ++i;
            }
        }
    }
}

