/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.tab.TabHandler;

public class ClearGlassPaneBlock
extends Block {
    public static final PropertyBool BLOCK_NORTH = PropertyBool.func_177716_a((String)"blocknorth");
    public static final PropertyBool BLOCK_EAST = PropertyBool.func_177716_a((String)"blockeast");
    public static final PropertyBool BLOCK_SOUTH = PropertyBool.func_177716_a((String)"blocksouth");
    public static final PropertyBool BLOCK_WEST = PropertyBool.func_177716_a((String)"blockwest");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    protected static final AxisAlignedBB[] AABB_BY_INDEX = new AxisAlignedBB[]{new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.4375, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.4375, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.4375, 0.0, 0.4375, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.4375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.4375, 0.0, 0.0, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    private final boolean canDrop;

    protected ClearGlassPaneBlock() {
        super(Material.field_151592_s);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BLOCK_NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BLOCK_EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BLOCK_SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BLOCK_WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)));
        this.canDrop = true;
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149647_a(TabHandler.BLOCKS);
    }

    private static int getBoundingBoxIndex(EnumFacing p_185729_0_) {
        return 1 << p_185729_0_.func_176736_b();
    }

    private static int getBoundingBoxIndex(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)BLOCK_NORTH)).booleanValue()) {
            i |= ClearGlassPaneBlock.getBoundingBoxIndex(EnumFacing.NORTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)BLOCK_EAST)).booleanValue()) {
            i |= ClearGlassPaneBlock.getBoundingBoxIndex(EnumFacing.EAST);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)BLOCK_SOUTH)).booleanValue()) {
            i |= ClearGlassPaneBlock.getBoundingBoxIndex(EnumFacing.SOUTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)BLOCK_WEST)).booleanValue()) {
            i |= ClearGlassPaneBlock.getBoundingBoxIndex(EnumFacing.WEST);
        }
        return i;
    }

    protected static boolean isExcepBlockForAttachWithPiston(Block p_193394_0_) {
        return p_193394_0_ instanceof BlockShulkerBox || p_193394_0_ instanceof BlockLeaves || p_193394_0_ == Blocks.field_150461_bJ || p_193394_0_ == Blocks.field_150383_bp || p_193394_0_ == Blocks.field_150426_aN || p_193394_0_ == Blocks.field_150432_aD || p_193394_0_ == Blocks.field_180398_cJ || p_193394_0_ == Blocks.field_150331_J || p_193394_0_ == Blocks.field_150320_F || p_193394_0_ == Blocks.field_150332_K || p_193394_0_ == Blocks.field_150440_ba || p_193394_0_ == Blocks.field_150423_aK || p_193394_0_ == Blocks.field_150428_aP || p_193394_0_ == Blocks.field_180401_cv;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        ClearGlassPaneBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_INDEX[0]);
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)BLOCK_NORTH)).booleanValue()) {
            ClearGlassPaneBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_INDEX[ClearGlassPaneBlock.getBoundingBoxIndex(EnumFacing.NORTH)]);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)BLOCK_SOUTH)).booleanValue()) {
            ClearGlassPaneBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_INDEX[ClearGlassPaneBlock.getBoundingBoxIndex(EnumFacing.SOUTH)]);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)BLOCK_EAST)).booleanValue()) {
            ClearGlassPaneBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_INDEX[ClearGlassPaneBlock.getBoundingBoxIndex(EnumFacing.EAST)]);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)BLOCK_WEST)).booleanValue()) {
            ClearGlassPaneBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_INDEX[ClearGlassPaneBlock.getBoundingBoxIndex(EnumFacing.WEST)]);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        return AABB_BY_INDEX[ClearGlassPaneBlock.getBoundingBoxIndex(state)];
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean north = this.canPaneConnectToPane(worldIn, pos, EnumFacing.NORTH);
        boolean east = this.canPaneConnectToPane(worldIn, pos, EnumFacing.EAST);
        boolean south = this.canPaneConnectToPane(worldIn, pos, EnumFacing.SOUTH);
        boolean west = this.canPaneConnectToPane(worldIn, pos, EnumFacing.WEST);
        boolean blockNorth = this.canPaneConnectToBlock(worldIn, pos, EnumFacing.NORTH);
        boolean blockEast = this.canPaneConnectToBlock(worldIn, pos, EnumFacing.EAST);
        boolean blockSouth = this.canPaneConnectToBlock(worldIn, pos, EnumFacing.SOUTH);
        boolean blockWest = this.canPaneConnectToBlock(worldIn, pos, EnumFacing.WEST);
        if (north) {
            blockNorth = !this.canPaneConnectToPaneUP(worldIn, pos, EnumFacing.NORTH);
        } else if (blockNorth) {
            // empty if block
        }
        if (east) {
            blockEast = !this.canPaneConnectToPaneUP(worldIn, pos, EnumFacing.EAST);
        } else if (blockEast) {
            // empty if block
        }
        if (south) {
            blockSouth = !this.canPaneConnectToPaneUP(worldIn, pos, EnumFacing.SOUTH);
        } else if (blockSouth) {
            // empty if block
        }
        if (west) {
            blockWest = !this.canPaneConnectToPaneUP(worldIn, pos, EnumFacing.WEST);
        } else if (blockWest) {
            // empty if block
        }
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(north)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(south)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(west)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(east)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.canPaneConnectToPane(worldIn, pos, EnumFacing.UP))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.canPaneConnectToPane(worldIn, pos, EnumFacing.DOWN))).func_177226_a((IProperty)BLOCK_NORTH, (Comparable)Boolean.valueOf(blockNorth)).func_177226_a((IProperty)BLOCK_SOUTH, (Comparable)Boolean.valueOf(blockSouth)).func_177226_a((IProperty)BLOCK_WEST, (Comparable)Boolean.valueOf(blockWest)).func_177226_a((IProperty)BLOCK_EAST, (Comparable)Boolean.valueOf(blockEast));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return !this.canDrop ? Items.field_190931_a : super.func_180660_a(state, rand, fortune);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public final boolean attachesTo(IBlockAccess p_193393_1_, IBlockState state, BlockPos pos, EnumFacing facing) {
        Block block = state.func_177230_c();
        BlockFaceShape blockfaceshape = state.func_193401_d(p_193393_1_, pos, facing);
        return !ClearGlassPaneBlock.isExcepBlockForAttachWithPiston(block) && blockfaceshape == BlockFaceShape.SOLID || blockfaceshape == BlockFaceShape.MIDDLE_POLE_THIN;
    }

    protected boolean func_149700_E() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)BLOCK_NORTH, state.func_177229_b((IProperty)BLOCK_SOUTH)).func_177226_a((IProperty)BLOCK_EAST, state.func_177229_b((IProperty)BLOCK_WEST)).func_177226_a((IProperty)BLOCK_SOUTH, state.func_177229_b((IProperty)BLOCK_NORTH)).func_177226_a((IProperty)BLOCK_WEST, state.func_177229_b((IProperty)BLOCK_EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)BLOCK_NORTH, state.func_177229_b((IProperty)BLOCK_EAST)).func_177226_a((IProperty)BLOCK_EAST, state.func_177229_b((IProperty)BLOCK_SOUTH)).func_177226_a((IProperty)BLOCK_SOUTH, state.func_177229_b((IProperty)BLOCK_WEST)).func_177226_a((IProperty)BLOCK_WEST, state.func_177229_b((IProperty)BLOCK_NORTH));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)BLOCK_NORTH, state.func_177229_b((IProperty)BLOCK_WEST)).func_177226_a((IProperty)BLOCK_EAST, state.func_177229_b((IProperty)BLOCK_NORTH)).func_177226_a((IProperty)BLOCK_SOUTH, state.func_177229_b((IProperty)BLOCK_EAST)).func_177226_a((IProperty)BLOCK_WEST, state.func_177229_b((IProperty)BLOCK_SOUTH));
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)BLOCK_NORTH, state.func_177229_b((IProperty)BLOCK_SOUTH)).func_177226_a((IProperty)BLOCK_SOUTH, state.func_177229_b((IProperty)BLOCK_NORTH));
            }
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)BLOCK_EAST, state.func_177229_b((IProperty)BLOCK_WEST)).func_177226_a((IProperty)BLOCK_WEST, state.func_177229_b((IProperty)BLOCK_EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, WEST, SOUTH, UP, DOWN, BLOCK_NORTH, BLOCK_EAST, BLOCK_WEST, BLOCK_SOUTH});
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos offset = pos.func_177972_a(facing);
        return this.attachesTo(world, world.func_180495_p(offset), offset, facing.func_176734_d());
    }

    public boolean canPaneConnectToPane(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        BlockPos other = pos.func_177972_a(dir);
        IBlockState state = world.func_180495_p(other);
        return !(!state.func_177230_c().canBeConnectedTo(world, other, dir.func_176734_d()) && !this.attachesTo(world, state, other, dir.func_176734_d()) || !(state.func_177230_c() instanceof BlockPane) && !(state.func_177230_c() instanceof ClearGlassPaneBlock));
    }

    public boolean canPaneConnectToPaneUP(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        BlockPos other = pos.func_177972_a(dir).func_177982_a(0, 1, 0);
        IBlockState state = world.func_180495_p(other);
        return !(state.func_177230_c() instanceof BlockAir);
    }

    public boolean canPaneConnectToPaneDOWN(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        BlockPos other = pos.func_177972_a(dir).func_177982_a(0, -1, 0);
        IBlockState state = world.func_180495_p(other);
        return !(state.func_177230_c() instanceof BlockAir);
    }

    public boolean canPaneConnectToBlock(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        BlockPos other = pos.func_177972_a(dir);
        IBlockState state = world.func_180495_p(other);
        return (state.func_177230_c().canBeConnectedTo(world, other, dir.func_176734_d()) || this.attachesTo(world, state, other, dir.func_176734_d())) && !(state.func_177230_c() instanceof BlockPane) && !(state.func_177230_c() instanceof ClearGlassPaneBlock);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.MIDDLE_POLE_THIN;
    }
}

