/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.world.Explosion;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.jurassicraft.server.api.CleanableItem;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.tab.TabHandler;

public class EncasedFossilBlock
extends Block
implements CleanableItem {
    protected final Dinosaur dino;

    public EncasedFossilBlock(Dinosaur dino) {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(8.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(TabHandler.FOSSILS);
        this.dino = dino;
    }

    public Dinosaur getDinosaur() {
        return this.dino;
    }

    public String getHarvestTool(IBlockState state) {
        return "pickaxe";
    }

    public int getHarvestLevel(IBlockState state) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    @Override
    public boolean isCleanable(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getCleanedItem(ItemStack stack, Random random) {
        String[] bones = this.dino.getMetadata().getBones();
        return new ItemStack((Item)ItemHandler.FOSSILS.get(bones[random.nextInt(bones.length)]), 1, EntityHandler.getDinosaurId(this.dino));
    }

    @Override
    public List<ItemStack> getJEIRecipeTypes() {
        ArrayList list = Lists.newArrayList();
        EntityHandler.getDinosaurs().values().forEach(dino -> list.add(new ItemStack((Block)BlockHandler.getEncasedFossil(dino), 1, EntityHandler.getDinosaurId(dino) % 16)));
        return list;
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        String[] bones = this.dino.getMetadata().getBones();
        float single = 100.0f / (float)bones.length;
        ArrayList list = Lists.newArrayList();
        for (String bone : bones) {
            list.add(Pair.of((Object)Float.valueOf(single), (Object)new ItemStack((Item)ItemHandler.FOSSILS.get(bone), 1, EntityHandler.getDinosaurId(this.dino))));
        }
        return list;
    }
}

