/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeSwamp;
import org.apache.commons.lang3.tuple.Pair;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.config.JurassiCraftConfig;
import org.jurassicraft.server.plugin.jei.category.moss.PeatItem;
import org.jurassicraft.server.tab.TabHandler;

public class PeatBlock
extends Block
implements PeatItem {
    public static final PropertyInteger MOISTURE = PropertyInteger.func_177719_a((String)"moisture", (int)0, (int)7);
    public int peatGenerationSpeed;

    public PeatBlock() {
        super(Material.field_151578_c);
        this.peatGenerationSpeed = JurassiCraftConfig.PLANT_GENERATION.peatGenerationSpeed;
        this.func_149647_a(TabHandler.PLANTS);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149711_c(0.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int moisture = (Integer)state.func_177229_b((IProperty)MOISTURE);
        if (!(this.hasWater(world, pos) || world.func_175727_C(pos.func_177984_a()) || world.func_180494_b(pos) instanceof BiomeSwamp)) {
            if (moisture > 0) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(moisture - 1)), 2);
            } else {
                world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
            }
        } else if (moisture < 7) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
        if (world.func_180494_b(pos) instanceof BiomeSwamp) {
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = pos.func_177982_a(rand.nextInt(this.peatGenerationSpeed + 1), rand.nextInt(this.peatGenerationSpeed + 1), rand.nextInt(this.peatGenerationSpeed + 1));
                if (blockpos.func_177956_o() >= 0 && blockpos.func_177956_o() < 256 && !world.func_175667_e(blockpos)) {
                    return;
                }
                IBlockState iblockstate = world.func_180495_p(blockpos.func_177984_a());
                IBlockState iblockstate1 = world.func_180495_p(blockpos);
                IBlockState iBlockState2 = world.func_180495_p(blockpos.func_177981_b(2));
                IBlockState iBlockState3 = world.func_180495_p(blockpos.func_177981_b(3));
                if (iblockstate1.func_177230_c() != Blocks.field_150346_d || iblockstate1.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.DIRT || iblockstate.func_177230_c() != Blocks.field_150349_c && iBlockState2.func_177230_c() != Blocks.field_150349_c && iBlockState3.func_177230_c() != Blocks.field_150349_c) continue;
                world.func_175656_a(blockpos, BlockHandler.PEAT.func_176223_P());
            }
        }
    }

    private boolean hasWater(World world, BlockPos pos) {
        for (BlockPos.MutableBlockPos nearPos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (world.func_180495_p((BlockPos)nearPos).func_185904_a() != Material.field_151586_h) continue;
            return true;
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(meta & 7));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)MOISTURE);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MOISTURE});
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        return null;
    }
}

