/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.block.entity.SkullDisplayEntity;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.item.ItemHandler;

public class SkullDisplay
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public SkullDisplay() {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(0.0f);
        this.func_149752_b(0.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
    }

    private static boolean canBlockStay(World world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        EnumFacing.Axis axis = facing.func_176740_k();
        if (axis == EnumFacing.Axis.Y) {
            return world.func_180495_p(pos.func_177977_b()).func_185914_p();
        }
        return world.func_180495_p(pos.func_177972_a(SkullDisplay.mirror(facing))).func_185914_p();
    }

    private static ItemStack getItemFromTile(SkullDisplayEntity tile) {
        ItemStack stack = tile.isFossilized() ? new ItemStack((Item)ItemHandler.FOSSILS.get("skull"), 1, EntityHandler.getDinosaurId(tile.getDinosaur())) : new ItemStack((Item)ItemHandler.FRESH_FOSSILS.get("skull"), 1, EntityHandler.getDinosaurId(tile.getDinosaur()));
        return stack;
    }

    private static SkullDisplayEntity getTile(IBlockAccess world, BlockPos pos) {
        return (SkullDisplayEntity)world.func_175625_s(pos);
    }

    public static EnumFacing mirror(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return EnumFacing.SOUTH;
            }
            case EAST: {
                return EnumFacing.WEST;
            }
            case SOUTH: {
                return EnumFacing.NORTH;
            }
            case WEST: {
                return EnumFacing.EAST;
            }
        }
        return facing;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        SkullDisplayEntity tile = SkullDisplay.getTile(world, pos);
        if (tile != null && world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.UP) {
            return new AxisAlignedBB(-0.125, 0.0, -0.125, 1.125, 1.25, 1.125);
        }
        if (tile != null) {
            return new AxisAlignedBB(0.0, -0.25, 0.0, 1.0, 1.0, 1.0);
        }
        return Block.field_185505_j;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new SkullDisplayEntity();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        this.checkAndDropBlock(world, pos, world.func_180495_p(pos));
    }

    private void checkAndDropBlock(World world, BlockPos pos, IBlockState state) {
        if (!SkullDisplay.canBlockStay(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.func_176226_b(world, pos, state, 0);
        }
        super.func_176208_a(world, pos, state, player);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return SkullDisplay.getItemFromTile(SkullDisplay.getTile((IBlockAccess)world, pos));
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(1);
        SkullDisplayEntity tile = SkullDisplay.getTile(world, pos);
        if (tile != null) {
            drops.add(SkullDisplay.getItemFromTile(tile));
        }
        return drops;
    }
}

