/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.entity;

import com.google.common.primitives.Ints;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import org.jurassicraft.server.api.BreedableBug;
import org.jurassicraft.server.block.entity.MachineBaseBlockEntity;
import org.jurassicraft.server.container.BugCrateContainer;
import org.jurassicraft.server.food.FoodHelper;

public class BugCrateBlockEntity
extends MachineBaseBlockEntity {
    private static final int[] INPUTS = new int[]{0, 1, 2, 3, 4, 5};
    private static final int[] OUTPUTS = new int[]{6, 7, 8};
    private NonNullList<ItemStack> slots = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);

    @Override
    protected int getProcess(int slot) {
        return 0;
    }

    @Override
    protected boolean canProcess(int process) {
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = this.func_70301_a(i);
            BreedableBug bug = BreedableBug.getBug(stack);
            if (bug == null || this.getBestFood(bug).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void processItem(int process) {
        for (int i = 0; i < 3; ++i) {
            int outputSlot;
            ItemStack food;
            ItemStack stack = this.func_70301_a(i);
            BreedableBug bug = BreedableBug.getBug(stack);
            if (bug == null || (food = this.getBestFood(bug)).func_190926_b()) continue;
            ItemStack output = new ItemStack((Item)bug, bug.getBreedings(food));
            for (int slot = 0; slot < this.slots.size(); ++slot) {
                if (this.slots.get(slot) != food) continue;
                this.decreaseStackSize(slot);
                break;
            }
            if ((outputSlot = this.getOutputSlot(output)) != -1) {
                this.mergeStack(outputSlot, output);
            } else {
                EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p(), output);
                this.field_145850_b.func_72838_d((Entity)item);
            }
            return;
        }
    }

    private ItemStack getBestFood(BreedableBug bug) {
        ItemStack best = ItemStack.field_190927_a;
        int highestBreedings = Integer.MIN_VALUE;
        for (int i = 3; i < 6; ++i) {
            int breedings;
            ItemStack food = this.func_70301_a(i);
            if (food.func_190926_b() || (breedings = bug.getBreedings(food)) <= 0 || breedings <= highestBreedings) continue;
            highestBreedings = breedings;
            best = food;
        }
        return best;
    }

    @Override
    protected int getMainOutput(int process) {
        return 0;
    }

    @Override
    protected int getStackProcessTime(ItemStack stack) {
        ItemStack food;
        BreedableBug bug = BreedableBug.getBug(stack);
        if (bug != null && (food = this.getBestFood(bug)) != null) {
            return Math.max(1, bug.getBreedings(food) / 3) * 400;
        }
        return 0;
    }

    @Override
    protected int getProcessCount() {
        return 1;
    }

    @Override
    protected int[] getInputs() {
        return INPUTS;
    }

    @Override
    protected int[] getInputs(int process) {
        return INPUTS;
    }

    @Override
    protected int[] getOutputs() {
        return OUTPUTS;
    }

    @Override
    protected NonNullList<ItemStack> getSlots() {
        return this.slots;
    }

    @Override
    protected void setSlots(NonNullList<ItemStack> slots) {
        this.slots = slots;
    }

    @Override
    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer player) {
        return new BugCrateContainer(playerInventory, this);
    }

    @Override
    public String func_174875_k() {
        return "jurassicraft:";
    }

    @Override
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.bug_crate";
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        int process;
        NonNullList<ItemStack> slots = this.getSlots();
        boolean stacksEqual = !stack.func_190926_b() && stack.func_77969_a((ItemStack)slots.get(index)) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)((ItemStack)slots.get(index)));
        slots.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (!stacksEqual && (process = this.getProcess(index)) >= 0 && process < this.getProcessCount()) {
            int prevTotalProcessTime = this.totalProcessTime[process];
            for (int i = 0; i < 3; ++i) {
                ItemStack foodStack = this.func_70301_a(i);
                BreedableBug bug = BreedableBug.getBug(foodStack);
                if (bug == null || this.getBestFood(bug) == null) continue;
                this.totalProcessTime[process] = this.getStackProcessTime(foodStack);
                break;
            }
            if (prevTotalProcessTime != this.totalProcessTime[process]) {
                this.processTime[process] = 0;
            }
            this.func_70296_d();
        }
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return Ints.asList((int[])OUTPUTS).contains(slotID);
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (Ints.asList((int[])INPUTS).contains(slotID)) {
            if ((float)slotID / 2.0f <= 1.0f && itemstack.func_77973_b() instanceof BreedableBug) {
                return true;
            }
            if (!((float)slotID / 2.0f <= 1.0f)) {
                return FoodHelper.isFood(itemstack.func_77973_b()) && !(itemstack.func_77973_b() instanceof BreedableBug);
            }
        }
        return false;
    }

    @Override
    public boolean func_191420_l() {
        return false;
    }
}

