/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.entity.CultivatorBlockEntity;

public class CultivatorCapability
implements IItemHandlerModifiable {
    private final CultivatorBlockEntity otherTile;
    public boolean isUp = false;
    private CultivatorBlockEntity mainTile;

    public CultivatorCapability(@Nullable CultivatorBlockEntity otherTile) {
        this.otherTile = otherTile;
        this.updateTile();
    }

    private void updateTile() {
        World world = this.otherTile.func_145831_w();
        BlockPos pos = this.otherTile.func_174877_v();
        if (world == null || pos == null || !world.func_175667_e(pos)) {
            return;
        }
        Block blockType = this.otherTile.func_145838_q();
        if (blockType == BlockHandler.CULTIVATOR_BOTTOM) {
            this.mainTile = this.otherTile;
            return;
        }
        if (blockType != BlockHandler.CULTIVATOR_TOP) {
            this.mainTile = null;
            return;
        }
        BlockPos blockpos = pos.func_177977_b();
        this.isUp = true;
        Block block = world.func_180495_p(blockpos).func_177230_c();
        TileEntity mainTile = world.func_175625_s(blockpos);
        if (mainTile instanceof CultivatorBlockEntity) {
            CultivatorBlockEntity mainTileTE;
            this.mainTile = mainTileTE = (CultivatorBlockEntity)mainTile;
            return;
        }
    }

    @Nullable
    private CultivatorBlockEntity getMainTile() {
        this.updateTile();
        CultivatorBlockEntity tileCultivator = this.mainTile;
        return tileCultivator != null && !tileCultivator.func_145837_r() ? tileCultivator : null;
    }

    public int getSlots() {
        CultivatorBlockEntity tile = this.getMainTile();
        return tile != null ? tile.getSlots().size() : 0;
    }

    public ItemStack getStackInSlot(int slot) {
        CultivatorBlockEntity tile = this.getMainTile();
        return tile != null ? tile.func_70301_a(slot) : ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        IItemHandler handler;
        CultivatorBlockEntity tile = this.getMainTile();
        if (tile != null && (handler = tile.getCapabilityHandler()) instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)handler).setStackInSlot(slot, stack);
        }
        if ((tile = this.getMainTile()) != null) {
            tile.func_70296_d();
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        CultivatorBlockEntity tile = this.getMainTile();
        if (tile == null) {
            return stack;
        }
        int starting = stack.func_190916_E();
        ItemStack retValue = tile.getCapabilityHandler().insertItem(slot, stack, simulate);
        if (retValue.func_190916_E() != starting && !simulate && (tile = this.getMainTile()) != null) {
            tile.func_70296_d();
        }
        return retValue;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        CultivatorBlockEntity tile = this.getMainTile();
        if (tile == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack retValue = tile.getCapabilityHandler().extractItem(slot, amount, simulate);
        if (!retValue.func_190926_b() && !simulate && (tile = this.getMainTile()) != null) {
            tile.func_70296_d();
        }
        return retValue;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }
}

