/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.entity;

import com.google.common.primitives.Ints;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import org.jurassicraft.server.api.GrindableItem;
import org.jurassicraft.server.block.entity.MachineBaseBlockEntity;
import org.jurassicraft.server.container.FossilGrinderContainer;

public class FossilGrinderBlockEntity
extends MachineBaseBlockEntity {
    private static final int[] INPUTS = new int[]{0, 1, 2, 3, 4, 5};
    private static final int[] OUTPUTS = new int[]{6, 7, 8, 9, 10, 11};
    private NonNullList<ItemStack> slots = NonNullList.func_191197_a((int)12, (Object)ItemStack.field_190927_a);

    @Override
    protected int getProcess(int slot) {
        return 0;
    }

    @Override
    protected boolean canProcess(int process) {
        for (int inputIndex = 0; inputIndex < 6; ++inputIndex) {
            ItemStack input = (ItemStack)this.slots.get(inputIndex);
            GrindableItem grindableItem = GrindableItem.getGrindableItem(input);
            if (grindableItem == null || !grindableItem.isGrindable(input)) continue;
            for (int outputIndex = 6; outputIndex < 12; ++outputIndex) {
                if (!((ItemStack)this.slots.get(outputIndex)).func_190926_b()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return Ints.asList((int[])OUTPUTS).contains(slotID);
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (Ints.asList((int[])INPUTS).contains(slotID)) {
            return itemstack != null && GrindableItem.getGrindableItem(itemstack) != null && GrindableItem.getGrindableItem(itemstack).isGrindable(itemstack);
        }
        return false;
    }

    @Override
    protected void processItem(int process) {
        GrindableItem grindableItem;
        ItemStack output;
        int emptySlot;
        Random rand = new Random();
        ItemStack input = ItemStack.field_190927_a;
        int index = 0;
        for (int inputIndex = 0; inputIndex < 6; ++inputIndex) {
            input = (ItemStack)this.slots.get(inputIndex);
            if (input.func_190926_b()) continue;
            index = inputIndex;
            break;
        }
        if (!input.func_190926_b() && (emptySlot = this.getOutputSlot(output = (grindableItem = GrindableItem.getGrindableItem(input)).getGroundItem(input, rand))) != -1) {
            this.mergeStack(emptySlot, output);
            this.decreaseStackSize(index);
        }
    }

    @Override
    protected int getMainOutput(int process) {
        return 1;
    }

    @Override
    protected int getStackProcessTime(ItemStack stack) {
        return 200;
    }

    @Override
    protected int getProcessCount() {
        return 1;
    }

    @Override
    protected int[] getInputs() {
        return INPUTS;
    }

    @Override
    protected int[] getInputs(int process) {
        return this.getInputs();
    }

    @Override
    protected int[] getOutputs() {
        return OUTPUTS;
    }

    @Override
    protected NonNullList<ItemStack> getSlots() {
        return this.slots;
    }

    @Override
    protected void setSlots(NonNullList<ItemStack> slots) {
        this.slots = slots;
    }

    @Override
    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new FossilGrinderContainer(playerInventory, (TileEntity)this);
    }

    @Override
    public String func_174875_k() {
        return "jurassicraft:fossil_grinder";
    }

    @Override
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.fossil_grinder";
    }

    @Override
    public boolean func_191420_l() {
        return false;
    }
}

