/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.fence;

import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.jurassicraft.server.block.entity.ElectricFencePoleBlockEntity;
import org.jurassicraft.server.block.entity.ElectricFenceWireBlockEntity;
import org.jurassicraft.server.block.fence.ElectricFenceBaseBlock;
import org.jurassicraft.server.block.fence.ElectricFenceWireBlock;
import org.jurassicraft.server.block.fence.FenceType;
import org.jurassicraft.server.tab.TabHandler;

public class ElectricFencePoleBlock
extends BlockContainer {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    private static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.3425, 0.0, 0.3425, 0.6575, 1.0, 0.6575);
    private final FenceType type;

    public ElectricFencePoleBlock(FenceType type) {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.func_149647_a(TabHandler.BLOCKS);
        this.func_149672_a(SoundType.field_185852_e);
        this.type = type;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new ElectricFencePoleBlockEntity();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE, NORTH, SOUTH, WEST, EAST});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        BlockPos northPos = pos.func_177972_a(EnumFacing.NORTH);
        BlockPos southPos = pos.func_177972_a(EnumFacing.SOUTH);
        BlockPos eastPos = pos.func_177972_a(EnumFacing.EAST);
        BlockPos westPos = pos.func_177972_a(EnumFacing.WEST);
        IBlockState northBlock = access.func_180495_p(northPos);
        IBlockState southBlock = access.func_180495_p(southPos);
        IBlockState westBlock = access.func_180495_p(westPos);
        IBlockState eastBlock = access.func_180495_p(eastPos);
        boolean north = this.canConnect(access, northPos, EnumFacing.NORTH, northBlock);
        boolean south = this.canConnect(access, southPos, EnumFacing.SOUTH, southBlock);
        boolean west = this.canConnect(access, westPos, EnumFacing.WEST, westBlock);
        boolean east = this.canConnect(access, eastPos, EnumFacing.EAST, eastBlock);
        boolean powered = false;
        BlockPos downPos = pos.func_177977_b();
        IBlockState down = access.func_180495_p(downPos);
        if (this.isBlockPowered(access, downPos) && down.func_177230_c() instanceof ElectricFenceBaseBlock || down.func_177230_c() instanceof ElectricFencePoleBlock && ((Boolean)down.func_185899_b(access, downPos).func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            powered = true;
        }
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(north)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(south)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(west)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(east)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(powered));
    }

    private int getRedstonePower(IBlockAccess access, BlockPos pos, EnumFacing facing) {
        IBlockState state = access.func_180495_p(pos);
        if (state.func_177230_c().shouldCheckWeakPower(state, access, pos, facing)) {
            return this.getStrongPower(access, pos);
        }
        return state.func_185911_a(access, pos, facing);
    }

    private int getStrongPower(IBlockAccess access, BlockPos pos) {
        int highest = 0;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if ((highest = Math.max(highest, access.func_175627_a(pos.func_177972_a(facing), facing))) < 15) continue;
            return highest;
        }
        return highest;
    }

    private boolean isBlockPowered(IBlockAccess access, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (this.getRedstonePower(access, pos.func_177972_a(facing), facing) <= 0) continue;
            return true;
        }
        return false;
    }

    protected boolean canConnect(IBlockAccess world, BlockPos pos, EnumFacing direction, IBlockState state) {
        if (state.func_177230_c() instanceof ElectricFenceWireBlock && ((ElectricFenceWireBlock)state.func_177230_c()).getType().equals((Object)this.type) || state.func_177230_c() instanceof ElectricFencePoleBlock && ((ElectricFencePoleBlock)state.func_177230_c()).getType().equals((Object)this.type)) {
            return true;
        }
        IBlockState down = world.func_180495_p(pos.func_177977_b());
        return down.func_177230_c() instanceof ElectricFenceWireBlock && ((EnumFacing)down.func_185899_b(world, pos).func_177229_b((IProperty)ElectricFenceWireBlock.UP_DIRECTION)).func_176734_d() == direction;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!world.field_72995_K) {
            this.updateConnectedWires(world, pos);
        }
    }

    public void updateConnectedWires(World world, BlockPos pos) {
        boolean powered = world.func_175640_z(pos.func_177977_b());
        HashSet<BlockPos> wires = new HashSet<BlockPos>();
        HashSet<BlockPos> bases = new HashSet<BlockPos>();
        this.processConnectedWires(bases, wires, world, pos.func_177977_b(), pos.func_177977_b());
        for (BlockPos wirePos : wires) {
            TileEntity tile = world.func_175625_s(wirePos);
            if (!(tile instanceof ElectricFenceWireBlockEntity)) continue;
            ElectricFenceWireBlockEntity wire = (ElectricFenceWireBlockEntity)tile;
            wire.power(pos, powered);
        }
    }

    public FenceType getType() {
        return this.type;
    }

    protected void processConnectedWires(HashSet<BlockPos> bases, HashSet<BlockPos> wires, World world, BlockPos origin, BlockPos current) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos offset;
                    if ((x == z || x == -z) && y != 0 || bases.contains(offset = current.func_177982_a(x, y, z))) continue;
                    bases.add(offset);
                    IBlockState state = world.func_180495_p(offset);
                    Block block = state.func_177230_c();
                    if (!(block instanceof ElectricFenceBaseBlock)) continue;
                    int wireX = offset.func_177958_n();
                    int wireZ = offset.func_177952_p();
                    int deltaX = wireX - origin.func_177958_n();
                    int deltaZ = wireZ - origin.func_177952_p();
                    Chunk chunk = world.func_175726_f(offset);
                    double delta = deltaX * deltaX + deltaZ * deltaZ;
                    if (!(delta <= 64.0)) continue;
                    int currentY = offset.func_177956_o();
                    while (chunk.func_186032_a(wireX, ++currentY, wireZ).func_177230_c() instanceof ElectricFenceWireBlock) {
                        BlockPos wirePos = new BlockPos(wireX, currentY, wireZ);
                        wires.add(wirePos);
                    }
                    this.processConnectedWires(bases, wires, world, origin, offset);
                }
            }
        }
    }
}

