/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.fence;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntitySenses;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jurassicraft.client.sound.SoundHandler;
import org.jurassicraft.server.block.entity.ElectricFenceWireBlockEntity;
import org.jurassicraft.server.block.fence.ElectricFenceBaseBlock;
import org.jurassicraft.server.block.fence.ElectricFencePoleBlock;
import org.jurassicraft.server.block.fence.FenceType;
import org.jurassicraft.server.damage.DamageSources;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.tab.TabHandler;

public class ElectricFenceWireBlock
extends BlockContainer {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyDirection UP_DIRECTION = PropertyDirection.func_177714_a((String)"up");
    private final FenceType type;

    public ElectricFenceWireBlock(FenceType type) {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149647_a(TabHandler.BLOCKS);
        this.func_149672_a(SoundType.field_185852_e);
        this.type = type;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        if (entity instanceof DinosaurEntity) {
            Dinosaur dinosaur = ((DinosaurEntity)entity).getDinosaur();
            return dinosaur.getMetadata().canClimb();
        }
        return entity instanceof EntityPlayer;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_185899_b(world, pos);
        boolean north = (Boolean)state.func_177229_b((IProperty)NORTH);
        boolean south = (Boolean)state.func_177229_b((IProperty)SOUTH);
        boolean west = (Boolean)state.func_177229_b((IProperty)WEST);
        boolean east = (Boolean)state.func_177229_b((IProperty)EAST);
        if (!(north || south || west || east)) {
            north = true;
            south = true;
            west = true;
            east = true;
        }
        double minX = 0.4;
        double minZ = 0.4;
        double maxX = 0.6;
        double maxZ = 0.6;
        if (north) {
            minZ = 0.0;
        }
        if (south) {
            maxZ = 1.0;
        }
        if (west) {
            minX = 0.0;
        }
        if (east) {
            maxX = 1.0;
        }
        return new AxisAlignedBB(minX, 0.0, minZ, maxX, 1.0, maxZ);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 4; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            if (!element.getClassName().equals(EntitySenses.class.getName())) continue;
            return field_185506_k;
        }
        return super.func_180646_a(state, world, pos);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new ElectricFenceWireBlockEntity();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, SOUTH, WEST, EAST, UP_DIRECTION});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean north = false;
        boolean south = false;
        boolean east = false;
        boolean west = false;
        EnumFacing up = EnumFacing.DOWN;
        block6: for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos offset = pos.func_177972_a(facing);
            if (!this.canConnect(world, pos, offset, world.func_180495_p(offset))) continue;
            switch (facing) {
                case NORTH: {
                    north = true;
                    continue block6;
                }
                case SOUTH: {
                    south = true;
                    continue block6;
                }
                case WEST: {
                    west = true;
                    continue block6;
                }
                case EAST: {
                    east = true;
                    continue block6;
                }
            }
        }
        BlockPos.MutableBlockPos basePos = new BlockPos.MutableBlockPos(pos);
        this.findBase(world, basePos);
        if (world.func_180495_p((BlockPos)basePos).func_177230_c() instanceof ElectricFenceBaseBlock) {
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                BlockPos offset = basePos.func_177972_a(facing);
                BlockPos topOffset = offset.func_177984_a();
                if (!this.canConnect(world.func_180495_p(topOffset = topOffset.func_177981_b(this.getFenceHeight(world, new BlockPos.MutableBlockPos(topOffset)) + 1)))) continue;
                BlockPos.MutableBlockPos connectBasePos = new BlockPos.MutableBlockPos(topOffset);
                this.findBase(world, connectBasePos);
                if (connectBasePos.func_177956_o() < basePos.func_177956_o() || !(world.func_180495_p((BlockPos)connectBasePos).func_177230_c() instanceof ElectricFenceBaseBlock) || world.func_180495_p(offset).func_177230_c() instanceof ElectricFenceBaseBlock) continue;
                up = facing;
                break;
            }
        }
        if (!(west || north || south || east)) {
            east = true;
            south = true;
            north = true;
            west = true;
        }
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(north)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(south)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(west)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(east)).func_177226_a((IProperty)UP_DIRECTION, (Comparable)up);
    }

    private void findBase(IBlockAccess world, BlockPos.MutableBlockPos basePos) {
        IBlockState downState;
        int moved = 0;
        while (basePos.func_177956_o() > 1 && !((downState = world.func_180495_p((BlockPos)basePos)).func_177230_c() instanceof ElectricFenceBaseBlock) && moved < 5) {
            basePos.func_185336_p(basePos.func_177956_o() - 1);
            if (downState.func_177230_c() instanceof ElectricFenceWireBlock) {
                moved = 0;
                continue;
            }
            ++moved;
        }
    }

    private int getFenceHeight(IBlockAccess world, BlockPos.MutableBlockPos pos) {
        int height = 0;
        BlockPos start = new BlockPos((Vec3i)pos);
        if (world.func_180495_p((BlockPos)pos).func_177230_c() instanceof ElectricFenceWireBlock) {
            IBlockState state = world.func_180495_p((BlockPos)pos);
            while (pos.func_177956_o() < 255 && state.func_177230_c() instanceof ElectricFenceWireBlock) {
                pos.func_185336_p(pos.func_177956_o() + 1);
                state = world.func_180495_p((BlockPos)pos);
                ++height;
            }
            pos.func_189533_g((Vec3i)start);
            while (pos.func_177956_o() > 1 && state.func_177230_c() instanceof ElectricFenceWireBlock) {
                pos.func_185336_p(pos.func_177956_o() - 1);
                state = world.func_180495_p((BlockPos)pos);
                ++height;
            }
        }
        return height;
    }

    protected boolean canConnect(IBlockState state) {
        return state.func_177230_c() instanceof ElectricFenceWireBlock && ((ElectricFenceWireBlock)state.func_177230_c()).getType().equals((Object)this.type) || state.func_177230_c() instanceof ElectricFencePoleBlock;
    }

    protected boolean canConnect(IBlockAccess world, BlockPos current, BlockPos pos, IBlockState state) {
        if (this.canConnect(state)) {
            return true;
        }
        IBlockState down = world.func_180495_p(pos.func_177977_b());
        return down.func_177230_c() instanceof ElectricFenceWireBlock && Math.abs(current.func_177956_o() - pos.func_177977_b().func_177956_o()) == 1;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof ElectricFenceWireBlockEntity) {
            ((ElectricFenceWireBlockEntity)tile).checkDisconnect();
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        super.func_180634_a(world, pos, state, entity);
        if (!world.field_72995_K && !entity.field_70128_L && entity instanceof EntityLivingBase) {
            TileEntity tile = world.func_175625_s(pos);
            ElectricFenceWireBlock block = (ElectricFenceWireBlock)state.func_177230_c();
            if (tile instanceof ElectricFenceWireBlockEntity && ((ElectricFenceWireBlockEntity)tile).isPowered()) {
                if (block.getType().equals((Object)FenceType.LOW)) {
                    entity.func_70097_a(DamageSources.SHOCK, 1.0f);
                }
                if (block.getType().equals((Object)FenceType.MED)) {
                    entity.func_70097_a(DamageSources.SHOCK, 2.0f);
                }
                if (block.getType().equals((Object)FenceType.HIGH)) {
                    entity.func_70097_a(DamageSources.SHOCK, 3.0f);
                }
                if (block.getType().equals((Object)FenceType.RAPTOR)) {
                    entity.func_70097_a(DamageSources.SHOCK, 4.0f);
                }
                if (entity instanceof DinosaurEntity) {
                    DinosaurEntity dinosaur = (DinosaurEntity)entity;
                    if (dinosaur.wireTicks < 2) {
                        ++dinosaur.wireTicks;
                        dinosaur.disableHerdingTicks = 200;
                    }
                }
                if (entity.field_70173_aa % 10 == 0) {
                    world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundHandler.FENCE_SHOCK, SoundCategory.BLOCKS, 0.25f, 1.0f);
                }
            }
        }
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public FenceType getType() {
        return this.type;
    }
}

