/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.tree;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.tuple.Pair;
import org.jurassicraft.server.api.GrindableItem;
import org.jurassicraft.server.block.tree.TreeType;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.plant.PlantHandler;
import org.jurassicraft.server.tab.TabHandler;

public class AncientLogBlock
extends BlockLog
implements GrindableItem {
    private final boolean petrified;
    private final TreeType type;

    public AncientLogBlock(TreeType treeType, boolean petrified) {
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
        this.func_149711_c(2.0f);
        this.func_149752_b(0.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(TabHandler.PLANTS);
        this.petrified = petrified;
        this.type = treeType;
        String name = treeType.name().toLowerCase(Locale.ENGLISH) + "_log";
        if (petrified) {
            name = name + "_petrified";
            this.setHarvestLevel("pickaxe", 2);
            this.func_149711_c(4.0f);
            this.func_149752_b(4.0f);
        }
        this.func_149663_c(name);
    }

    public TreeType getType() {
        return this.type;
    }

    public boolean isPetrified() {
        return this.petrified;
    }

    public Material func_149688_o(IBlockState state) {
        return this.petrified ? Material.field_151576_e : super.func_149688_o(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.values()[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockLog.EnumAxis)state.func_177229_b((IProperty)field_176299_a)).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176299_a});
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, 0);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Override
    public boolean isGrindable(ItemStack stack) {
        return this.isPetrified();
    }

    @Override
    public ItemStack getGroundItem(ItemStack stack, Random random) {
        NBTTagCompound tag = stack.func_77978_p();
        int outputType = random.nextInt(6);
        if (outputType == 5) {
            ItemStack output = new ItemStack((Item)ItemHandler.PLANT_SOFT_TISSUE, 1, PlantHandler.getPlantId(this.type.getPlant()));
            output.func_77982_d(tag);
            return output;
        }
        if (outputType < 3) {
            return new ItemStack(Items.field_151100_aR, 1, 15);
        }
        return new ItemStack(Items.field_151145_ak);
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        float single = 16.666666f;
        NBTTagCompound tag = inputItem.func_77978_p();
        ItemStack output = new ItemStack((Item)ItemHandler.PLANT_SOFT_TISSUE, 1, PlantHandler.getPlantId(this.type.getPlant()));
        output.func_77982_d(tag);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)Float.valueOf(single), (Object)output), Pair.of((Object)Float.valueOf(50.0f), (Object)new ItemStack(Items.field_151100_aR, 1, 15)), Pair.of((Object)Float.valueOf(single * 2.0f), (Object)new ItemStack(Items.field_151145_ak))});
    }
}

